#include "mbed.h"
#include "SpwfInterface.h"
#include "NTPClient.h"
#include "TCPSocket.h"

//www.mbed.com CA certificate in PEM format
char  CA_cert []="-----BEGIN CERTIFICATE-----\r\n"
"MIIDVDCCAjygAwIBAgIDAjRWMA0GCSqGSIb3DQEBBQUAMEIxCzAJBgNVBAYTAlVT\r\n"
"MRYwFAYDVQQKEw1HZW9UcnVzdCBJbmMuMRswGQYDVQQDExJHZW9UcnVzdCBHbG9i\r\n"
"YWwgQ0EwHhcNMDIwNTIxMDQwMDAwWhcNMjIwNTIxMDQwMDAwWjBCMQswCQYDVQQG\r\n"
"EwJVUzEWMBQGA1UEChMNR2VvVHJ1c3QgSW5jLjEbMBkGA1UEAxMSR2VvVHJ1c3Qg\r\n"
"R2xvYmFsIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2swYYzD9\r\n"
"9BcjGlZ+W988bDjkcbd4kdS8odhM+KhDtgPpTSEHCIjaWC9mOSm9BXiLnTjoBbdq\r\n"
"fnGk5sRgprDvgOSJKA+eJdbtg/OtppHHmMlCGDUUna2YRpIuT8rxh0PBFpVXLVDv\r\n"
"iS2Aelet8u5fa9IAjbkU+BQVNdnARqN7csiRv8lVK83Qlz6cJmTM386DGXHKTubU\r\n"
"1XupGc1V3sjs0l44U+VcT4wt/lAjNvxm5suOpDkZALeVAjmRCw7+OC7RHQWa9k0+\r\n"
"bw8HHa8sHo9gOeL6NlMTOdReJivbPagUvTLrGAMoUgRx5aszPeE4uwc2hGKceeoW\r\n"
"MPRfwCvocWvk+QIDAQABo1MwUTAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTA\r\n"
"ephojYn7qwVkDBF9qn1luMrMTjAfBgNVHSMEGDAWgBTAephojYn7qwVkDBF9qn1l\r\n"
"uMrMTjANBgkqhkiG9w0BAQUFAAOCAQEANeMpauUvXVSOKVCUn5kaFOSPeCpilKIn\r\n"
"Z57QzxpeR+nBsqTP3UEaBU6bS+5Kb1VSsyShNwrrZHYqLizz/Tt1kL/6cdjHPTfS\r\n"
"tQWVYrmm3ok9Nns4d0iXrKYgjy6myQzCsplFAMfOEVEiIuCl6rYVSAlk6l5PdPcF\r\n"
"PseKUgzbFbS9bZvlxrFUaKnjaZC2mqUPuLk/IH2uSrW4nOQdtqvmlKXBx4Ot2/Un\r\n"
"hw4EbNX/3aBd7YdStysVAq45pmp06drE57xNNB6pXE0zX5IJL4hmXXeXxx12E6nV\r\n"
"5fEWCRE11azbJHFwLJhWC9kXtNHjUStedejV0NxPNO3CBWaAocvmMw==\r\n"
"-----END CERTIFICATE-----\r\n";

SpwfSAInterface spwf(D8, D2, false);  // Wifi interface
DigitalOut myled(LED1);

int main() 
{
    time_t ctTime;
    ctTime = time(NULL);
    
    printf ("\n\rConnecting to WiFi ...\n\r");  
    spwf.connect("STM","STMDemo", NSAPI_SECURITY_WPA2);
    NTPClient ntp(spwf);        

    printf("Initial System Time is: %s\r\n", ctime(&ctTime));   
    printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0)
    {
      printf("Set time successfully\r\n");
      ctTime = time(NULL);
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
      if (!spwf.set_time(ctTime)) printf ("ERROR set_time\n\r");     
      if (!spwf.clean_TLS_certificate(ALL)) printf ("ERROR clean_TLS_certificate\n\r");
      if (!spwf.set_TLS_certificate(CA_cert, sizeof(CA_cert), FLASH_CA_ROOT_CERT)) printf ("ERROR set_TLS_certificate\n\r");
      if (!spwf.set_TLS_SRV_domain("*.mbed.com",FLASH_DOMAIN)) printf ("ERROR set_TLS_CA_domain\n\r");
// NOTE:  DNS requires UDP socket. DNS is invoked while connecting a secure socket to resolve URL to IP,
//         so DNS doesnt answer as it requires unsecure UDP socket connection.
//         workaroud: convert URL to IP quering DNS before secure socket creation, then connect 
//         the secure socket created to the  retrieved IP.
      SocketAddress addr(&spwf, "www.mbed.com", 443);  // must be called BEFORE set_secure_socket() to allow DNS udp connection
      spwf.set_secure_mode();     
      TCPSocket  socket(&spwf);   
      spwf.set_unsecure_mode();                  
      int err = socket.connect(addr);
      if (err != 0 )printf ("ERROR opening %d\n\r", err);
      else printf ("--->>> Secure socket CONNECTED to: %s\n\r", addr.get_ip_address());
      socket.close();      
      printf ("Socket closed\n\r");
    }  
    else
    {
      printf("Error: NTP could not contact server\r\n");
    }    
    spwf.disconnect();
    printf ("WIFI disconnected, exiting ...\n\r");

    while(1) { 
      wait(1);
      myled = !myled;
    }    
}
