/**
  ******************************************************************************
  * @file       SampleSync_writeUrl.cpp
  * @author     ST / Central Labs
  * @date       03 Dic 2015
  * @brief      This demo write an ndef message with an url inside
  ******************************************************************************
  *
  * COPYRIGHT(c) 2015 STMicroelectronics
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */
  
#include "mbed.h"

#include "XNucleoNFC01A1.h"
#include "NDefLib/NDefNfcTag.h"
#include "NDefLib/RecordType/RecordURI.h"

/**
 * Write a Ndef linking the st.com site.
 */
void sampleSync_writeUrl() {    
    I2C i2cChannel(XNucleoNFC01A1::DEFAULT_SDA_PIN,XNucleoNFC01A1::DEFAULT_SDL_PIN);
    XNucleoNFC01A1 *nfcNucleo = XNucleoNFC01A1::instance(i2cChannel);

    //retrieve the NdefLib interface
    NDefLib::NDefNfcTag& tag = nfcNucleo->get_M24SR().get_NDef_tag();
    printf("System Init done: !\r\n");
    //open the i2c session with the nfc chip
    if (tag.open_session()) {
        nfcNucleo->get_led1()=1;
        
        //create the NDef message and record
        NDefLib::Message msg;
        NDefLib::RecordURI rUri(NDefLib::RecordURI::HTTP_WWW,"st.com");
        msg.add_record(&rUri);

        //write the tag
        if (tag.write(msg)) {
            printf("Tag written \r\n");
            nfcNucleo->get_led2()=1;
        }

    
        //close the i2c session
        if (!tag.close_session()) {
            printf("Error Closing the session\r\n");
        } else {
            nfcNucleo->get_led3()=1;
        }
    } else {
        printf("Error open Session\r\n");
    }
}
