#if 0
#include "mbed.h"

#include "Type4NfcTagSTM24SR.h"

#include "NDefLib/RecordType/RecordAAR.h"
#include "NDefLib/RecordType/RecordSMS.h"
#include "NDefLib/RecordType/RecordGeo.h"
#include "NDefLib/RecordType/RecordURI.h"
#include "NDefLib/RecordType/RecordMail.h"
#include "NDefLib/RecordType/RecordText.h"
#include "NDefLib/RecordType/RecordMimeType.h"
#include "NDefLib/RecordType/RecordVCard.h"

#include "X_NUCLEO_NFC01A1.h"

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);

void shiftLed(DigitalOut &led1,DigitalOut &led2,DigitalOut &led3){
	const uint8_t prevLed1=led1;
	const uint8_t prevLed2=led2;
	const uint8_t prevLed3=led3;
	led1=prevLed3;
	led2=prevLed1;
	led3=prevLed2;
}

static const uint32_t MAX_WRITE_TRY=1;

void setNFCTag(NDefLib::Type4NfcTag &tag){

	bool writeStatus,closeStatus;
	if(tag.openSession()){
		NDefLib::Message msg;

		NDefLib::RecordAAR rAAR("com.st.BlueMS");
		msg.addRecord(&rAAR);

		NDefLib::RecordSMS rSMS("123456789","st.com.BlueMS");
		msg.addRecord(&rSMS);

		NDefLib::RecordGeo rGeo(123.123,-456.789);
		msg.addRecord(&rGeo);

		NDefLib::RecordURI rUri(NDefLib::RecordURI::HTTP_WWW,"http://www.st.com");
		msg.addRecord(&rUri);

		NDefLib::RecordMail rMail("mail@st.com","ciao","da nfc tag");
		msg.addRecord(&rMail);

		NDefLib::RecordMimeType rText1("text/plain",(const uint8_t*)"ciao",4);
		msg.addRecord(&rText1);

		NDefLib::RecordText rText3(NDefLib::RecordText::UTF8,"it","ciao");
		msg.addRecord(&rText3);

		NDefLib::RecordVCard::VCardInfo_t cardInfo;
		cardInfo[NDefLib::RecordVCard::FORMATTED_NAME]="prova prova1";
		cardInfo[NDefLib::RecordVCard::ADDRESS_HOME]=";;1 Main St.;Springfield;IL;12345;USA";
		cardInfo[NDefLib::RecordVCard::ADDRESS_WORK]=";;2 Main St.;Springfield;IL;12345;USA";
		cardInfo[NDefLib::RecordVCard::EMAIL_WORK]="workmail@st.com";
		cardInfo[NDefLib::RecordVCard::EMAIL_HOME]="homemail@st.com";
		cardInfo[NDefLib::RecordVCard::GEO]="39.95;-75.1667";
		cardInfo[NDefLib::RecordVCard::IMPP]="aim:johndoe@aol.com";
		cardInfo[NDefLib::RecordVCard::NAME]="prova2;prova3";
		cardInfo[NDefLib::RecordVCard::NICKNAME]="test";
		cardInfo[NDefLib::RecordVCard::NOTE]="A good test";
		cardInfo[NDefLib::RecordVCard::ORGANIZATION]="STM";
		cardInfo[NDefLib::RecordVCard::TEL_HOME]="123";
		cardInfo[NDefLib::RecordVCard::TEL_MOBILE]="456";
		cardInfo[NDefLib::RecordVCard::TEL_WORK]="789";
		cardInfo[NDefLib::RecordVCard::TITLE]="King";
		cardInfo[NDefLib::RecordVCard::URL]="www.st.com";
		cardInfo[NDefLib::RecordVCard::PHOTO_URI]="http://www.st.com/st-web-ui/static/active/en/fragment/multimedia/image/picture/customer_focus.jpg";
		NDefLib::RecordVCard rVCard(cardInfo);
		msg.addRecord(&rVCard);

		uint32_t writeTry=0;
		do{
			writeStatus = tag.write(msg);
			writeTry++;
		}while(!writeStatus && writeTry<MAX_WRITE_TRY);

		closeStatus = tag.closeSession();

	}else
		pc.printf("Error open Session\n\r");

	if(writeStatus)
		pc.printf("writeOk\n\r");
	else
		pc.printf("writeFail\n\r");

	if(closeStatus)
		pc.printf("closeOk\n\r");
	else
		pc.printf("CloseFail\n\r");

/*
	sURI_Info URI;
	sAARInfo aar;
	sSMSInfo sms;
	std::strcpy(sms.PhoneNumber,"123456789\0");
	std::strcpy(sms.Message,"st.com.BlueMS\0");
	std::strcpy(sms.Information,"\0");

	std::strcpy(aar.PakageName,"st.com.BlueMS");

	// Prepare URI NDEF message content
	std::strcpy(URI.protocol,URI_ID_0x01_STRING);
	std::strcpy(URI.URI_Message,"st3.com");
	std::strcpy(URI.Information,"\0");


	 while (TT4_Init() != NFC_OK);
		// Prepare URI NDEF message content
		std::strcpy(URI.protocol,URI_ID_0x01_STRING);
		std::strcpy(URI.URI_Message,"st2.com");
		std::strcpy(URI.Information,"\0");
	 //while (TT4_WriteURI(&URI) != NFC_OK);
	while (TT4_WriteSMS(&sms) != NFC_OK);
	//while (TT4_Write(&sms) != NFC_OK);
*/
}

void printRecord(NDefLib::Record *r){
	using namespace NDefLib;
	switch(r->getType()){
		case Record::TYPE_TEXT:	{
			RecordText *temp = (RecordText*)r;
			pc.printf("Read Text: %s\r\n",temp->getText().c_str());
			break; }
		case Record::TYPE_AAR:{
			RecordAAR *temp = (RecordAAR*)r;
			pc.printf("Read ARR: %s\r\n",temp->getPackage().c_str());
			break; }
		case Record::TYPE_MIME:{
			RecordMimeType *temp = (RecordMimeType*)r;
			pc.printf("Read mimeType: %s\r\n",temp->getMimeType().c_str());
			pc.printf("Read mimeData: %s\r\n",
					std::string((const char*)temp->getMimeData(),
							temp->getMimeDataLenght()).c_str());
			break;}
		case Record::TYPE_URI:{
			RecordURI *temp = (RecordURI*)r;
			pc.printf("Read uriId: %d\r\n",temp->getUriId());
			pc.printf("Read uriType: %s\r\n",temp->getUriType().c_str());
			pc.printf("Read uriContent: %s\r\n",temp->getContent().c_str());
			break;}
		case Record::TYPE_URI_MAIL:{
			RecordMail *temp = (RecordMail*)r;
			pc.printf("Read Dest: %s\r\n",temp->getToAddress().c_str());
			pc.printf("Read Subject: %s\r\n",temp->getSubject().c_str());
			pc.printf("Read Body: %s\r\n",temp->getBody().c_str());
			break;}
		case Record::TYPE_URI_SMS:{
			RecordSMS *temp = (RecordSMS*)r;
			pc.printf("Read number: %s\r\n",temp->getNumber().c_str());
			pc.printf("Read message: %s\r\n",temp->getMessagge().c_str());
			break;}
		case Record::TYPE_URI_GEOLOCATION:{
			RecordGeo *temp = (RecordGeo*)r;
			pc.printf("Read lat: %f\r\n",temp->getLatitude());
			pc.printf("Read long: %f\r\n",temp->getLongitude());
			break;}
		case Record::TYPE_MIME_VCARD:{
			const RecordVCard *temp = (RecordVCard*)r;
			pc.printf("Read Name: %s\r\n",(*temp)[RecordVCard::NAME].c_str());
			pc.printf("Read Mail: %s\r\n",(*temp)[RecordVCard::EMAIL_WORK].c_str());
			pc.printf("Read ORG: %s\r\n",(*temp)[RecordVCard::ORGANIZATION].c_str());
			break;}
		case Record::TYPE_UNKNOWN:{
			pc.printf("Unknown record\r\n");
			break;}
	}//switch
}

void changeRecord(NDefLib::Record *r){
	using namespace NDefLib;
	switch(r->getType()){
		case Record::TYPE_TEXT:	{
			RecordText *temp = (RecordText*)r;
			temp->setText("CIAOCiao");
			break; }
		case Record::TYPE_AAR:{
			RecordAAR *temp = (RecordAAR*)r;
			temp->setPackage("set Package Ok");
			break; }
		case Record::TYPE_MIME:{
			RecordMimeType *temp = (RecordMimeType*)r;
			temp->copyMimeData((const uint8_t *)"String2",sizeof("String2"));
			break;}
		case Record::TYPE_URI:{
			RecordURI *temp = (RecordURI*)r;
			temp->setContent("google.it");
			break;}
		case Record::TYPE_URI_MAIL:{
			RecordMail *temp = (RecordMail*)r;
			temp->setToAddress("newMail@st.com");
			temp->setSubject("tag change");
			temp->setBody("read/change Works!");
			break;}
		case Record::TYPE_URI_SMS:{
			RecordSMS *temp = (RecordSMS*)r;
			temp->setMessage("Message Change");
			temp->setNumber("0987654321");
			break;}
		case Record::TYPE_URI_GEOLOCATION:{
			RecordGeo *temp = (RecordGeo*)r;
			temp->setLatitude(-temp->getLatitude());
			temp->setLongitude(-temp->getLongitude());
			break;}
		case Record::TYPE_MIME_VCARD:{
			RecordVCard *temp = (RecordVCard*)r;
			(*temp)[RecordVCard::NAME]="name change";
			(*temp)[RecordVCard::NICKNAME]="nic change";
			break;}
		case Record::TYPE_UNKNOWN:{
			pc.printf("Unknown record\r\n");
			break;}
	}//switch
}

void readNfcTag(NDefLib::Type4NfcTag &tag){
	using namespace NDefLib;

	if(tag.openSession()){
		NDefLib::Message readMsg;

		tag.read(&readMsg);

		if(readMsg.getNRecords()==0){
			pc.printf("Error Read\r\n");
		}else{
			for(uint32_t i=0;i<readMsg.getNRecords();i++){
				Record *r = readMsg[i];
				printRecord(r);
				delete r;
			}//for
		}//if-else

		tag.closeSession();
	}else{
		pc.printf("Error open Session2\n\r");
	}
}


void changeNfcTag(NDefLib::Type4NfcTag &tag){
	using namespace NDefLib;

	if(tag.openSession()){
		NDefLib::Message readMsg;

		tag.read(&readMsg);

		if(readMsg.getNRecords()==0){
			pc.printf("Error Read\r\n");
		}else{
			for(uint32_t i=0;i<readMsg.getNRecords();i++){
				Record *r = readMsg[i];
				changeRecord(r);
			}//for
			tag.write(readMsg);
		}//if-else

		tag.closeSession();
	}else{
		pc.printf("Error open SessionChange\n\r");
	}
}

static bool buttonPress=false;
void setButtonPress(){
	buttonPress=true;
}

int main() {
	I2C i2cChannel(X_NUCLEO_NFC01A1::DEFAULT_SDA_PIN,X_NUCLEO_NFC01A1::DEFAULT_SDL_PIN);
	i2cChannel.frequency(400000);
	X_NUCLEO_NFC01A1 *nfcNucleo = X_NUCLEO_NFC01A1::Instance(i2cChannel);
	Type4NfcTagSTM24SR tag(nfcNucleo->getM24SR());
	InterruptIn mybutton(USER_BUTTON);
	pc.printf("Hello World !\n\r");
	nfcNucleo->getLed1()=1;
	nfcNucleo->getLed2()=0;
	nfcNucleo->getLed3()=0;

	setNFCTag(tag);
	readNfcTag(tag);

	mybutton.fall(setButtonPress);

	while(1) {
		wait(1);
		myled = !myled;
		shiftLed(nfcNucleo->getLed1(),nfcNucleo->getLed2(),nfcNucleo->getLed3());
		if(buttonPress){
			changeNfcTag(tag);
			readNfcTag(tag);
			buttonPress=false;
		}
	}

}
#endif

#if 0
#include "mbed.h"

#include "Type4NfcTagSTM24SR.h"
#include "NDefLib/RecordType/RecordURI.h"

#include "X_NUCLEO_NFC01A1.h"

int main() {
	Serial pc(SERIAL_TX, SERIAL_RX);
	I2C i2cChannel(X_NUCLEO_NFC01A1::DEFAULT_SDA_PIN,X_NUCLEO_NFC01A1::DEFAULT_SDL_PIN);
	i2cChannel.frequency(400000);
	X_NUCLEO_NFC01A1 *nfcNucleo = X_NUCLEO_NFC01A1::Instance(i2cChannel);
	//create the wrapper for use the NdefLib
	Type4NfcTagSTM24SR tag(nfcNucleo->getM24SR());
	pc.printf("System Init done: !\n\r");
	//open the i2c session with the nfc chip
	if(tag.openSession()){
		nfcNucleo->getLed1()=1;
		
		//create the NDef message and record
		NDefLib::Message msg;
		NDefLib::RecordURI rUri(NDefLib::RecordURI::HTTP_WWW,"st.com");
		msg.addRecord(&rUri);

		//write the tag
		if(tag.write(msg)){
			pc.printf("Tag writed \n\r");
			nfcNucleo->getLed2()=1;
		}

	
		//close the i2c session
		if(!tag.closeSession()){
			pc.printf("Error Closing the session\n\r");
		}else
			nfcNucleo->getLed3()=1;
	}else
		pc.printf("Error open Session\n\r");
	
	return 0;
}

#endif

#if 1

#include "mbed.h"

#include "Type4NfcTagSTM24SR.h"
#include "NDefLib/RecordType/RecordText.h"

#include "X_NUCLEO_NFC01A1.h"

class MyRecord : public NDefLib::RecordText{
	
private:
	char nClickStringBuffer[12];
	uint32_t nClick;
	
	void syncTextValue(){
		sprintf(nClickStringBuffer,"%d",nClick);
		setText(nClickStringBuffer);
	}
		
public:	
	
	MyRecord():nClick(0){
		syncTextValue();
	}
	
	void incrementClick(){
		nClick++;
		syncTextValue();
	}

};

static volatile bool buttonPress=false;

void setButtonPress(){
	buttonPress=true;
}//if buttonPress

void writeMessage(X_NUCLEO_NFC01A1 *nfcNucleo,NDefLib::Message &msg){
	Type4NfcTagSTM24SR tag(nfcNucleo->getM24SR());
	//open the i2c session with the nfc chip
	if(tag.openSession()){
		nfcNucleo->getLed1()=! nfcNucleo->getLed1();
		
		//write the tag
		if(tag.write(msg)){
			nfcNucleo->getLed2()=!nfcNucleo->getLed2();
		}//if

		//close the i2c session
		if(tag.closeSession())
			nfcNucleo->getLed3()=!nfcNucleo->getLed3();
	}//if open session
}

void main() {
	I2C i2cChannel(X_NUCLEO_NFC01A1::DEFAULT_SDA_PIN,X_NUCLEO_NFC01A1::DEFAULT_SDL_PIN);
	i2cChannel.frequency(400000);

	X_NUCLEO_NFC01A1 *nfcNucleo = X_NUCLEO_NFC01A1::Instance(i2cChannel);
	//create the wrapper for use the NdefLib
	Type4NfcTagSTM24SR tag(nfcNucleo->getM24SR());
	
	InterruptIn userButton(USER_BUTTON);	
	userButton.fall(setButtonPress);
	
	//create the NDef message and record
	NDefLib::Message msg;
	MyRecord rClickCount;
	msg.addRecord(&rClickCount);
	
	writeMessage(nfcNucleo,msg);
	
	while(1){
		
		if(buttonPress){
			rClickCount.incrementClick();
			writeMessage(nfcNucleo,msg);			
			buttonPress=false;
		}//if
		
	}//while

}//main

#endif
