/*
 * X_NUCLEO_NFC01A1.cpp
 *
 *  Created on: Nov 5, 2015
 *      Author: giovanni visentini
 */

#include <X_NUCLEO_NFC01A1.h>

const uint8_t  X_NUCLEO_NFC01A1::M24SR_ADDR=0xAC;
const PinName  X_NUCLEO_NFC01A1::DEFAULT_SDA_PIN=D14;
const PinName  X_NUCLEO_NFC01A1::DEFAULT_SDL_PIN=D15;



const PinName X_NUCLEO_NFC01A1::GPO_PIN=D12;
const PinName X_NUCLEO_NFC01A1::RF_DISABLE_PIN=D11;
const PinName X_NUCLEO_NFC01A1::LED1_PIN=D5;
const PinName X_NUCLEO_NFC01A1::LED2_PIN=D4;
const PinName X_NUCLEO_NFC01A1::LED3_PIN=D2;

X_NUCLEO_NFC01A1 *X_NUCLEO_NFC01A1::mInstance = NULL;

X_NUCLEO_NFC01A1* X_NUCLEO_NFC01A1::Instance(I2C &devI2C) {
	if (mInstance == NULL) { // the first time
		mInstance = new X_NUCLEO_NFC01A1(devI2C);
		if (mInstance != NULL) { //allocation ok
			const int status = mInstance->mM24SR.Init(NULL);
			if (status != NFC_SUCCESS) { //initialization failed
				delete mInstance;
				error(
						"Failed to init X_NUCLEO_NFC01A1 expansion board!\r\nError:0x%X\r\n",
						status);
			} //if init
		} //if instance !=NULL
	} //if instance
	return mInstance;
}
