/*
 * Type4NfcTagSTM24SR.cpp
 *
 *  Created on: Nov 5, 2015
 *      Author: giovanni visentini
 */

#include <Type4NfcTagSTM24SR.h>

/* wait 1sec, driver is configured to let 200ms for command to complete */
/* which is enough for all commands except GetSession if RF session is already opened */
/* Smartphone generaly release the session within the second, but customer can modify this value */
#define OPENSESSION_NTRIALS 5

#define CC_FILE_LENGTH_BYTE 15

bool Type4NfcTagSTM24SR::openSession(bool force) {

	if (isSessionOpen())
		return true;
	//else
	if (force)
		mDevice.KillSession();

	int8_t nTrials = OPENSESSION_NTRIALS;
	NFC_StatusTypeDef status = NFC_ERROR;
	while (status != NFC_SUCCESS && nTrials) {
		status = mDevice.GetSession();
		nTrials--;
	}

	if (status != NFC_SUCCESS) {
		return false;
	} //else

	//Select the NFC type 4 application
	if (mDevice.SelectApplication() != NFC_SUCCESS)
		return false;

	if (mDevice.SelectCCfile() != NFC_SUCCESS)
		return false;

	uint8_t CCFile[CC_FILE_LENGTH_BYTE];
	/* read the first 15 bytes of the CC file */
	if (mDevice.ReadBinary(0x0000, CC_FILE_LENGTH_BYTE, CCFile) != NFC_SUCCESS)
		return false;

	//read the ndefFileId
	uint16_t ndefFileId = (uint16_t) ((CCFile[0x09] << 8) | CCFile[0x0A]);
	mMaxReadBytes = (uint16_t) ((CCFile[0x03] << 8) | CCFile[0x04]);
	mMaxWriteBytes = (uint16_t) ((CCFile[0x05] << 8) | CCFile[0x06]);

	//openit
	if (mDevice.SelectNDEFfile(ndefFileId) != NFC_SUCCESS)
		return false;

	Type4NfcTag::openSession();
	return true;
}

bool Type4NfcTagSTM24SR::closeSession() {

	//no open session
	if (!isSessionOpen())
		return true;

	//close the CC file
	if (mDevice.Deselect() != NFC_SUCCESS)
		return false;

	Type4NfcTag::closeSession();
	return true;
}

bool Type4NfcTagSTM24SR::writeByte(const uint8_t *buffer, uint16_t length, uint16_t offset) {

	NFC_StatusTypeDef status = NFC_SUCCESS;
	bool prevSessionStatus = isSessionOpen();
	if (!prevSessionStatus) {
		//try to acquire a session or fail
		if (openSession(false))
			return false;
	} //if

	if (length > mMaxWriteBytes) {
		do {
			status = mDevice.UpdateBinary(offset, mMaxWriteBytes,(uint8_t*) buffer);
			offset += mMaxWriteBytes;
			buffer += mMaxWriteBytes;
			length -= mMaxWriteBytes;
		} while (length > mMaxWriteBytes && status == NFC_SUCCESS);
	} //if

	//finish to write the buffer
	if (status == NFC_SUCCESS && mMaxWriteBytes)
		status = mDevice.UpdateBinary(offset, length,(uint8_t*) buffer);

	if (status == NFC_SUCCESS) {
		if (!prevSessionStatus) // if the session was closed, try close it
			return closeSession();
		else
			return true;
	} else
		return false;
}

bool Type4NfcTagSTM24SR::readByte(uint16_t byteOffset, uint16_t byteLength,
		uint8_t *buffer) {
	NFC_StatusTypeDef status = NFC_SUCCESS;
	uint16_t offset = byteOffset;
	if (byteLength > mMaxReadBytes) {
		do {
			status = mDevice.ReadBinary(offset, mMaxReadBytes, buffer);
			offset += mMaxReadBytes;
			buffer += mMaxReadBytes;
			byteLength -= mMaxReadBytes;
		} while (byteLength > mMaxWriteBytes && status == NFC_SUCCESS);
	} //if
	  //finish to write the buffer
	if (status == NFC_SUCCESS && mMaxWriteBytes)
		status = mDevice.ReadBinary(offset, byteLength, buffer);

	return status == NFC_SUCCESS;
}

