/**
 ******************************************************************************
 * @file    Nfc_class.h
 * @author  AST / EST
 * @version V0.0.1
 * @date    13-April-2015
 * @brief   This file contains the abstract class describing the interface of a
 *          nfc component.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Generated with Stm32CubeTOO -----------------------------------------------*/

/* Define to prevent from recursive inclusion --------------------------------*/

#ifndef __NFC_CLASS_H
#define __NFC_CLASS_H


/* Includes ------------------------------------------------------------------*/

#include "Component_class.h"


/* Classes  ------------------------------------------------------------------*/

/** An abstract class for Nfc components.
 */
class Nfc : public Component
{
public:

	/**
	 * possible password to set
	 */
	typedef enum{
		ReadPwd=READ_PWD,  //!< password to use before read the tag
		WritePwd=WRITE_PWD,//!< password to use before write the tag
		I2CPwd=I2C_PWD,    //!< root password, used only thought nfc
	}PasswordType_t;


	/**
	 * open a i2c connection with the tag if an RF connection isn't already open
	 * @return operation status
	 */
	virtual NFC_StatusTypeDef GetSession(void) = 0;
	/**
	 * force to open an i2c connection , abort the RF connection
	 * @return
	 */
	virtual NFC_StatusTypeDef KillSession(void) = 0;

	/**
	 * close an i2c connection
	 * @return
	 */
	virtual NFC_StatusTypeDef Deselect(void) = 0;

	/**
	 * Select the application file
	 * @return
	 */
	virtual NFC_StatusTypeDef SelectApplication(void) = 0;

	/**
	 * select the CC file
	 * @return
	 */
	virtual NFC_StatusTypeDef SelectCCfile(void) = 0;

	/**
	 * select the ndef file
	 * @param NDEFfileId file id to open
	 * @return
	 */
	virtual NFC_StatusTypeDef SelectNDEFfile(uint16_t NDEFfileId) = 0;

	/**
	 * select the system file
	 * @return
	 */
	virtual NFC_StatusTypeDef SelectSystemfile(void) = 0;

	/**
	 * read data from the tag
	 * @param Offset offset where start to read
	 * @param NbByteToRead number of byte to read
	 * @param[out] pBufferRead buffer where store the read data
	 * @return
	 */
	virtual NFC_StatusTypeDef ReadBinary(uint16_t Offset, uint8_t NbByteToRead, uint8_t *pBufferRead) = 0;

	/**
	 * write data to the tag
	 * @param Offset offset where start to write
	 * @param NbByteToWrite number of byte to write
	 * @param pDataToWrite buffer to write
	 * @return
	 */
	virtual NFC_StatusTypeDef UpdateBinary(uint16_t Offset, uint8_t NbByteToWrite, uint8_t *pDataToWrite) = 0;

	/**
	 * check that the password is correct
	 * @param uPwdId password type
	 * @param NbPwdByte password size ( must be 0x10)
	 * @param pPwd password buffer
	 * @return
	 */
	virtual NFC_StatusTypeDef Verify(PasswordType_t uPwdId, uint8_t NbPwdByte,const uint8_t *pPwd) = 0;

	/**
	 * change the pa
	 * @param uPwdId
	 * @param pPwd
	 * @return
	 */
	virtual NFC_StatusTypeDef ChangeReferenceData(PasswordType_t uPwdId,const uint8_t *pPwd) = 0;
	virtual NFC_StatusTypeDef EnableVerificationRequirement(PasswordType_t uReadOrWrite) = 0;
	virtual NFC_StatusTypeDef DisableVerificationRequirement(PasswordType_t uReadOrWrite) = 0;
	virtual NFC_StatusTypeDef STReadBinary(uint16_t Offset, uint8_t NbByteToRead, uint8_t *pBufferRead) = 0;
	virtual NFC_StatusTypeDef EnablePermanentState(PasswordType_t uReadOrWrite) = 0;
	virtual NFC_StatusTypeDef DisablePermanentState(PasswordType_t uReadOrWrite) = 0;
	virtual NFC_StatusTypeDef StateControl(uint8_t uSetOrReset) = 0;
	virtual NFC_StatusTypeDef ManageI2CGPO(uint8_t GPO_I2Cconfig) = 0;
	virtual NFC_StatusTypeDef ManageRFGPO(uint8_t GPO_RFconfig) = 0;
	virtual NFC_StatusTypeDef RFConfig(uint8_t OnOffChoice) = 0;

	virtual ~Nfc(){};
};

#endif /* __NFC_CLASS_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/ 
