/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef __HIBRIGHTLED_H
#define __HIBRIGHTLED_H

#include "mbed.h"

/**
 * High Brightness LED
 */
class HiBrightLED
{

public:

   /**
    * Constructor
    */
    HiBrightLED();

   /**
    * Destructor
    */
    ~HiBrightLED();

    /**
      * @brief  Set the LED intensity
      * @param  value Intensity (0.0 to 1.0)
      * @retval None
      */
    void write(float value);

    /**
      * @brief  Return the LED intensity
      * @param  None
      * @retval Intensity (0.0 to 1.0)
      */
    float read();

    /** A operator shorthand for write()
     */
    HiBrightLED& operator= (float value) {
        write(value);
        return *this;
    }

    /** An operator shorthand for read()
     */
    operator float() {
        return read();
    }
    
private:

    float _value; // LED intensity

    uint32_t CurrentSenseTab[5];

    DMA_HandleTypeDef DmaHandle;
    HRTIM_HandleTypeDef HrtimHandle;
    COMP_HandleTypeDef CompHandle;
    DAC_HandleTypeDef DacHandle;

    /**
      * @Brief  Convert current sense value thresholds for DAC
      * @param  None
      * @retval None
      */
    void CurrentSenseTabInit(void);

    /**
      * @brief  DMA configuration
      * @param  None
      * @retval None
      */
    void DMA_Config(void);

    /**
      * @brief  DAC channel1 configuration
      * @param  None
      * @retval None
      */
    void DAC_Config(void);
    
    /**
      * @brief  Comparator configuration
      * @param  None
      * @retval None
      */    
    void COMP_Config(void);
    
    /**
      * @brief  Hi-resolution Timer C configuration
      * @param  None
      * @retval None
      */    
    void HRTIM_Config(void);
    
    /**
      * @brief  Set Burst Compare value
      * @param  BurstCompare: Burst Compare value
      * @retval None
      */
    void HRTIM_SetBurstCompare(uint16_t BurstCompare);
  
};

#endif // __HIBRIGHTLED_H
