
#include "XNucleoOUT01A1.h"

XNucleoOUT01A1 *out01a1;
DigitalOut led1(LED1);

// main() runs in its own thread in the OS
int main() {
    
    printf("X-NUCLEO-OUT01A1 simple test application\n\r");
    
    
    
    /* Default Nucleos pinout, change accordingly on other platforms */
    out01a1 = new XNucleoOUT01A1(mode_direct, NC, A3, A4, A5, A0, A1, NC, A2, 
                                    D5, D4, D14, D15);
    out01a1->enable_outputs(true);
    
    printf("\n\rSetting all channels on\r\n");
    
    out01a1->set_inputs(0xFF);
    
    wait(3);
    
    out01a1->set_inputs(0x00);
    
    printf("\n\rIterating through channels in direct mode\r\n");
                                    
    for (int i=1; i<=8; i++) {
        
        uint8_t input_mask = 0x1 << (i-1);
        out01a1->set_inputs(input_mask);
        
        if (i == 3) {
            printf ("Input 3 not connected\n\r"); // pin3 not connected on Nucleo boards
        } else {
            printf("Output %d set \n\r", i);
        }
        
        wait(1);
    }
    
    out01a1->set_inputs(0x00);
    
    out01a1->enable_outputs(false);
    
    delete out01a1;
    
    wait(1);
    
    printf("\n\rNow iterating through channels in sync mode\r\n");
    
    /* Default Nucleos pinout, change accordingly on other platforms */
    out01a1 = new XNucleoOUT01A1(mode_sync);        
    out01a1->enable_outputs(true);
                                    
    for (int i=1; i<=8; i++) {

        uint8_t input_mask = 0x1 << (i-1);
        out01a1->set_inputs(input_mask);
        out01a1->update_outputs();
        
        if (i == 3) {
            printf ("Input 3 not connected\n\r"); // pin3 not connected on Nucleo boards
        } else {
            printf("Output %d set \n\r", i);
        }
        
        wait(1);
    }
    
    out01a1->enable_outputs(false);
    
    printf("\n\rTest completed, now blinking the LED!!\n\r");
         
    while (true) {
        led1 = !led1;
        wait(0.5);
    }
}

