/**
  ******************************************************************************
  * @file       main.cpp
  * @author     ST Central Labs
  * @version    V1.0.0
  * @date       21 Dic 2015
  * @brief      This demo writes an ndef message with an url inside.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

#include "mbed.h"

#include "X_NUCLEO_NFC02A1.h"
#include "DevI2C.h"
#include "m24lr.h"
#include "lib_NDEF_URI.h"
/**
 * Write a Ndef URI message linking to st.com site.
 */
int main(void)
{
  
  sURI_Info URI;
  NDEF_URI mNDEF_URI;
  M24LR *mM24LRp;
  
  /*use default board pinout*/
  DevI2C i2cChannel(X_NUCLEO_NFC02A1::DEFAULT_SDA_PIN,X_NUCLEO_NFC02A1::DEFAULT_SDL_PIN);
  X_NUCLEO_NFC02A1 *nfcNucleo = X_NUCLEO_NFC02A1::Instance(i2cChannel,
                                                           X_NUCLEO_NFC02A1::DEFAULT_GPO_PIN,X_NUCLEO_NFC02A1::DEFAULT_RF_DISABLE_PIN,
                                                           X_NUCLEO_NFC02A1::DEFAULT_LED1_PIN,X_NUCLEO_NFC02A1::DEFAULT_LED2_PIN,
                                                           X_NUCLEO_NFC02A1::DEFAULT_LED3_PIN);
  
  mM24LRp = nfcNucleo->getM24LR();
  mNDEF_URI.setM24LR(mM24LRp);
  /* Enable Energy Harvesting */
  mM24LRp->Enable_EnergyHarvesting();
  
  printf("System Initialization done: !\n\r");
  
  /* Check if no NDEF detected, init mem in Tag Type 5 */
  if( mNDEF_URI.NfcType5_NDEFDetection() != NDEF_OK)
  {
    mNDEF_URI.CCFileStruct.MagicNumber = NFCT5_MAGICNUMBER_E1_CCFILE;
    mNDEF_URI.CCFileStruct.Version = NFCT5_VERSION_V1_0;
    mNDEF_URI.CCFileStruct.MemorySize = ( M24LR_MAX_SIZE / 8 ) & 0xFF;
    mNDEF_URI.CCFileStruct.TT5Tag = 0x05;
    
    /* Init of the Type Tag 5 component (M24LR) */
    while( mNDEF_URI.NfcType5_TT5Init( ) != NFCTAG_OK);
  }
  
  /* Set the LED2 on to indicate Init done */
  nfcNucleo->getLed2()=1;
  
  /* Prepare URI NDEF message content */
  strcpy( URI.protocol,URI_ID_0x01_STRING );
  strcpy( URI.URI_Message,"st.com/st25" );
  strcpy( URI.Information,"\0" );
  
  /* Write NDEF to EEPROM */
  while( mNDEF_URI.NDEF_WriteURI( &URI ) != NDEF_OK);
  
  /* Set the LED3 on to indicate Programing done */
  nfcNucleo->getLed3()=1; 
}


