#ifndef __M24LR_H
#define __M24LR_H

#include "common.h"
#include "DevI2C.h"
//#include "lib_NDEF_URI.h"
  /* Exported constants --------------------------------------------------------*/
/** @defgroup M24LR_Exported_Constants
  * @{
  */
#define I_AM_M24LR04            0x5A
#define I_AM_M24LR16            0x4E
#define I_AM_M24LR64            0x5E

#ifndef NULL
#define NULL      (void *) 0
#endif

#define M24LR_PAGEWRITE_NBBYTE  4

#define M24LR_ADDR_DATA_I2C     0xA6
#define M24LR_ADDR_SYST_I2C     0xAE
#define M24LR_I2C_TIMEOUT       200 /* I2C Time out (ms), this is the maximum time needed by M24LR to complete any command */

#define M24LR_IT_BUSY_MASK      0x01
#define M24LR_IT_WIP_MASK       0x02

/* Registers address */
#define M24LR_SSS_REG           0x0000
#define M24LR_LOCK_REG          0x0800
#define M24LR_I2C_PWD_REG       0x0900
#define M24LR_CFG_REG           0x0910
#define M24LR_AFI_REG           0x0912
#define M24LR_DSFID_REG         0x0913
#define M24LR_UID_REG           0x0914
#define M24LR_ICREF_REG         0x091C
#define M24LR_MEMSIZE_REG       0x091D
#define M24LR_CTRL_REG          0x0920

/* Registers mask */
#define M24LR_SSS_LOCK_MASK     0x01
#define M24LR_SSS_RW_MASK       0x06
#define M24LR_SSS_PASSCTRL_MASK 0x18
#define M24LR_LOCK_MASK         0x0F

#define M24LR_CFG_EHCFG0_MASK   0x01
#define M24LR_CFG_EHCFG1_MASK   0x02
#define M24LR_CFG_EHMODE_MASK   0x04
#define M24LR_CFG_WIPBUSY_MASK  0x08

#define M24LR_CTRL_EHEN_MASK    0x01
#define M24LR_CTRL_FIELD_MASK   0x02
#define M24LR_CTRL_TPROG_MASK   0x80
  
 
/**
 * @brief  M24LR VOUT Configuration enumerator definition
 */
typedef enum
{
  M24LR_EH_Cfg_6MA = 0,
  M24LR_EH_Cfg_3MA,
  M24LR_EH_Cfg_1MA,
  M24LR_EH_Cfg_300UA
} M24LR_EH_CFG_VOUT;

/**
 * @brief  M24LR FIELD status enumerator definition
 */
typedef enum
{
  M24LR_FIELD_OFF = 0,
  M24LR_FIELD_ON
} M24LR_FIELD_STATUS;

/**
 * @brief  M24LR TT-PROG status enumerator definition
 */
typedef enum
{
  M24LR_T_PROG_NO = 0,
  M24LR_T_PROG_OK
} M24LR_T_PROG_STATUS;

/**
 * @brief  M24LR Energy Harvesting status enumerator definition
 */
typedef enum
{
  M24LR_EH_DISABLE = 0,
  M24LR_EH_ENABLE
} M24LR_EH_STATUS;

/**
 * @brief  M24LR Energy Harvesting mode enumerator definition
 */
typedef enum
{
  M24LR_EH_MODE_ENABLE = 0,
  M24LR_EH_MODE_DISABLE
} M24LR_EH_MODE_STATUS;

/**
 * @brief  M24LR GPO status enumerator definition
 */
typedef enum
{
  M24LR_GPO_BUSY = 0,
  M24LR_GPO_WIP
} M24LR_GPO_STATUS;

/**
 * @brief  M24LR Memory information structure definition
 */
typedef struct
{
  uint8_t BlockSize;
  uint16_t Mem_Size;
} M24LR_Mem_Size;

/**
 * @brief  M24LR I2C Write Lock register structure definition
 */
typedef struct
{
  uint8_t sectors_7_0;
  uint8_t sectors_15_8;
  uint8_t sectors_23_16;
  uint8_t sectors_31_24;
  uint8_t sectors_39_32;
  uint8_t sectors_47_40;
  uint8_t sectors_55_48;
  uint8_t sectors_63_56;
} M24LR_Lock_Sectors;

/**
 * @brief  M24LR UID information structure definition
 */
typedef struct
{
  uint32_t MSB_UID;
  uint32_t LSB_UID;
} M24LR_UID;

/**
 * @brief  M24LR Sector Security register structure definition
 */
typedef struct
{
  uint8_t SectorLock;
  uint8_t RW_Protection;
  uint8_t PassCtrl;
} M24LR_SECTOR_SEC;


  /**
  * @}
  */
  
class   M24LR {
public:
    NFCTAG_StatusTypeDef i2c_Init( void );
    NFCTAG_StatusTypeDef i2c_ReadID( uint8_t * const pICRef );
    NFCTAG_StatusTypeDef i2c_IsDeviceReady( const uint32_t Trials );
    NFCTAG_StatusTypeDef i2c_ConfigureGPO( const uint16_t ITConf );
    NFCTAG_StatusTypeDef i2c_GetGPOStatus( uint16_t * const pGPOStatus );
    NFCTAG_StatusTypeDef i2c_ReadData( uint8_t * const pData, const uint16_t TarAddr, const uint16_t NbByte );
    NFCTAG_StatusTypeDef i2c_WriteData( const uint8_t * const pData, const uint16_t TarAddr, const uint16_t NbByte );
    NFCTAG_StatusTypeDef i2c_ReadRegister( uint8_t * const pData, const uint16_t TarAddr, const uint16_t NbByte );
    NFCTAG_StatusTypeDef i2c_WriteRegister( const uint8_t * const pData, const uint16_t TarAddr, const uint16_t NbByte );
 
    
    /* Extended Functions */
    NFCTAG_StatusTypeDef i2c_ReadUID( M24LR_UID * const pUid );
    NFCTAG_StatusTypeDef i2c_ReadDSFID( uint8_t * const pDsfid );
    NFCTAG_StatusTypeDef i2c_ReadAFI( uint8_t * const pAfi );
    NFCTAG_StatusTypeDef i2c_ReadI2CLockSector( M24LR_Lock_Sectors * const pLock_sector );
    NFCTAG_StatusTypeDef i2c_I2CLockSector( const uint8_t Sector );
    NFCTAG_StatusTypeDef i2c_I2CUnlockSector( const uint8_t Sector );
    NFCTAG_StatusTypeDef i2c_PresentI2CPassword( const uint32_t PassWord );
    NFCTAG_StatusTypeDef i2c_WriteI2CPassword( const uint32_t PassWord );
    NFCTAG_StatusTypeDef i2c_ReadSSSx( const uint8_t SectorNb, M24LR_SECTOR_SEC * const pData );
    NFCTAG_StatusTypeDef i2c_WriteSSSx( const uint8_t SectorNb, const M24LR_SECTOR_SEC * const pData );
    NFCTAG_StatusTypeDef i2c_ReadMemSize( M24LR_Mem_Size * const pSizeInfo );
    NFCTAG_StatusTypeDef i2c_GetRF_WIP_BUSY( M24LR_GPO_STATUS * const pRf_Wip_Busy );
    NFCTAG_StatusTypeDef i2c_SetRFBUSY( void );
    NFCTAG_StatusTypeDef i2c_SetRFWIP( void );
    NFCTAG_StatusTypeDef i2c_Read_EH_mode( M24LR_EH_MODE_STATUS * const pEH_mode );
    NFCTAG_StatusTypeDef i2c_Enable_EH_mode( void );
    NFCTAG_StatusTypeDef i2c_Disable_EH_mode( void );
    NFCTAG_StatusTypeDef i2c_ReadEH_Cfg( M24LR_EH_CFG_VOUT * const pEH_Cfg );
    NFCTAG_StatusTypeDef i2c_WriteEH_Cfg( const M24LR_EH_CFG_VOUT EH_Cfg );
    NFCTAG_StatusTypeDef i2c_GetEH( M24LR_EH_STATUS * const pEH_Val );
    NFCTAG_StatusTypeDef i2c_SetEH( void );
    NFCTAG_StatusTypeDef i2c_ResetEH( void );
    NFCTAG_StatusTypeDef i2c_GetRFField( M24LR_FIELD_STATUS * const pRF_Field );
    NFCTAG_StatusTypeDef i2c_GetTProg( M24LR_T_PROG_STATUS * const pT_Prog );
    
    void Enable_EnergyHarvesting( void );
    NFCTAG_StatusTypeDef Initialization( void );
    
    M24LR(uint8_t const address, uint8_t const addressData, DevI2C &devI2C ):
      i2c_address_syst(address), i2c_address_data(addressData), dev_I2C(devI2C) {}
    
   static uint8_t NfctagInitialized;
  //  M24LR_IO mM24LR_IO;
   uint8_t i2c_address_syst;
   
   uint8_t i2c_address_data;
   DevI2C dev_I2C;
   friend class NDEF_URI;
   //NDEF_URI mM24LR_URI;
   //M24LR *ptr;
//   ReadFnDataPtr i2c_ReadData;
//   WriteFnDataPtr i2c_WriteData;
                                
};
  
  

  
#endif /* __M24LR_H */

