/**
  ******************************************************************************
  * @file    tagtype5_wrapper.h
  * @author  MMY Application Team
  * @version $Revision: 1638 $
  * @date    $Date: 2016-02-10 16:41:05 +0100 (Wed, 10 Feb 2016) $
  * @brief   Interface for tagtype5 in order to use NDEF lib
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT 2015 STMicroelectronics</center></h2>
  *
  * Licensed under ST MYLIBERTY SOFTWARE LICENSE AGREEMENT (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        http://www.st.com/myliberty  
  *
  * Unless required by applicable law or agreed to in writing, software 
  * distributed under the License is distributed on an "AS IS" BASIS, 
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
  * AND SPECIFICALLY DISCLAIMING THE IMPLIED WARRANTIES OF MERCHANTABILITY,
  * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __TAGTYPE5_WRAPPER_H
#define __TAGTYPE5_WRAPPER_H

#include <stdint.h> 
#include "common.h"
    
typedef enum
{
  TT5_NO_NDEF = 0,
  TT5_INITIALIZED,
  TT5_READ_WRITE,
  TT5_READ
} TT5_State;

/**
  * @brief  CCfile structure
  */
typedef struct
{
  uint8_t MagicNumber;  /* Magic Number should be E1h or E2h */
  uint8_t Version;
  uint8_t MemorySize;
  uint8_t TT5Tag;
  uint8_t rsved1;
  uint8_t rsved2;
  uint16_t ExtMemorySize;
  TT5_State State;
  uint32_t NDEF_offset;
}sCCFileInfo;

/* Exported constants --------------------------------------------------------*/
#define NFCT5_MAGICNUMBER_E1_CCFILE       0xE1
#define NFCT5_MAGICNUMBER_E2_CCFILE       0xE2
#define NFCT5_EXTENDED_CCFILE             0xFF
#define NFCT5_VERSION_V1_0                0x40
#define NFCT5_READ_ACCESS                 0x0C
#define NFCT5_WRITE_ACCESS                0x03

#define NFCT5_NDEF_MSG_TLV                0x03
#define NFCT5_PROPRIETARY_TLV             0xFD
#define NFCT5_TERMINATOR_TLV              0xFE
#define NFCT5_3_BYTES_L_TLV               0xFF

/* Exported macro ------------------------------------------------------------*/
/* External variables --------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

//typedef enum
//{
//  NFCTAG_OK      = 0,
//  NFCTAG_ERROR   = 1,
//  NFCTAG_BUSY    = 2,
//  NFCTAG_TIMEOUT = 3
//} NFCTAG_StatusTypeDef;
class NFCType5 {

  
 public: 
sCCFileInfo CCFileStruct;


uint16_t NfcType5_WriteCCFile( const uint8_t * const pCCBuffer );
uint16_t NfcType5_ReadCCFile( uint8_t * const pCCBuffer );
uint16_t NfcType5_TT5Init( void );
uint16_t NfcType5_NDEFDetection( void );


virtual NFCTAG_StatusTypeDef NFCTAG_ReadData( uint8_t * const pData, const uint16_t TarAddr, const uint16_t Size )=0;
virtual NFCTAG_StatusTypeDef NFCTAG_WriteData( const uint8_t * const pData, const uint16_t TarAddr, const uint16_t Size )=0;

uint16_t ReadData( uint16_t Offset , uint16_t DataSize , uint8_t* pData );
uint16_t WriteData( uint16_t Offset , uint32_t DataSize , uint8_t *pData );

};
#endif /* __TAGTYPE5_WRAPPER_H */
/**
  * @}
  */ 

/**
  * @}
  */ 

/**
  * @}
  */ 

/******************* (C) COPYRIGHT 2016 STMicroelectronics *****END OF FILE****/
