/**
  ******************************************************************************
  * @file       main.cpp
  * @author     ST Central Labs
  * @version    V1.0.0
  * @date       21 Dic 2015
  * @brief      This demo writes an ndef message with an url inside.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */
  
#include "mbed.h"

#include "X_NUCLEO_NFC01A1.h"
#include "NDefLib/NDefNfcTag.h"
#include "NDefLib/RecordType/RecordURI.h"

/**
 * Write a Ndef URI message linking to st.com site.
 */
int main(void){
    
    //use default board pinout
    I2C i2cChannel(X_NUCLEO_NFC01A1::DEFAULT_SDA_PIN,X_NUCLEO_NFC01A1::DEFAULT_SDL_PIN);
    X_NUCLEO_NFC01A1 *nfcNucleo = X_NUCLEO_NFC01A1::Instance(i2cChannel);
    
    //retrieve the NdefLib interface
    NDefLib::NDefNfcTag& tag =nfcNucleo->getM24SR().getNDefTag();
    printf("System Init done: !\n\r");
    
    //open the i2c session with the nfc chip
    if(tag.openSession()){
        printf("Session open\n\r");
        nfcNucleo->getLed1()=1;
        
        //create the NDef message and record
        NDefLib::Message msg;
        NDefLib::RecordURI rUri(NDefLib::RecordURI::HTTP_WWW,"st.com");
        msg.addRecord(&rUri);

        //write the tag
        if(tag.write(msg)){
            printf("Tag writed \n\r");
            nfcNucleo->getLed2()=1;
        }else{
            printf("Error writing \n\r");
        }//if-else

        //close the i2c session
        if(tag.closeSession()){
           printf("Session closed\n\r");
           nfcNucleo->getLed3()=1;
        }else{
           printf("Error Closing the session\n\r");
        }//if-else
            
    }else
        printf("Error open Session\n\r");
}
