#include "mbed.h"
#include "tsz124_class.h"

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);

int main() {

    DevI2C i2c(D14, D15);
    TSZ124 opAmp(0, i2c);
    unsigned int voltage = 100;

    pc.printf("\nhello world\n"); 
    
    while(1) {        
        pc.printf("\nwhile loop\n");         
        pc.printf("\nopAmp measured voltage: %u \n", opAmp.GetVoltage());  
        pc.printf("\nopAmp measured Current: %u \n", opAmp.GetCurrent()); 
        pc.printf("\nphotodiode sensor output voltage: %u \n", opAmp.GetPhotoSensorValue());                    
        myled = !myled;
        wait(1);
    }
}
