/**
 ******************************************************************************
 * @file    main.cpp
 * @author  CLab
 * @version V1.0.0
 * @date    2-December-2016
 * @brief   Simple Example application for using the X_NUCLEO_IKA01A1 
 *          Analog expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/ 


/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"

/* Board specific header files. */
#include "XNucleoIKA01A1.h"


/* Variables -----------------------------------------------------------------*/

Serial pc(USBTX, USBRX);
//Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);


/* Functions -----------------------------------------------------------------*/

int main() {  
    XNucleoIKA01A1 *analog_expansion_board = XNucleoIKA01A1::instance(X_NUCLEO_IKA01A1_PIN_INSTRUMENTATION_AMP,
                                                                      X_NUCLEO_IKA01A1_PIN_CURRENT_SENSING,
                                                                      X_NUCLEO_IKA01A1_PIN_PHOTO_SENSOR, 
                                                                      X_NUCLEO_IKA01A1_PIN_WINDOWS_COMP_SIGNAL_1,
                                                                      X_NUCLEO_IKA01A1_PIN_WINDOWS_COMP_SIGNAL_2,
                                                                      X_NUCLEO_IKA01A1_PIN_PWM_LED_DRIVER_OUTPUT,
                                                                      5000);
    analog_expansion_board->init();
    TSZ124 *instr_amp = analog_expansion_board->tsz124;
    TSU104 *photo_sensor_wind_comp = analog_expansion_board->tsu104;
    TSV734 *led_driver = analog_expansion_board->tsv734;  
    double duty_cycle = 0;    
    
    while(1) {            
        pc.printf("\nLooping...\n");

        unsigned int op_amp_voltage = instr_amp->get_voltage();
        unsigned int op_amp_current = instr_amp->get_current();
        // pass the analog pin name on which voltage is to be read (e.g. A3 on LPCxpresso lpc11u68)
        unsigned int photoSensorVoltage = photoSensor_windComp->get_voltage();                
        unsigned int windComPin1 = photo_sensor_wind_comp->get_signal1();               
        unsigned int windComPin2 = photo_sensor_wind_comp->get_signal2();                  
        
        pc.printf("\nopAmp measured voltage(mV): %u \n", op_amp_voltage);  
        pc.printf("\nopAmp measured Current(mA): %u \n", op_amp_current); 
        pc.printf("\nphotodiode sensor output voltage(mV): %u \n", photo_sensor_voltage); 
        pc.printf("\nWindows comparator: signal 1 value(pin D2): %u \n", wind_com_pin1);         
        pc.printf("\nWindows comparator: signal 1 value(pin D4): %u \n", wind_com_pin2);   

        duty_cycle += 0.1; 
        if (duty_cycle >= 1) 
            duty_cycle = 0;
                     
        pc.printf("\nLED Driver: duty cycle: %.2lf percent \n", led_Driver->set_duty_cycle(duty_cycle));              
                                          
        myled = !myled;
        wait(1);      
    }    
}
