#include "mbed.h"
#include "x_nucleo_ika01a1_class.h"

Serial pc(USBTX, USBRX);

DigitalOut myled(LED1);

int main() {  
    X_NUCLEO_IKA01A1 *analog_expansion_board = X_NUCLEO_IKA01A1::Instance(A3, D2, D4, D3, 50);
    analog_expansion_board->Init();
    TSZ124 *instrAmp = analog_expansion_board->tsz124;
    TSU104 *photoSensor_windComp = analog_expansion_board->tsu104;
    
    TSV734 *led_Driver = analog_expansion_board->tsv734;  
    double dutyCycle_us = 0;    
    
    while(1) {            
        pc.printf("\nwhile loop\n");       
        
        unsigned int opAmpVoltage = instrAmp->GetVoltage();        
        unsigned int opAmpCurrent = instrAmp->GetCurrent();           
        // pass the analog pin name on which voltage is to be read (e.g. A3 on LPCxpresso lpc11u68)
        unsigned int photoSensorVoltage = photoSensor_windComp->Get_PhotoSensor_GetVoltage();                
        unsigned int windComPin1 = photoSensor_windComp->WindComp_Get_Signal1();               
        unsigned int windComPin2 = photoSensor_windComp->WindComp_Get_Signal2();                  
        
        pc.printf("\nopAmp measured voltage(mV): %u \n", opAmpVoltage);  
        pc.printf("\nopAmp measured Current(mA): %u \n", opAmpCurrent); 
        pc.printf("\nphotodiode sensor output voltage(mV): %u \n", photoSensorVoltage); 
        pc.printf("\nWindows comparator: signal 1 value(pin D2): %u \n", windComPin1);         
        pc.printf("\nWindows comparator: signal 1 value(pin D4): %u \n", windComPin2);   
        
        dutyCycle_us += 0.1;  
        pc.printf("\nLED Driver: duty cycle: %u percent \n", led_Driver->SetDutyCycle(dutyCycle_us));              
        
        if(dutyCycle_us>=1) 
            dutyCycle_us -= 1;
                                  
        myled = !myled;
        wait(1);      
                                  
        myled = !myled;
        wait(1);
    }    
}
