#include "mbed.h"
#include "x_nucleo_ika01a1_class.h"

Serial pc(USBTX, USBRX);

DigitalOut myled(LED1);

int main() {
    X_NUCLEO_IKA01A1 *analog_expansion_board = X_NUCLEO_IKA01A1::Instance();
    analog_expansion_board->Init();
    TSZ124 *instrAmp = analog_expansion_board->tsz124;
    
    TSU104 *photoSensor_windComp = analog_expansion_board->tsu104;
    TSV734 *led_Driver = analog_expansion_board->tsv734;
    led_Driver->Configure(1000);
    float dutyCycle_us = 0;

    pc.printf("\nhello world\n"); 
    
    while(1) {        
        pc.printf("\nwhile loop\n");       
        
        unsigned int opAmpVoltage = instrAmp->GetVoltage();
        unsigned int opAmpCurrent = instrAmp->GetCurrent();  
        unsigned int photoSensorVoltage = photoSensor_windComp->TSU104_PhotoSensor_GetVoltage();     
        unsigned int windComPinD2 = photoSensor_windComp->TSU104_WindComp_Get_D2();
        unsigned int windComPinD4 = photoSensor_windComp->TSU104_WindComp_Get_D4();
                  
        pc.printf("\nopAmp measured voltage(mV): %u \n", opAmpVoltage);  
        pc.printf("\nopAmp measured Current(mA): %u \n", opAmpCurrent); 
        pc.printf("\nphotodiode sensor output voltage(mV): %u \n", photoSensorVoltage); 
        pc.printf("\nWindows comparator: state of pin D2: %u \n", windComPinD2);         
        pc.printf("\nWindows comparator: state of pin D4: %u \n", windComPinD4);           
        
        dutyCycle_us += 10;  
        pc.printf("\nLED Driver: duty cycle: %u percent \n", led_Driver->SetDutyCycle(dutyCycle_us));              
        
        if(dutyCycle_us>=100) 
            dutyCycle_us -= 100;
                                  
        myled = !myled;
        wait(1);
    }
    
}
