/* mbed Microcontroller Library
 * Copyright (c) 2006-2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This example is based on the BLDCmotorDriver motor control library
// by the TVZ Mechatronics Team, University of Applied Sciences Zagreb,
// Professional Study in Mechatronics:
// https://developer.mbed.org/teams/TVZ-Mechatronics-Team/code/BLDCmotorDriver/
 
#include <stdio.h>
#include "mbed.h"
#include "RateLimiter.h"
#include "SPN7Driver.h"
// Pin definitions for X-NUCLEO-IHM070M1 with STM32 Nucleo boards
#include "x_nucleo_ihm07m1_targets.h"

// Instance of the motor driver
SPN7Driver M(
             P_IN1, P_IN2, P_IN3, // Logic input pins
             P_EN1, P_EN2, P_EN3, // Enable channel pins
             P_HALL1, P_HALL2, P_HALL3, // Hall sensors pins
             P_FAULT // Fault LED
             );
             
// Pin to check temperature on the X-NUCLEO-IHM07M1 board
AnalogIn temperature(PC_2);

void checkTemperature()
{
    float t = temperature.read()* 100.0f;

    if (temperature.read() > 0.55f){
        printf("Overheating... Turning off now\n\r");
        M.setDutyCycle(0);
        M.coast(); 
    }
}

int main() {
    printf("Press 'w' to speed up, 's' to speed down\n\r");
    
    // Duty cycle value to be used for speed control
    float dc = 0.0f;
    
    Ticker ticker;
    ticker.attach(checkTemperature, 1); // Periodic overheating check
    
    while(true) { 

        char c = getchar();
        if((c == 'w') && (dc < 0.9f)) {
            dc += 0.1f;
            M.setDutyCycle(dc);
        }
        if((c == 's') && (dc >= 0.1f)) {
            dc -= 0.1f;
            M.setDutyCycle(dc);
        }

        printf("Duty Cycle: %1.2f, Sector: %d\n\r",dc, M.getSector());

    }   
}
