/* mbed Microcontroller Library
* Copyright (c) 2006-2016 ARM Limited
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/**
  ******************************************************************************
  * @file    SPN7Driver.h 
  * @author  STMicroelectronics
  * @brief   Header file for SPN7Driver based on BLDCmotorDriver class
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2016 STMicroelectronics</center></h2>
  */ 

// This example is based on the BLDCmotorDriver motor control library
// by the TVZ Mechatronics Team, University of Applied Sciences Zagreb,
// Professional Study in Mechatronics:
// https://developer.mbed.org/teams/TVZ-Mechatronics-Team/code/BLDCmotorDriver/

#ifndef __SPN7DRIVER_H__
#define __SPN7DRIVER_H__
  
#include "mbed.h"
#include "BLDCmotorDriver.h"

class SPN7Driver : public BLDCmotorDriver {
    public:
        SPN7Driver(PinName pIN1, PinName pIN2, PinName pIN3, 
                   PinName pEN1, PinName pEN2, PinName pEN3,
                   PinName pH1, PinName pH2, PinName pH3,
                   PinName pFault);
        void setDutyCycle(float dutyCycle);
                    
    protected:
        void commutation();
};
        
#endif // __SPN7DRIVER_H__
