/**
 ******************************************************************************
 * @file    main.cpp
 * @author  Davide Aliprandi, STMicroelectronics
 * @version V1.0.0
 * @date    March 25th, 2016
 * @brief   mbed test application for the STMicroelectronics X-NUCLEO-CCA01M1
 *          Sound Terminal Expansion Board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"


#if DEVICE_I2S

/* Helper header files. */
#include "DevI2C.h"

/* Component specific header files. */
#include "STA350BW.h"

/* My song header file. */
#include "my_song.h"


/* Definitions ---------------------------------------------------------------*/

/* Events. */
#define PLAY_STOP_EVENT      (0x1)


/* Variables -----------------------------------------------------------------*/

/* Initialization parameters. */
STA350BW_init_t init =
{
    32000,   /* Default Sampling Frequency [Hz]. */
    100      /* Default Volume. */
};

/* Sound Terminal Component. */
STA350BW *sound_terminal;


/* Functions -----------------------------------------------------------------*/

/**
 * @brief  Entry point function of mbedOS.
 * @param  None
 * @retval None
 */
int main(void)
{
    /*----- Initialization. -----*/

    /* Initializing I2C bus. */
    DevI2C *dev_i2c = new DevI2C(PB_9, PB_8);

    /* Initializing Sound Terminal Component. */
#ifndef USE_I2S2
    sound_terminal = new STA350BW(PA_10, STA350BW_ADDRESS_1, *dev_i2c, PB_15, PB_13, PB_12, NC, PC_6);
#else
    sound_terminal = new STA350BW(PA_10, STA350BW_ADDRESS_2, *dev_i2c, PC_12, PC_10, PA_4, NC, PC_7);
#endif
    if (sound_terminal->init(&init) != COMPONENT_OK)
    {
        error("Initialization of the Sound Terminal Expansion Board failed.\r\n");
        exit(EXIT_FAILURE);
    }

    /* Setting Sound Terminal Component's parameters. */
    sound_terminal->set_frequency(MY_SONG_AUDIO_FREQUENCY);
    sound_terminal->set_volume(STA350BW_CHANNEL_MASTER, 60);

    /* Printing to the console. */
    printf("Sound Terminal Application Example\r\n\n");


    /*----- Playing. -----*/

    /* Printing to the console. */
    printf("--> Playing...\r\n");
    sound_terminal->play((int16_t *) my_song, (uint16_t) sizeof(my_song), true);

    /* Dispatching forever the I2S queue. */
    I2S::i2s_bh_queue.dispatch_forever();
}

#else // DEVICE_I2S

int main(void)
{
    printf("The target does not support I2S API.\r\n");
}

#endif // DEVICE_I2S
