#include "mbed.h"
//#include "EthernetInterface.h"
#include "TCPSocket.h"
#include "HTTPClient.h"

#ifdef LICIO

#else
EthernetInterface eth;
#endif

char str[512];

int main() 
{
#ifdef LICIO
    SpwfSAInterface spwf(D8, D2, false);    

    HTTPWiFi ipstack(spwf, "crespan","Elfrontal1", NSAPI_SECURITY_WPA2);
 
HTTPClient http(ipstack);
#else    
    eth.init(); //Use DHCP
    eth.connect();
#endif 
    int ret;       
    
    //GET data
    printf("\nTrying to fetch page...\n\r");
    ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128, HTTP_CLIENT_DEFAULT_TIMEOUT);
//  ret = http.get("http://httpstat.us", str, 128, HTTP_CLIENT_DEFAULT_TIMEOUT);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\n\r", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
    }
    
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("\nTrying to post data...\n\r");
    ret = http.post("http://httpbin.org/post", map, &inText, HTTP_CLIENT_DEFAULT_TIMEOUT);
//    ret = http.post("http://posttestserver.com/post.php", map, &inText, HTTP_CLIENT_DEFAULT_TIMEOUT);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n\r", strlen(str));
      printf("Result: %s\n\r", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
    }
    
    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    printf("\nTrying to put resource...\n\r");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      printf("Executed PUT successfully - read %d characters\n\r", strlen(str));
      printf("Result: %s\n\r", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
    }
    
    //DELETE data
    //HTTPText inText(str, 512);
    printf("\nTrying to delete resource...\n\r");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      printf("Executed DELETE successfully - read %d characters\n\r", strlen(str));
      printf("Result: %s\n\r", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
//    eth.disconnect();  

    while(1) {
    }
}
