
#include "mbed.h"
#include "TCPSocket.h"
#include "HTTPClient.h"


//www.mbed.com CA certificate in PEM format
char  CA_cert []="-----BEGIN CERTIFICATE-----\r\n"
"MIIDdTCCAl2gAwIBAgILBAAAAAABFUtaw5QwDQYJKoZIhvcNAQEFBQAwVzELMAkG\r\n"
"A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv\r\n"
"b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAw\r\n"
"MDBaFw0yODAxMjgxMjAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i\r\n"
"YWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYDVQQDExJHbG9iYWxT\r\n"
"aWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaDuaZ\r\n"
"jc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavp\r\n"
"xy0Sy6scTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp\r\n"
"1Wrjsok6Vjk4bwY8iGlbKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdG\r\n"
"snUOhugZitVtbNV4FpWi6cgKOOvyJBNPc1STE4U6G7weNLWLBYy5d4ux2x8gkasJ\r\n"
"U26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrXgzT/LCrBbBlDSgeF59N8\r\n"
"9iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8E\r\n"
"BTADAQH/MB0GA1UdDgQWBBRge2YaRQ2XyolQL30EzTSo//z9SzANBgkqhkiG9w0B\r\n"
"AQUFAAOCAQEA1nPnfE920I2/7LqivjTFKDK1fPxsnCwrvQmeU79rXqoRSLblCKOz\r\n"
"yj1hTdNGCbM+w6DjY1Ub8rrvrTnhQ7k4o+YviiY776BQVvnGCv04zcQLcFGUl5gE\r\n"
"38NflNUVyRRBnMRddWQVDf9VMOyGj/8N7yy5Y0b2qvzfvGn9LhJIZJrglfCm7ymP\r\n"
"AbEVtQwdpf5pLGkkeB6zpxxxYu7KyJesF12KwvhHhm4qxFYxldBniYUr+WymXUad\r\n"
"DKqC5JlR3XC321Y9YeRq4VzW9v493kHMB65jUr9TU/Qr6cf9tveCX4XSQRjbgbME\r\n"
"HMUfpIBvFSDJ3gyICh3WZlXi/EjJKSZp4A==\r\n"
"-----END CERTIFICATE-----\r\n";

char str[512];
DigitalOut myled(LED1);

int main() 
{

    printf("\r\nHTTPClient_HelloWorld mbed Application\r\n");     
    printf("\r\nconnecting to AP...\r\n");
    
    SpwfSAInterface spwf(D8, D2, PC_12, PC_8, false);
    spwf.connect("crespan","Elfrontal1", NSAPI_SECURITY_WPA2);

    const char *ip = spwf.get_ip_address();
    printf("\r\nIP Address is: %s\r\n", ip);

    time_t ctTime;
    ctTime = time(NULL);             
    printf ("Start Secure Socket connection with one way server autentication test\n\r");                
    if (!spwf.get_time(&ctTime)) printf ("ERROR get_time\n\r");     // read WiFi module time
    else set_time(ctTime);  // set Nucleo system time
    printf("Initial System Time is: %s\r\n", ctime(&ctTime));   
    printf("Need to adjust time? if yes enter time in seconds elapsed since Epoch (cmd: date +'%%s'), otherwise enter 0 ");                
    int t=0;
    scanf("%d",&t);
    printf ("Entered time is: %d \n\r", t);
    if (t != 0) { 
       time_t txTm=t; ctTime=t; set_time(txTm);   // set Nucleo system time
       if (!spwf.set_time(ctTime)) printf ("ERROR set_time\n\r");          
    } else {
       if (!spwf.get_time(&ctTime)) printf ("ERROR get_time\n\r");  // read WiFi module time again to compensate time spent on scanf
       else set_time(ctTime);  // set Nucleo system time again to align with Wifi
    }
    printf ("The current system time is: %s\n\r", ctime (&ctTime));  
    spwf.get_time(&ctTime);
    printf ("The current wifi   time is: %s\n\r", ctime (&ctTime));  
    
    HTTPClient http(spwf);
    int ret;       

    if (!spwf.clean_TLS_certificate(ALL)) printf ("ERROR clean_TLS_certificate\n\r");
    if (!spwf.set_TLS_certificate(CA_cert, sizeof(CA_cert), FLASH_CA_ROOT_CERT)) printf ("ERROR set_TLS_certificate\n\r");
    if (!spwf.set_TLS_SRV_domain("*.mbed.com",FLASH_DOMAIN)) printf ("ERROR set_TLS_CA_domain\n\r");
    //GET data
    printf("\nTrying to fetch page...\n\r");
    ret = http.get("https://developer.mbed.org/media/uploads/donatien/hello.txt", str, 128, HTTP_CLIENT_DEFAULT_TIMEOUT);

//ret = http.get("https://developer.mbed.org/media/uploads/donatien/hello.txt", str, 128, HTTP_CLIENT_DEFAULT_TIMEOUT);
//ret = http.get("https://httpbin.org/ip", str, 128, HTTP_CLIENT_DEFAULT_TIMEOUT);
//ret = http.get("https://www.mbed.com", str, 128, HTTP_CLIENT_DEFAULT_TIMEOUT);
//  ret = http.get("http://httpstat.us", str, 128, HTTP_CLIENT_DEFAULT_TIMEOUT);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\n\r", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
    }

    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("\nTrying to post data...\n\r");
    ret = http.post("http://httpbin.org/post", map, &inText, HTTP_CLIENT_DEFAULT_TIMEOUT);
//    ret = http.post("http://posttestserver.com/post.php", map, &inText, HTTP_CLIENT_DEFAULT_TIMEOUT);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n\r", strlen(str));
      printf("Result: %s\n\r", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
    }
    
    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    printf("\nTrying to put resource...\n\r");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      printf("Executed PUT successfully - read %d characters\n\r", strlen(str));
      printf("Result: %s\n\r", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
    }
    
    //DELETE data
    //HTTPText inText(str, 512);
    printf("\nTrying to delete resource...\n\r");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      printf("Executed DELETE successfully - read %d characters\n\r", strlen(str));
      printf("Result: %s\n\r", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    spwf.disconnect();
    printf ("WIFI disconnected, exiting ...\n\r");

    while(1) { 
      wait(1);
      myled = !myled;
    }
}
