/**
 ******************************************************************************
 * @file    GPSDatalog.h
 * @author  AST/CL
 * @version V1.1.0
 * @date    Jun, 2017
 * @brief   .
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2017 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */

#ifndef __GPS_DATALOG_H__
#define __GPS_DATALOG_H__

/**
 * For more information about DataLogging, please refer to
 * Teseo LIV-3F UM available at st.com
 */

class GPSDatalog {
public:
    
    /** 
     * Construct a GPSDatalog instance. 
     */ 
    GPSDatalog(bool          enableBufferFullAlarm,
               bool          enableCircularBuffer,
               unsigned      minRate,
               unsigned      minSpeed,
               unsigned      minPosition,
               int           logMask) :
        _enableBufferFullAlarm(enableBufferFullAlarm),
        _enableCircularBuffer(enableCircularBuffer),
        _minRate(minRate),
        _minSpeed(minSpeed),
        _minPosition(minPosition),
        _logMask(logMask) {
    }

    /**
     * Helper method to know if the datalogging subsystem
     * can raise an alarm in case of buffer full.
     */
    bool getEnableBufferFullAlarm(void) const {
      return _enableBufferFullAlarm;
    }

    /**
     * Helper method to know if the datalogging subsystem
     * supports circular buffer.
     */
    bool getEnableCircularBuffer(void) const {
      return _enableCircularBuffer;
    }

    /**
     * Return the rate to record a new entry.
     */
    unsigned getMinRate(void) const {
      return _minRate;
    }

    /**
     * Return the speed threshold to log a data.
     */
    unsigned getMinSpeed(void) const {
      return _minSpeed;
    }

    /**
     * Return the minimal speed to log a data.
     */
    unsigned getMinPosition(void) const {
      return _minPosition;
    }

    /**
     * Return the mask indicating the data to be logged.
     */
    int getLogMask(void) const {
      return _logMask;
    }
    
protected:
  bool          _enableBufferFullAlarm;
  bool          _enableCircularBuffer;
  unsigned      _minRate;
  unsigned      _minSpeed;
  unsigned      _minPosition;
  int           _logMask;

private:
    /* disallow copy constructor and assignment operators */
    GPSDatalog(const GPSDatalog&);
    GPSDatalog & operator= (const GPSDatalog&);
};

#endif /* __GPS_DATALOG_H__ */
