/**
  ******************************************************************************
  * @file    font20epd.c
  * @author  MCD Application Team
  * @version V1.2.0
  * @date    06-February-2015
  * @brief   This file provides text font20 for STM32L0538-DISCO's EPD driver. 
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "fontsepd.h"

/** @addtogroup BSP
  * @{
  */

/** @addtogroup STM32L0538_DISCOVERY
  * @{
  */

/** @addtogroup FONTS
  * @brief      This file provides text Font20 for STM32L0538-Discovery's EPD driver.
  * @{
  */  

/** @defgroup FONTS_Private_Types
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Defines
  * @{
  */
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Macros
  * @{
  */
/**
  * @}
  */ 
  

/** @defgroup FONTS_Private_Variables
  * @{
  */

// Character bitmaps for Courier New 15pt
const uint8_t Font20_Table[] = 
{
	// @0 ' ' (14 pixels wide)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @70 '!' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xf0, 0xff, 0x00, 0x03, //      ###      
	0xff, 0xf0, 0xf0, 0x00, 0x03, //      ###      
	0xff, 0xf0, 0xff, 0x00, 0x03, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //       #       
	0xff, 0xff, 0xff, 0xff, 0xff, //       #       
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               

	// @80 '"' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //    ###  ###   
	0xff, 0xff, 0xff, 0xfc, 0x0f, //    ###  ###   
	0xff, 0xff, 0xff, 0x00, 0x0f, //    ###  ###   
	0xff, 0xff, 0xff, 0xfc, 0x0f, //     #    #    
	0xff, 0xff, 0xff, 0xff, 0xff, //     #    #    
	0xff, 0xff, 0xff, 0xff, 0xff, //     #    #    
	0xff, 0xff, 0xff, 0xfc, 0x0f, //               
	0xff, 0xff, 0xff, 0x00, 0x0f, //               
	0xff, 0xff, 0xff, 0xfc, 0x0f, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               

	// @120 '#' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##  ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##  ##    
	0xff, 0xff, 0xc3, 0xc3, 0xff, //     ##  ##    
	0xff, 0xff, 0xc3, 0xc3, 0xff, //     ##  ##    
	0xff, 0x00, 0x00, 0x00, 0x00, //     ##  ##    
	0xff, 0x00, 0x00, 0x00, 0x00, //   ##########  
	0xff, 0xff, 0xc3, 0xc3, 0xff, //   ##########  
	0xff, 0xff, 0xc3, 0xc3, 0xff, //     ##  ##    
	0xff, 0x00, 0x00, 0x00, 0x00, //     ##  ##    
	0xff, 0x00, 0x00, 0x00, 0x00, //   ##########  
	0xff, 0xff, 0xc3, 0xc3, 0xff, //   ##########  
	0xff, 0xff, 0xc3, 0xc3, 0xff, //     ##  ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##  ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##  ##    
	                              //     ##  ##    
                                      //     ##  ##    
                                      //               
                                      //               
	                              //               
	                              //               

	// @160 '$' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ######   
	0xff, 0xfc, 0x03, 0xc0, 0xff, //     #######   
	0xff, 0xfc, 0x03, 0x00, 0x3f, //    ##    ##   
	0xff, 0xfc, 0x3f, 0x0f, 0x0f, //    ##         
	0xff, 0x00, 0x3f, 0x0f, 0x00, //    #####      
	0xff, 0x00, 0x3f, 0x0f, 0x00, //     ######    
	0xff, 0xfc, 0x3c, 0x3f, 0x0f, //         ###   
	0xff, 0xff, 0x00, 0x3c, 0x0f, //    ##    ##   
	0xff, 0xff, 0xc0, 0xfc, 0x0f, //    ##    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //    #######    
	0xff, 0xff, 0xff, 0xff, 0xff, //    ######     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	                              //       ##      
                                      //       ##      
                                      //               
                                      //               
                                      //               
                                      //               

	// @200 '%' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //    ###        
	0xff, 0xff, 0xf0, 0xfc, 0x0f, //   #   #       
	0xff, 0xff, 0xf0, 0xf3, 0xf3, //   #   #       
	0xff, 0xff, 0xfc, 0x33, 0xf3, //   #   #       
	0xff, 0xff, 0xfc, 0x33, 0xf3, //    ###   ##   
	0xff, 0xfc, 0x0f, 0x3c, 0x0f, //        ####   
	0xff, 0xf3, 0xf3, 0x0f, 0xff, //     #####     
	0xff, 0xf3, 0xf3, 0x0f, 0xff, //   ####        
	0xff, 0xf3, 0xf3, 0xc3, 0xff, //   ##   ###    
	0xff, 0xfc, 0x0f, 0xc3, 0xff, //       #   #   
	0xff, 0xff, 0xff, 0xff, 0xff, //       #   #   
	0xff, 0xff, 0xff, 0xff, 0xff, //       #   #   
	0xff, 0xff, 0xff, 0xff, 0xff, //        ###    
	                              //               
                                      //               
                                      //               
	                              //               
	                              //               
                                      //               

	// @240 '&' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xfc, 0x03, 0xff, 0xff, //       #####   
	0xff, 0xfc, 0x00, 0xc0, 0xff, //     #######   
	0xff, 0xf0, 0xf0, 0x00, 0xff, //     ##        
	0xff, 0xf0, 0xf0, 0x3c, 0x3f, //     ##        
	0xff, 0xf0, 0xc0, 0xfc, 0x3f, //      ##       
	0xff, 0xf0, 0x03, 0xfc, 0x3f, //     ####  ##  
	0xff, 0xfc, 0x03, 0xfc, 0x3f, //    #########  
	0xff, 0xf0, 0xc0, 0xfc, 0x3f, //    ##  ####   
	0xff, 0xf0, 0xf0, 0xfc, 0x3f, //    ##   ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //    #########  
	0xff, 0xff, 0xff, 0xff, 0xff, //      #### ##  
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @280 ''' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //        #      
	0xff, 0xff, 0xff, 0xfc, 0x0f, //        #      
	0xff, 0xff, 0xff, 0x00, 0x0f, //        #      
	0xff, 0xff, 0xff, 0xfc, 0x0f, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
	                              //               
                                      //               
	                              //               
                                      //               
                                      //               

	// @320 '(' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //        ##     
	0xff, 0xff, 0xff, 0xff, 0xff, //        ##     
	0xff, 0xff, 0xff, 0xff, 0xff, //        ##     
	0xff, 0xff, 0x00, 0x0f, 0xff, //       ##      
	0xff, 0xc0, 0x00, 0x00, 0x3f, //       ##      
	0xfc, 0x00, 0xff, 0xf0, 0x03, //       ##      
	0xfc, 0x3f, 0xff, 0xff, 0xc3, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //        ##     
	0xff, 0xff, 0xff, 0xff, 0xff, //        ##     
	                              //        ##     
                                      //         ##    
	                              //         ##    
	                              //               
	                              //               
	                              //               

	// @360 ')' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##        
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##        
	0xff, 0xff, 0xff, 0xff, 0xff, //      ##       
	0xfc, 0x3f, 0xff, 0xff, 0xc3, //      ##       
	0xfc, 0x00, 0xff, 0xf0, 0x03, //      ##       
	0xff, 0xc0, 0x00, 0x00, 0x3f, //       ##      
	0xff, 0xff, 0x00, 0x0f, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ##       
	0xff, 0xff, 0xff, 0xff, 0xff, //      ##       
	                              //      ##       
	                              //     ##        
	                              //     ##        
                                      //               
                                      //               
                                      //               

	// @400 '*' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xf0, 0xff, //       ##      
	0xff, 0xff, 0xf0, 0xf0, 0xff, //    ## ## ##   
	0xff, 0xff, 0xf0, 0x03, 0xff, //    ########   
	0xff, 0xff, 0xfc, 0x00, 0x03, //      ####     
	0xff, 0xff, 0xfc, 0x00, 0x03, //      ####     
	0xff, 0xff, 0xf0, 0x03, 0xff, //     ######    
	0xff, 0xff, 0xf0, 0xf0, 0xff, //     ##  ##    
	0xff, 0xff, 0xff, 0xf0, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
	                              //               
                                      //               
	                              //               
	                              //               
                                      //               

	// @440 '+' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //       ##      
	0xff, 0xff, 0xfc, 0x3f, 0xff, //       ##      
	0xff, 0xff, 0xfc, 0x3f, 0xff, //       ##      
	0xff, 0xfc, 0x00, 0x00, 0x3f, //       ##      
	0xff, 0xfc, 0x00, 0x00, 0x3f, //   ##########  
	0xff, 0xff, 0xfc, 0x3f, 0xff, //   ##########  
	0xff, 0xff, 0xfc, 0x3f, 0xff, //       ##      
	0xff, 0xff, 0xfc, 0x3f, 0xff, //       ##      
	0xff, 0xff, 0xfc, 0x3f, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @480 ',' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xfc, 0x0f, 0xff, 0xff, 0xff, //               
	0xff, 0x00, 0x3f, 0xff, 0xff, //               
	0xff, 0xf0, 0x3f, 0xff, 0xff, //               
	0xff, 0xff, 0x3f, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	                              //      ##       
	                              //      ##       
                                      //      #        
                                      //               
                                      //               
                                      //               

	// @520 '-' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //   #########   
	0xff, 0xff, 0xfc, 0x3f, 0xff, //   #########   
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @560 '.' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0x3f, 0xff, 0xff, //               
	0xff, 0xf0, 0x3f, 0xff, 0xff, //               
	0xff, 0xf0, 0x3f, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @600 '/' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //          ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //          ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	0xff, 0x0f, 0xff, 0xff, 0xff, //         ##    
	0xff, 0x00, 0x3f, 0xff, 0xff, //         ##    
	0xff, 0xf0, 0x03, 0xff, 0xff, //        ##     
	0xff, 0xff, 0xc0, 0x3f, 0xff, //        ##     
	0xff, 0xff, 0xfc, 0x03, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xc0, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xfc, 0x00, //      ##       
	0xff, 0xff, 0xff, 0xff, 0xf0, //      ##       
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##        
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##        
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##        
	                              //    ##         
	                              //    ##         
                                      //               
                                      //               
                                      //               
                                      //               

	// @640 '0' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //     #####     
	0xff, 0xff, 0xc0, 0x00, 0xff, //    #######    
	0xff, 0xfc, 0x00, 0x00, 0x0f, //    ##   ##    
	0xff, 0xf0, 0x3f, 0xff, 0x03, //   ##     ##   
	0xff, 0xf0, 0xff, 0xff, 0xc3, //   ##     ##   
	0xff, 0xf0, 0xff, 0xff, 0xc3, //   ##     ##   
	0xff, 0xf0, 0xff, 0xff, 0xc3, //   ##     ##   
	0xff, 0xf0, 0x3f, 0xff, 0x03, //   ##     ##   
	0xff, 0xfc, 0x00, 0x00, 0x0f, //   ##     ##   
	0xff, 0xff, 0xc0, 0x00, 0xff, //   ##     ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ##   ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //    #######    
	0xff, 0xff, 0xff, 0xff, 0xff, //     #####     
	                              //               
	                              //               
                                      //               
                                      //               
	                              //               
                                      //               

	// @680 '1' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //    #####      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //    #####      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xf0, 0x00, 0x00, 0x03, //       ##      
	0xff, 0xf0, 0x00, 0x00, 0x03, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @720 '2' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //     #####     
	0xff, 0xf0, 0xff, 0xfc, 0x3f, //    #######    
	0xff, 0xf0, 0x3f, 0xfc, 0x0f, //   ###   ###   
	0xff, 0xf0, 0x0f, 0xff, 0x03, //   ##     ##   
	0xff, 0xf0, 0xc3, 0xff, 0xc3, //          ##   
	0xff, 0xf0, 0xf0, 0xff, 0xc3, //         ##    
	0xff, 0xf0, 0xfc, 0x3f, 0xc3, //        ##     
	0xff, 0xf0, 0xff, 0x0f, 0x03, //       ##      
	0xff, 0xf0, 0xff, 0xc0, 0x0f, //      ##       
	0xff, 0xf0, 0xff, 0xf0, 0x3f, //     ##        
  0xff, 0xff, 0xff, 0xff, 0xff, //    ##         
	0xff, 0xff, 0xff, 0xff, 0xff, //   #########   
	0xff, 0xff, 0xff, 0xff, 0xff, //   #########   
	                              //               
	                              //               
	                              //               
                                      //               
	                              //               
                                      //               

	// @760 '3' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xfc, 0x3f, 0xff, 0xff, //     #####     
	0xff, 0xf0, 0x3f, 0xff, 0x0f, //   ########    
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##    ###   
	0xff, 0xf0, 0xff, 0xff, 0xc3, //          ##   
	0xff, 0xf0, 0xff, 0x0f, 0xc3, //         ###   
	0xff, 0xf0, 0xff, 0x0f, 0xc3, //      #####    
	0xff, 0xf0, 0xff, 0x0f, 0xc3, //      #####    
	0xff, 0xf0, 0x3c, 0x03, 0x03, //         ###   
	0xff, 0xfc, 0x00, 0x00, 0x0f, //          ##   
	0xff, 0xff, 0x00, 0xf0, 0x3f, //          ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //  ##     ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //  #########    
	0xff, 0xff, 0xff, 0xff, 0xff, //   #######     
	                              //               
	                              //               
	                              //               
	                              //               
                                      //               
                                      //               

	// @800 '4' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //        ###    
	0xff, 0xff, 0xc0, 0xff, 0xff, //       ####    
	0xff, 0xff, 0xc0, 0x3f, 0xff, //       ####    
	0xff, 0xff, 0xc3, 0x03, 0xff, //      ## ##    
	0xff, 0xff, 0xc3, 0xc0, 0xff, //     ##  ##    
	0xff, 0xf0, 0xc3, 0xfc, 0x0f, //     ##  ##    
	0xff, 0xf0, 0xc3, 0xff, 0x03, //    ##   ##    
	0xff, 0xf0, 0x00, 0x00, 0x03, //   ##    ##    
	0xff, 0xf0, 0x00, 0x00, 0x03, //   #########   
	0xff, 0xf0, 0xc3, 0xff, 0xff, //   #########   
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //       #####   
	0xff, 0xff, 0xff, 0xff, 0xff, //       #####   
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @840 '5' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //    #######    
	0xff, 0xfc, 0x3f, 0xff, 0xff, //    #######    
	0xff, 0xf0, 0x3f, 0x00, 0x03, //    ##         
	0xff, 0xf0, 0xff, 0x00, 0x03, //    ##         
	0xff, 0xf0, 0xff, 0xc3, 0xc3, //    ######     
	0xff, 0xf0, 0xff, 0xc3, 0xc3, //    #######    
	0xff, 0xf0, 0xff, 0xc3, 0xc3, //    ##   ###   
	0xff, 0xf0, 0x3f, 0x03, 0xc3, //          ##   
	0xff, 0xfc, 0x00, 0x0f, 0xc3, //          ##   
	0xff, 0xff, 0x00, 0x3f, 0xff, //          ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##    ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ########    
	0xff, 0xff, 0xff, 0xff, 0xff, //    ######     
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @880 '6' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       #####   
	0xff, 0xff, 0xc0, 0x03, 0xff, //     #######   
	0xff, 0xfc, 0x00, 0x00, 0x3f, //    ####       
	0xff, 0xfc, 0x3c, 0x30, 0x0f, //    ##         
	0xff, 0xf0, 0xff, 0x0f, 0x0f, //   ###         
	0xff, 0xf0, 0xff, 0x0f, 0x03, //   ## ####     
	0xff, 0xf0, 0xff, 0x0f, 0xc3, //   ########    
	0xff, 0xf0, 0x3c, 0x0f, 0xc3, //   ###   ###   
	0xff, 0xfc, 0x00, 0x3f, 0xc3, //   ##     ##   
	0xff, 0xff, 0x00, 0xff, 0xc3, //   ##     ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ##   ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //    #######    
	0xff, 0xff, 0xff, 0xff, 0xff, //      ####     
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @920 '7' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //   #########   
	0xff, 0xff, 0xff, 0xff, 0x03, //   #########   
	0xff, 0xff, 0xff, 0xff, 0x03, //   ##     ##   
	0xff, 0xff, 0xff, 0xff, 0xc3, //          ##   
	0xff, 0xff, 0xff, 0xff, 0xc3, //         ##    
	0xff, 0xf0, 0x3f, 0xff, 0xc3, //         ##    
	0xff, 0xf0, 0x00, 0xff, 0xc3, //         ##    
	0xff, 0xff, 0xc0, 0x03, 0xc3, //        ##     
	0xff, 0xff, 0xfc, 0x00, 0x03, //        ##     
	0xff, 0xff, 0xff, 0xfc, 0x03, //        ##     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @960 '8' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //     #####     
	0xff, 0xff, 0x00, 0xf0, 0x3f, //    #######    
	0xff, 0xfc, 0x00, 0x00, 0x0f, //   ###   ###   
	0xff, 0xf0, 0x3c, 0x03, 0x03, //   ##     ##   
	0xff, 0xf0, 0xff, 0x0f, 0xc3, //   ###   ###   
	0xff, 0xf0, 0xff, 0x0f, 0xc3, //    #######    
	0xff, 0xf0, 0xff, 0x0f, 0xc3, //    #######    
	0xff, 0xf0, 0x3c, 0x03, 0x03, //   ###   ###   
	0xff, 0xfc, 0x00, 0x00, 0x0f, //   ##     ##   
	0xff, 0xff, 0x00, 0xf0, 0x3f, //   ##     ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ###   ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //    #######    
	0xff, 0xff, 0xff, 0xff, 0xff, //     #####     
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               
                                      //               

	// @1000 '9' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //     ####      
	0xff, 0xf0, 0xff, 0xc0, 0x3f, //    #######    
	0xff, 0xf0, 0xff, 0x00, 0x0f, //   ###   ##    
	0xff, 0xf0, 0xfc, 0x0f, 0x03, //   ##     ##   
	0xff, 0xf0, 0xfc, 0x3f, 0xc3, //   ##     ##   
	0xff, 0xf0, 0x3c, 0x3f, 0xc3, //   ###   ###   
	0xff, 0xfc, 0x3c, 0x3f, 0xc3, //    ########   
	0xff, 0xfc, 0x03, 0x0f, 0x0f, //     #### ##   
	0xff, 0xff, 0x00, 0x00, 0x0f, //         ###   
	0xff, 0xff, 0xf0, 0x00, 0xff, //         ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //       ####    
	0xff, 0xff, 0xff, 0xff, 0xff, //   #######     
	0xff, 0xff, 0xff, 0xff, 0xff, //   #####       
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @1040 ':' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xf0, 0x3f, 0x03, 0xff, //       ###     
	0xff, 0xf0, 0x3f, 0x03, 0xff, //       ###     
	0xff, 0xf0, 0x3f, 0x03, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @1080 ';' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xf0, 0x3f, 0xff, 0xff, 0xff, //        ###    
	0xfc, 0x03, 0xff, 0xff, 0xff, //        ###    
	0xff, 0xc3, 0xf0, 0x3f, 0xff, //        ###    
	0xff, 0xf3, 0xf0, 0x3f, 0xff, //               
	0xff, 0xff, 0xf0, 0x3f, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ##       
	                              //      ##       
	                              //      #        
	                              //               
	                              //               

	// @1120 '<' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xfc, 0xff, 0xff, //               
	0xff, 0xff, 0xfc, 0xff, 0xff, //               
	0xff, 0xff, 0xf0, 0x3f, 0xff, //           ##  
	0xff, 0xff, 0xf0, 0x3f, 0xff, //         ####  
	0xff, 0xff, 0xc3, 0x0f, 0xff, //       ####    
	0xff, 0xff, 0x0f, 0xc3, 0xff, //      ###      
	0xff, 0xff, 0x0f, 0xc3, 0xff, //    ###        
	0xff, 0xfc, 0x3f, 0xf0, 0xff, //  ####         
	0xff, 0xfc, 0x3f, 0xf0, 0xff, //    ###        
	0xff, 0xf0, 0xff, 0xfc, 0x3f, //      ###      
	0xff, 0xf0, 0xff, 0xfc, 0x3f, //       ####    
	0xff, 0xff, 0xff, 0xff, 0xff, //         ####  
	0xff, 0xff, 0xff, 0xff, 0xff, //           ##  
	                              //               
                                      //               
	                              //               
                                      //               
                                      //               
                                      //               

	// @1160 '=' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xc3, 0xc3, 0xff, //               
	0xff, 0xff, 0xc3, 0xc3, 0xff, //               
	0xff, 0xff, 0xc3, 0xc3, 0xff, //               
	0xff, 0xff, 0xc3, 0xc3, 0xff, //               
	0xff, 0xff, 0xc3, 0xc3, 0xff, //  ###########  
	0xff, 0xff, 0xc3, 0xc3, 0xff, //  ###########  
	0xff, 0xff, 0xc3, 0xc3, 0xff, //               
	0xff, 0xff, 0xc3, 0xc3, 0xff, //               
	0xff, 0xff, 0xc3, 0xc3, 0xff, //  ###########  
	0xff, 0xff, 0xc3, 0xc3, 0xff, //  ###########  
	0xff, 0xff, 0xc3, 0xc3, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
	                              //               
	                              //               
	                              //               
                                      //               
                                      //               

	// @1200 '>' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xfc, 0x3f, //               
	0xff, 0xf0, 0xff, 0xfc, 0x3f, //   ##          
	0xff, 0xfc, 0x3f, 0xf0, 0xff, //   ####        
	0xff, 0xfc, 0x3f, 0xf0, 0xff, //     ####      
	0xff, 0xff, 0x0f, 0xc3, 0xff, //       ###     
	0xff, 0xff, 0x0f, 0xc3, 0xff, //         ###   
	0xff, 0xff, 0xc3, 0x0f, 0xff, //          #### 
	0xff, 0xff, 0xf0, 0x3f, 0xff, //         ###   
	0xff, 0xff, 0xf0, 0x3f, 0xff, //       ###     
	0xff, 0xff, 0xfc, 0xff, 0xff, //     ####      
	0xff, 0xff, 0xfc, 0xff, 0xff, //   ####        
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##          
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @1240 '?' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //     #####     
	0xff, 0xff, 0xff, 0xf0, 0x3f, //    #######    
	0xff, 0xff, 0xff, 0xf0, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xff, 0xff, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xf0, 0xff, 0x0f, //          ##   
	0xff, 0xf0, 0xf0, 0x3f, 0x0f, //        ###    
	0xff, 0xff, 0xfc, 0x3f, 0x0f, //       ###     
	0xff, 0xff, 0xff, 0x00, 0x3f, //       ##      
	0xff, 0xff, 0xff, 0xc0, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	                              //               
	                              //               
	                              //               
                                      //               
	                              //               
                                      //               

	// @1280 '@' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##  #     
	0xff, 0xff, 0x00, 0x00, 0xff, //     #    #    
	0xff, 0xf0, 0xff, 0xff, 0x0f, //    #     #    
	0xff, 0xcf, 0xff, 0xff, 0xcf, //    #     #    
	0xff, 0xcf, 0xf0, 0x3f, 0xf3, //    #   ###    
	0xff, 0xcf, 0xcf, 0xcf, 0xf3, //    #  #  #    
	0xff, 0xcf, 0xcf, 0xcf, 0xc3, //    #  #  #    
	0xff, 0xf3, 0xc0, 0x00, 0x3f, //    #  #  #    
	0xff, 0xff, 0xff, 0xff, 0xff, //    #   ###    
	0xff, 0xff, 0xff, 0xff, 0xff, //    #          
	0xff, 0xff, 0xff, 0xff, 0xff, //     #         
	0xff, 0xff, 0xff, 0xff, 0xff, //     #    #    
	                              //      ####     
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               

	// @1320 'A' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0x3f, 0xff, 0xff, //    ######     
	0xff, 0xf0, 0x03, 0xff, 0x0f, //    ######     
	0xff, 0xf0, 0xc0, 0x3f, 0x0f, //       ###     
	0xff, 0xff, 0xc0, 0x03, 0x0f, //      ## ##    
	0xff, 0xff, 0xc3, 0xc0, 0x0f, //      ## ##    
	0xff, 0xff, 0xc3, 0xfc, 0x0f, //     ##  ##    
	0xff, 0xff, 0xc3, 0x00, 0x0f, //     ##   ##   
	0xff, 0xf0, 0xc0, 0x03, 0xff, //    ########   
	0xff, 0xf0, 0x00, 0xff, 0xff, //    ########   
	0xff, 0xf0, 0x3f, 0xff, 0xff, //   ##      ##  
	0xff, 0xf0, 0xff, 0xff, 0xff, //  ####    #### 
	0xff, 0xff, 0xff, 0xff, 0xff, //  ####    #### 
	                              //               
	                              //               
                                      //               
                                      //               
	                              //               
	                              //               

	// @1360 'B' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   #######     
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   ########    
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##   ###   
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    #######    
	0xff, 0xf0, 0xfc, 0x0f, 0x0f, //    ########   
	0xff, 0xf0, 0xf0, 0x00, 0x3f, //    ##    ###  
	0xff, 0xf0, 0x00, 0xc0, 0xff, //    ##     ##  
	0xff, 0xfc, 0x03, 0xff, 0xff, //    ##     ##  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##########  
	0xff, 0xff, 0xff, 0xff, 0xff, //   #########   
	                              //               
                                      //               
	                              //               
	                              //               
	                              //               
	                              //               

	// @1400 'C' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xc0, 0x03, 0xff, //      #### ##  
	0xff, 0xff, 0x00, 0x00, 0xff, //     ########  
	0xff, 0xfc, 0x0f, 0xf0, 0x3f, //    ###   ###  
	0xff, 0xf0, 0x3f, 0xfc, 0x0f, //   ###     ##  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##          
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##          
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##          
	0xff, 0xf0, 0x3f, 0xfc, 0x3f, //   ##          
	0xff, 0xfc, 0x0f, 0xf0, 0x0f, //   ###     ##  
	0xff, 0xff, 0x0f, 0xf0, 0x0f, //    ###   ###  
	0xff, 0xff, 0xff, 0xff, 0xff, //     #######   
	0xff, 0xff, 0xff, 0xff, 0xff, //      #####    
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               
                                      //               

	// @1440 'D' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //               
	0xff, 0xf0, 0x00, 0x00, 0x0f, //  ########     
	0xff, 0xf0, 0x00, 0x00, 0x0f, //  #########    
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##    ###   
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##     ###  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##      ##  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##      ##  
	0xff, 0xf0, 0x3f, 0xfc, 0x0f, //   ##      ##  
	0xff, 0xfc, 0x0f, 0xf0, 0x3f, //   ##      ##  
	0xff, 0xff, 0x00, 0x00, 0xff, //   ##     ###  
	0xff, 0xff, 0xc0, 0x03, 0xff, //   ##    ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //  #########    
	0xff, 0xff, 0xff, 0xff, 0xff, //  ########     
	                              //               
	                              //               
	                              //               
	                              //               
                                      //               
                                      //               

	// @1480 'E' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##########  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   ##########  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##     ##  
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##     ##  
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##  ##     
	0xff, 0xf0, 0xf0, 0x0f, 0x0f, //    ######     
	0xff, 0xf0, 0xf0, 0x0f, 0x0f, //    ######     
	0xff, 0xf0, 0xff, 0xff, 0x0f, //    ##  ##     
	0xff, 0xf0, 0x0f, 0xf0, 0x0f, //    ##     ##  
	0xff, 0xf0, 0x0f, 0xf0, 0x0f, //    ##     ##  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##########  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##########  
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @1520 'F' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##########  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   ##########  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##     ##  
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##     ##  
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##  ##     
	0xff, 0xf0, 0xf0, 0x0f, 0x0f, //    ######     
	0xff, 0xf0, 0xf0, 0x0f, 0x0f, //    ######     
	0xff, 0xff, 0xff, 0xff, 0x0f, //    ##  ##     
	0xff, 0xff, 0xff, 0xf0, 0x0f, //    ##         
	0xff, 0xff, 0xff, 0xf0, 0x0f, //    ##         
	0xff, 0xff, 0xff, 0xff, 0xff, //   ######      
	0xff, 0xff, 0xff, 0xff, 0xff, //   ######      
	                              //               
                                      //               
	                              //               
                                      //               
                                      //               
                                      //               

	// @1560 'G' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xc0, 0x03, 0xff, //      #### ##  
	0xff, 0xfc, 0x00, 0x00, 0x3f, //    #########  
	0xff, 0xfc, 0x00, 0x00, 0x3f, //    ##    ###  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##      ##  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##          
	0xff, 0xf0, 0xf0, 0xff, 0x0f, //   ##          
	0xff, 0xf0, 0xf0, 0xff, 0x0f, //   ##   ###### 
	0xff, 0xf0, 0xf0, 0xfc, 0x3f, //   ##   ###### 
	0xff, 0xfc, 0x00, 0xf0, 0x0f, //   ##      ##  
	0xff, 0xfc, 0x00, 0xf0, 0x0f, //    ##     ##  
	0xff, 0xff, 0xf0, 0xff, 0xff, //    #########  
	0xff, 0xff, 0xff, 0xff, 0xff, //      #####    
	                              //               
	                              //               
                                      //               
	                              //               
                                      //               
	                              //               

	// @1600 'H' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ####  ####  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   ####  ####  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##    ##   
	0xff, 0xff, 0xfc, 0x3f, 0xff, //    ##    ##   
	0xff, 0xff, 0xfc, 0x3f, 0xff, //    ########   
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ########   
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##    ##   
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xff, 0xff, 0x0f, //    ##    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ####  ####  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ####  ####  
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               

	// @1640 'I' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xf0, 0xff, 0xff, 0x0f, //    ########   
	0xff, 0xf0, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xf0, 0x00, 0x00, 0x0f, //       ##      
	0xff, 0xf0, 0x00, 0x00, 0x0f, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @1680 'J' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xfc, 0x00, 0xff, 0xff, //       ####### 
	0xff, 0xfc, 0x00, 0xff, 0xff, //       ####### 
	0xff, 0xf0, 0xff, 0xff, 0xff, //          ##   
	0xff, 0xf0, 0xff, 0xff, 0xff, //          ##   
	0xff, 0xf0, 0xff, 0xff, 0x0f, //          ##   
	0xff, 0xf0, 0xff, 0xff, 0x0f, //          ##   
	0xff, 0xf0, 0x3f, 0xff, 0x0f, //   ##     ##   
	0xff, 0xfc, 0x00, 0x00, 0x0f, //   ##     ##   
	0xff, 0xff, 0x00, 0x00, 0x0f, //   ##     ##   
	0xff, 0xff, 0xff, 0xff, 0x0f, //   ##    ###   
	0xff, 0xff, 0xff, 0xff, 0x0f, //   ########    
	0xff, 0xff, 0xff, 0xff, 0xff, //     #####     
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               

	// @1720 'K' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##### ##### 
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   ##### ##### 
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##   ###   
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##  ##     
	0xff, 0xf0, 0xff, 0x0f, 0x0f, //    ## ##      
	0xff, 0xff, 0xfc, 0x03, 0xff, //    #####      
	0xff, 0xff, 0xc0, 0xf0, 0x0f, //    ### ##     
	0xff, 0xfc, 0x03, 0xfc, 0x0f, //    ##   ##    
	0xff, 0xf0, 0x3f, 0xfc, 0x0f, //    ##   ##    
	0xff, 0xf0, 0xff, 0xff, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   #####  #### 
	0xff, 0xff, 0xff, 0xff, 0xff, //   #####   ### 
	                              //               
	                              //               
	                              //               
	                              //               
                                      //               
	                              //               

	// @1760 'L' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ######      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ######      
	0xff, 0xf0, 0x00, 0x00, 0x0f, //     ##        
	0xff, 0xf0, 0x00, 0x00, 0x0f, //     ##        
	0xff, 0xf0, 0xff, 0xff, 0x0f, //     ##        
	0xff, 0xf0, 0xff, 0xff, 0x0f, //     ##        
	0xff, 0xf0, 0xff, 0xff, 0xff, //     ##        
	0xff, 0xf0, 0xff, 0xff, 0xff, //     ##    ##  
	0xff, 0xf0, 0x03, 0xff, 0xff, //     ##    ##  
	0xff, 0xf0, 0x03, 0xff, 0xff, //     ##    ##  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##########  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##########  
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               

	// @1800 'M' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //               
	0xff, 0xf0, 0x00, 0x00, 0x0f, //  ####    #### 
	0xff, 0xf0, 0x00, 0x00, 0x0f, //  ####    #### 
	0xff, 0xf0, 0xff, 0xf0, 0x0f, //   ###    ###  
	0xff, 0xf0, 0xfc, 0x03, 0xff, //   ####  ####  
	0xff, 0xff, 0xc0, 0x3f, 0xff, //   ## #  # ##  
	0xff, 0xff, 0xc0, 0x3f, 0xff, //   ## #### ##  
	0xff, 0xf0, 0xfc, 0x03, 0xff, //   ## #### ##  
	0xff, 0xf0, 0xff, 0xf0, 0x0f, //   ##  ##  ##  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   ##  ##  ##  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   ##      ##  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //  #####  ##### 
	0xff, 0xff, 0xff, 0xff, 0xff, //  #####  ##### 
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @1840 'N' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ###  #####  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   #### #####  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ###   ##   
	0xff, 0xf0, 0xff, 0xc0, 0x3f, //    ####  ##   
	0xff, 0xf0, 0xfc, 0x03, 0xff, //    ####  ##   
	0xff, 0xff, 0xc0, 0x3f, 0x0f, //    ## ## ##   
	0xff, 0xfc, 0x03, 0xff, 0x0f, //    ## ## ##   
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##  ####   
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##  ####   
	0xff, 0xff, 0xff, 0xff, 0x0f, //    ##   ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##### ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //   #####  ##   
	                              //               
	                              //        
                                      //               
                                      //               
                                      //               
                                      //               

	// @1880 'O' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xc0, 0x03, 0xff, //      ####     
	0xff, 0xff, 0x00, 0x00, 0xff, //     ######    
	0xff, 0xfc, 0x0f, 0xf0, 0x3f, //    ###  ###   
	0xff, 0xf0, 0x3f, 0xfc, 0x0f, //   ###    ###  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##      ##  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##      ##  
	0xff, 0xf0, 0x3f, 0xfc, 0x0f, //   ##      ##  
	0xff, 0xfc, 0x0f, 0xf0, 0x3f, //   ##      ##  
	0xff, 0xff, 0x00, 0x00, 0xff, //   ###    ###  
	0xff, 0xff, 0xc0, 0x03, 0xff, //    ###  ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //     ######    
	0xff, 0xff, 0xff, 0xff, 0xff, //      ####     
                                      //               
	                              //               
	                              //               
	                              //               
                                      //               
                                      //               
 
	// @1920 'P' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ########    
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   #########   
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##    ###  
	0xff, 0xf0, 0xf0, 0xff, 0x0f, //    ##     ##  
	0xff, 0xf0, 0xf0, 0xff, 0x0f, //    ##     ##  
	0xff, 0xf0, 0xf0, 0xff, 0x0f, //    ##    ###  
	0xff, 0xff, 0xf0, 0xff, 0x0f, //    ########   
	0xff, 0xff, 0xf0, 0x3c, 0x0f, //    #######    
	0xff, 0xff, 0xfc, 0x00, 0x3f, //    ##         
	0xff, 0xff, 0xff, 0x00, 0xff, //    ##         
	0xff, 0xff, 0xff, 0xff, 0xff, //   ######      
	0xff, 0xff, 0xff, 0xff, 0xff, //   ######      
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @1960 'Q' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xc0, 0x03, 0xff, //      ####     
	0xff, 0xff, 0x00, 0x00, 0xff, //     ######    
	0xfc, 0x3c, 0x0f, 0xf0, 0x3f, //    ###  ###   
	0xfc, 0x00, 0x3f, 0xfc, 0x0f, //   ###    ###  
	0xff, 0x00, 0xff, 0xff, 0x0f, //   ##      ##  
	0xff, 0x00, 0xff, 0xff, 0x0f, //   ##      ##  
	0xfc, 0x00, 0x3f, 0xfc, 0x0f, //   ##      ##  
	0xfc, 0x3c, 0x0f, 0xf0, 0x3f, //   ##      ##  
	0xfc, 0x0f, 0x00, 0x00, 0xff, //   ###    ###  
	0xff, 0x0f, 0xc0, 0x03, 0xff, //    ###  ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //     ######    
	0xff, 0xff, 0xff, 0xff, 0xff, //      ####     
	                              //      #### ##  
                                      //     ########  
                                      //     ##  ###   
                                      //               
                                      //               
	                              //               

	// @2000 'R' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ########    
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   #########   
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ##    ###  
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##     ##  
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ##    ###  
	0xff, 0xff, 0xfc, 0x3f, 0x0f, //    ########   
	0xff, 0xff, 0xf0, 0x3f, 0x0f, //    #######    
	0xff, 0xff, 0x00, 0x0c, 0x0f, //    ##   ###   
	0xff, 0xfc, 0x03, 0x00, 0x3f, //    ##    ##   
	0xff, 0xf0, 0xff, 0xc0, 0xff, //    ##    ###  
	0xff, 0xf0, 0xff, 0xff, 0xff, //   #####   ### 
	0xff, 0xff, 0xff, 0xff, 0xff, //   #####    ## 
	                              //               
	                              //               
	                              //               
	                              //               
                                      //               
	                              //               

	// @2040 'S' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0x0f, 0xc0, 0xff, //     ##### ##  
	0xff, 0xf0, 0x0f, 0x00, 0x3f, //    #########  
	0xff, 0xfc, 0x3f, 0x0c, 0x0f, //   ###    ###  
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //   ##      ##  
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //   ###         
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //    ######     
	0xff, 0xf0, 0xfc, 0x3f, 0x0f, //      ######   
	0xff, 0xf0, 0x30, 0xfc, 0x3f, //          ###  
	0xff, 0xfc, 0x00, 0xf0, 0x0f, //   ##      ##  
	0xff, 0xff, 0x03, 0xf0, 0x0f, //   ###    ###  
	0xff, 0xff, 0xff, 0xff, 0xff, //   #########   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ## #####    
	                              //        
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2080 'T' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xc0, 0x0f, //   ##########  
	0xff, 0xff, 0xff, 0xc0, 0x0f, //   ##########  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##  ##  ##  
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##  ##  ##  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   ##  ##  ##  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xc0, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xc0, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //     ######    
	0xff, 0xff, 0xff, 0xff, 0xff, //     ######    
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2120 'U' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0x0f, //   ####  ####  
	0xff, 0xff, 0x00, 0x00, 0x0f, //   ####  ####  
	0xff, 0xfc, 0x00, 0x00, 0x0f, //    ##    ##   
	0xff, 0xf0, 0x3f, 0xff, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xff, 0xff, 0xff, //    ##    ##   
	0xff, 0xf0, 0xff, 0xff, 0xff, //    ##    ##   
	0xff, 0xf0, 0x3f, 0xff, 0x0f, //    ##    ##   
	0xff, 0xfc, 0x00, 0x00, 0x0f, //    ##    ##   
	0xff, 0xff, 0x00, 0x00, 0x0f, //    ##    ##   
	0xff, 0xff, 0xff, 0xff, 0x0f, //    ###  ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //     ######    
	0xff, 0xff, 0xff, 0xff, 0xff, //      ####     
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2160 'V' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0x0f, //               
	0xff, 0xff, 0xff, 0xf0, 0x0f, //  ####   ####  
	0xff, 0xff, 0xff, 0x00, 0x0f, //  ####   ####  
	0xff, 0xff, 0xc0, 0x0f, 0x0f, //   ##     ##   
	0xff, 0xf0, 0x00, 0xff, 0xff, //   ##     ##   
	0xff, 0xf0, 0x3f, 0xff, 0xff, //    ##   ##    
	0xff, 0xf0, 0x00, 0xff, 0xff, //    ##   ##    
	0xff, 0xff, 0xc0, 0x0f, 0x0f, //     ## ##     
	0xff, 0xff, 0xff, 0x00, 0x0f, //     ## ##     
	0xff, 0xff, 0xff, 0xf0, 0x0f, //     ## ##     
	0xff, 0xff, 0xff, 0xff, 0x0f, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2200 'W' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0x0f, //               
	0xff, 0xff, 0xfc, 0x00, 0x0f, //  #####   #####
	0xff, 0xf0, 0x00, 0x00, 0x0f, //  #####   #####
	0xff, 0xf0, 0x0f, 0xff, 0x0f, //   ##       ## 
	0xff, 0xfc, 0x00, 0xff, 0x0f, //   ##  ###  ## 
	0xff, 0xff, 0xf0, 0x03, 0xff, //   ##  ###  ## 
	0xff, 0xff, 0xff, 0x03, 0xff, //   ##  ###  ## 
	0xff, 0xff, 0xf0, 0x03, 0xff, //   ## ## ## ## 
	0xff, 0xfc, 0x00, 0xff, 0x0f, //    # ## ## #  
	0xff, 0xf0, 0x0f, 0xff, 0x0f, //    ###   ###  
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ###   ###  
	0xff, 0xff, 0xfc, 0x00, 0x0f, //    ###   ###  
	0xff, 0xff, 0xff, 0xff, 0x0f, //    ##     ##  
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2240 'X' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0x0f, //               
	0xff, 0xf0, 0x3f, 0xfc, 0x0f, //  ####   ####  
	0xff, 0xf0, 0x0f, 0xf0, 0x0f, //  ####   ####  
	0xff, 0xf0, 0xc3, 0xc3, 0x0f, //   ##     ##   
	0xff, 0xff, 0xf0, 0x0f, 0xff, //    ##   ##    
	0xff, 0xff, 0xfc, 0x3f, 0xff, //     ## ##     
	0xff, 0xff, 0xf0, 0x0f, 0xff, //      ###      
	0xff, 0xf0, 0xc3, 0xc3, 0x0f, //      ###      
	0xff, 0xf0, 0x0f, 0xf0, 0x0f, //     ## ##     
	0xff, 0xf0, 0x3f, 0xfc, 0x0f, //    ##   ##    
	0xff, 0xf0, 0xff, 0xff, 0x0f, //   ##     ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //  ####   ####  
	0xff, 0xff, 0xff, 0xff, 0xff, //  ####   ####  
                                      //               
	                              //               
                                      //               
	                              //               
                                      //               
                                      //               

	// @2280 'Y' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0x0f, //   ####  ####  
	0xff, 0xff, 0xff, 0xfc, 0x0f, //   ####  ####  
	0xff, 0xf0, 0xff, 0xf0, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xff, 0x03, 0x0f, //     ##  ##    
	0xff, 0xf0, 0x00, 0x0f, 0xff, //      ####     
	0xff, 0xf0, 0x00, 0x0f, 0xff, //      ####     
	0xff, 0xf0, 0xff, 0x03, 0x0f, //       ##      
	0xff, 0xf0, 0xff, 0xf0, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xfc, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //     ######    
	0xff, 0xff, 0xff, 0xff, 0xff, //     ######    
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2320 'Z' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xf0, 0x3f, 0xf0, 0x0f, //    ########   
	0xff, 0xf0, 0x0f, 0xf0, 0x0f, //    ##    ##   
	0xff, 0xf0, 0xc3, 0xff, 0x0f, //    ##   ##    
	0xff, 0xf0, 0xf0, 0x3f, 0x0f, //        ##     
	0xff, 0xf0, 0xfc, 0x0f, 0x0f, //       ##      
	0xff, 0xf0, 0xff, 0xc3, 0x0f, //       ##      
	0xff, 0xf0, 0x0f, 0xf0, 0x0f, //      ##       
	0xff, 0xf0, 0x0f, 0xfc, 0x0f, //     ##   ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ##    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
                                      //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2360 '[' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ####    
	0xff, 0xff, 0xff, 0xff, 0xff, //       ####    
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xfc, 0x00, 0x00, 0x00, 0x0f, //       ##      
	0xfc, 0x00, 0x00, 0x00, 0x0f, //       ##      
	0xfc, 0x3f, 0xff, 0xff, 0x0f, //       ##      
	0xfc, 0x3f, 0xff, 0xff, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	                              //       ##      
	                              //       ####    
                                      //       ####    
                                      //               
                                      //               
                                      //               

	// @2400 '\' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //    ##         
	0xff, 0xff, 0xff, 0xff, 0xff, //    ##         
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##        
	0xff, 0xff, 0xff, 0xff, 0xf0, //     ##        
	0xff, 0xff, 0xff, 0xfc, 0x00, //     ##        
	0xff, 0xff, 0xff, 0xc0, 0x0f, //      ##       
	0xff, 0xff, 0xfc, 0x03, 0xff, //      ##       
	0xff, 0xff, 0xc0, 0x3f, 0xff, //       ##      
	0xff, 0xf0, 0x03, 0xff, 0xff, //       ##      
	0xff, 0x00, 0x3f, 0xff, 0xff, //        ##     
	0xff, 0x0f, 0xff, 0xff, 0xff, //        ##     
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	                              //          ##   
	                              //          ##   
	                              //               
                                      //               
                                      //               
	                              //               

	// @2440 ']' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //     ####      
	0xff, 0xff, 0xff, 0xff, 0xff, //     ####      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xfc, 0x3f, 0xff, 0xff, 0x0f, //       ##      
	0xfc, 0x3f, 0xff, 0xff, 0x0f, //       ##      
	0xfc, 0x00, 0x00, 0x00, 0x0f, //       ##      
	0xfc, 0x00, 0x00, 0x00, 0x0f, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
                                      //       ##      
	                              //     ####      
	                              //     ####      
                                      //               
	                              //               
                                      //               

	// @2480 '^' (14 lines)
  0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       #       
	0xff, 0xff, 0xff, 0xc3, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xf0, 0xff, //     ## ##     
	0xff, 0xff, 0xff, 0xfc, 0x3f, //    ##   ##    
	0xff, 0xff, 0xff, 0xff, 0x0f, //   ##     ##   
	0xff, 0xff, 0xff, 0xff, 0xc3, //   #       #   
	0xff, 0xff, 0xff, 0xff, 0x0f, //               
	0xff, 0xff, 0xff, 0xfc, 0x3f, //               
	0xff, 0xff, 0xff, 0xf0, 0xff, //               
	0xff, 0xff, 0xff, 0xc3, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
	                              //               
	                              //               
                                      //               
	                              //               
                                      //               

	// @2520 '_' (14 lines)
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	0x0f, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
	                              //               
	                              //               
	                              //               
                                      // ##############
                                      // ##############

	// @2560 '`' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //      #        
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //         #     
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xf3, //               
	0xff, 0xff, 0xff, 0xff, 0xcf, //               
	0xff, 0xff, 0xff, 0xff, 0xcf, //               
	0xff, 0xff, 0xff, 0xff, 0x3f, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2600 'a' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xfc, 0x0f, 0xff, 0xff, //               
	0xff, 0xf0, 0x03, 0xcf, 0xff, //               
	0xff, 0xf0, 0xc0, 0xc3, 0xff, //               
	0xff, 0xf0, 0xf0, 0xc3, 0xff, //     ######    
	0xff, 0xf0, 0xf0, 0xc3, 0xff, //    ########   
	0xff, 0xfc, 0x30, 0xc3, 0xff, //          ##   
	0xff, 0xf0, 0x00, 0x03, 0xff, //     #######   
	0xff, 0xf0, 0x00, 0x0f, 0xff, //    ########   
	0xff, 0xf0, 0xff, 0xff, 0xff, //   ###    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##    ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ##########  
	0xff, 0xff, 0xff, 0xff, 0xff, //    ##### ###  
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               
                                      //               

	// @2640 'b' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0xc3, //  ###          
	0xff, 0xf0, 0x00, 0x00, 0x03, //  ###          
	0xff, 0xf0, 0x00, 0x00, 0x03, //   ##          
	0xff, 0xfc, 0x3f, 0x0f, 0xff, //   ##          
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   ## ####     
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   #########   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   ###    ##   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   ##      ##  
	0xff, 0xfc, 0x3f, 0x0f, 0xff, //   ##      ##  
	0xff, 0xfc, 0x00, 0x0f, 0xff, //   ##      ##  
	0xff, 0xff, 0xc0, 0xff, 0xff, //   ###    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //  ##########   
	0xff, 0xff, 0xff, 0xff, 0xff, //  ### ####     
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2680 'c' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0x00, 0xff, 0xff, //               
	0xff, 0xfc, 0x00, 0x0f, 0xff, //               
	0xff, 0xf0, 0x3f, 0x0f, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //      #### ##  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    #########  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ##     ##  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   ##      ##  
	0xff, 0xf0, 0xff, 0xcf, 0xff, //   ##          
	0xff, 0xfc, 0x3c, 0x03, 0xff, //   ##          
	0xff, 0xfc, 0x3c, 0x03, 0xff, //   ###     ##  
	0xff, 0xff, 0xff, 0xff, 0xff, //    #########  
	0xff, 0xff, 0xff, 0xff, 0xff, //     ######    
	                              //               
                                      //               
                                      //               
	                              //               
                                      //               
                                      //               

	// @2720 'd' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //          ###  
	0xff, 0xff, 0x00, 0xff, 0xff, //          ###  
	0xff, 0xfc, 0x00, 0x0f, 0xff, //           ##  
	0xff, 0xfc, 0x3f, 0x0f, 0xff, //           ##  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //      #### ##  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    #########  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ##    ###  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   ##      ##  
	0xff, 0xfc, 0x3f, 0x0f, 0xc3, //   ##      ##  
	0xff, 0xf0, 0x00, 0x00, 0x03, //   ##      ##  
	0xff, 0xf0, 0x00, 0x00, 0x03, //   ###    ###  
	0xff, 0xf0, 0xff, 0xff, 0xff, //    ########## 
	0xff, 0xff, 0xff, 0xff, 0xff, //      #### ### 
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2760 'e' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xc0, 0xff, 0xff, //               
	0xff, 0xfc, 0x00, 0x0f, 0xff, //               
	0xff, 0xfc, 0x30, 0x0f, 0xff, //               
	0xff, 0xf0, 0xf0, 0xc3, 0xff, //      ####     
	0xff, 0xf0, 0xf0, 0xc3, 0xff, //    ########   
	0xff, 0xf0, 0xf0, 0xc3, 0xff, //    ##    ##   
	0xff, 0xf0, 0xf0, 0xc3, 0xff, //   ##########  
	0xff, 0xf0, 0xf0, 0x0f, 0xff, //   ##########  
	0xff, 0xfc, 0x30, 0x0f, 0xff, //   ##          
	0xff, 0xfc, 0x30, 0xff, 0xff, //    ##     ##  
	0xff, 0xff, 0xff, 0xff, 0xff, //    #########  
	0xff, 0xff, 0xff, 0xff, 0xff, //      #####    
	                              //               
	                              //               
	                              //               
                                      //               
	                              //               
                                      //               

	// @2800 'f' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ######  
	0xff, 0xff, 0xff, 0xff, 0xff, //      #######  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //      ##       
	0xff, 0xf0, 0xff, 0xc3, 0xff, //      ##       
	0xff, 0xf0, 0x00, 0x00, 0x0f, //    ########   
	0xff, 0xf0, 0x00, 0x00, 0x03, //    ########   
	0xff, 0xf0, 0xff, 0xc3, 0xc3, //      ##       
	0xff, 0xf0, 0xff, 0xc3, 0xc3, //      ##       
	0xff, 0xf0, 0xff, 0xc3, 0xc3, //      ##       
	0xff, 0xf0, 0xff, 0xc3, 0xc3, //      ##       
	0xff, 0xff, 0xff, 0xff, 0xc3, //      ##       
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2840 'g' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xc0, 0xff, 0xff, //               
	0xff, 0xfc, 0x00, 0x0f, 0xff, //               
	0xf0, 0xfc, 0x3f, 0x0f, 0xff, //               
	0xf0, 0xf0, 0xff, 0xc3, 0xff, //      #### ### 
	0xf0, 0xf0, 0xff, 0xc3, 0xff, //    ########## 
	0xf0, 0xf0, 0xff, 0xc3, 0xff, //    ##    ###  
	0xf0, 0xf0, 0xff, 0xc3, 0xff, //   ##      ##  
	0xf0, 0x3c, 0x3f, 0x0f, 0xff, //   ##      ##  
	0xfc, 0x00, 0x00, 0x03, 0xff, //   ##      ##  
	0xff, 0x00, 0x00, 0x03, 0xff, //    ##    ###  
	0xff, 0xff, 0xff, 0xc3, 0xff, //    #########  
	0xff, 0xff, 0xff, 0xff, 0xff, //      #### ##  
                                      //           ##  
	                              //          ###  
	                              //     #######   
	                              //     ######    
                                      //               
                                      //               

	// @2880 'h' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //   ###         
	0xff, 0xf0, 0xff, 0xff, 0xc3, //   ###         
	0xff, 0xf0, 0x00, 0x00, 0x03, //    ##         
	0xff, 0xf0, 0x00, 0x00, 0x03, //    ##         
	0xff, 0xf0, 0xff, 0x0f, 0xff, //    ## ####    
	0xff, 0xff, 0xff, 0xc3, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xc3, 0xff, //    ###   ##   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ##    ##   
	0xff, 0xf0, 0x00, 0x03, 0xff, //    ##    ##   
	0xff, 0xf0, 0x00, 0x0f, 0xff, //    ##    ##   
	0xff, 0xf0, 0xff, 0xff, 0xff, //    ##    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ####  ####  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ####  ####  
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2920 'i' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xf0, 0xff, 0xc3, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    #####      
	0xff, 0xf0, 0x00, 0x03, 0xc3, //    #####      
	0xff, 0xf0, 0x00, 0x03, 0xc3, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @2960 'j' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xf0, 0xff, 0xff, 0xff, 0xff, //               
	0xf0, 0xff, 0xff, 0xc3, 0xff, //               
	0xf0, 0xff, 0xff, 0xc3, 0xff, //    #######    
	0xf0, 0xff, 0xff, 0xc3, 0xff, //    #######    
	0xf0, 0xff, 0xff, 0xc3, 0xc3, //         ##    
	0xf0, 0xff, 0xff, 0xc3, 0xc3, //         ##    
	0xfc, 0x00, 0x00, 0x03, 0xff, //         ##    
	0xff, 0x00, 0x00, 0x03, 0xff, //         ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //         ##    
	                              //         ##    
                                      //        ###    
                                      //   #######     
                                      //   ######      
                                      //               
                                      //               

	// @3000 'k' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //   ###         
	0xff, 0xf0, 0xff, 0xff, 0xc3, //   ###         
	0xff, 0xf0, 0x00, 0x00, 0x03, //    ##         
	0xff, 0xf0, 0x00, 0x00, 0x03, //    ##         
	0xff, 0xff, 0xf0, 0xff, 0xff, //    ## #####   
	0xff, 0xff, 0xc0, 0x03, 0xff, //    ## #####   
	0xff, 0xf0, 0x0f, 0x03, 0xff, //    ## ##      
	0xff, 0xf0, 0x3f, 0xc3, 0xff, //    ####       
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ####       
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ## ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //    ##  ##     
	0xff, 0xff, 0xff, 0xff, 0xff, //   ###  #####  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ###  #####  
                                      //               
                                      //               
                                      //               
	                              //               
	                              //               
                                      //               

	// @3040 'l' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //    #####      
	0xff, 0xff, 0xff, 0xff, 0xff, //    #####      
	0xff, 0xf0, 0xff, 0xff, 0xc3, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xc3, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xc3, //       ##      
	0xff, 0xf0, 0x00, 0x00, 0x03, //       ##      
	0xff, 0xf0, 0x00, 0x00, 0x03, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xf0, 0xff, 0xff, 0xff, //       ##      
        0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @3080 'm' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //               
	0xff, 0xf0, 0x00, 0x03, 0xff, //               
	0xff, 0xf0, 0x00, 0x03, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //               
	0xff, 0xff, 0xff, 0xc3, 0xff, //  ###### ###   
	0xff, 0xf0, 0x00, 0x03, 0xff, //  ###########  
	0xff, 0xf0, 0x00, 0x0f, 0xff, //   ##  ##  ##  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   ##  ##  ##  
	0xff, 0xff, 0xff, 0xc3, 0xff, //   ##  ##  ##  
	0xff, 0xf0, 0x00, 0x03, 0xff, //   ##  ##  ##  
	0xff, 0xf0, 0x00, 0x0f, 0xff, //   ##  ##  ##  
	0xff, 0xf0, 0xff, 0xff, 0xff, //  #### ### ### 
	0xff, 0xff, 0xff, 0xff, 0xff, //  #### ### ### 
	                              //               
	                              //               
                                      //               
                                      //               
	                              //               
                                      //               

	// @3120 'n' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //               
	0xff, 0xf0, 0x00, 0x03, 0xff, //               
	0xff, 0xf0, 0x00, 0x03, 0xff, //               
	0xff, 0xf0, 0xff, 0x0f, 0xff, //   ### ####    
	0xff, 0xff, 0xff, 0xc3, 0xff, //   #########   
	0xff, 0xff, 0xff, 0xc3, 0xff, //    ###   ##   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ##    ##   
	0xff, 0xf0, 0x00, 0x03, 0xff, //    ##    ##   
	0xff, 0xf0, 0x00, 0x0f, 0xff, //    ##    ##   
	0xff, 0xf0, 0xff, 0xff, 0xff, //    ##    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ####  ####  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ####  ####  
	                              //               
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               

	// @3160 'o' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xc0, 0xff, 0xff, //               
	0xff, 0xfc, 0x00, 0x0f, 0xff, //               
	0xff, 0xfc, 0x3f, 0x0f, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //      ####     
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ########   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ##    ##   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   ##      ##  
	0xff, 0xfc, 0x3f, 0x0f, 0xff, //   ##      ##  
	0xff, 0xfc, 0x00, 0x0f, 0xff, //   ##      ##  
	0xff, 0xff, 0xc0, 0xff, 0xff, //    ##    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xff, 0xff, //      ####     
	                              //               
	                              //               
                                      //               
	                              //               
	                              //               
	                              //               

	// @3200 'p' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xf0, 0xff, 0xff, 0xc3, 0xff, //               
	0xf0, 0x00, 0x00, 0x03, 0xff, //               
	0xf0, 0x00, 0x00, 0x03, 0xff, //               
	0xf0, 0xfc, 0x3f, 0x0f, 0xff, //               
	0xf0, 0xf0, 0xff, 0xc3, 0xff, //  ### ####     
	0xff, 0xf0, 0xff, 0xc3, 0xff, //  ##########   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   ###    ##   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   ##      ##  
	0xff, 0xfc, 0x3f, 0x0f, 0xff, //   ##      ##  
	0xff, 0xfc, 0x00, 0x0f, 0xff, //   ##      ##  
	0xff, 0xff, 0xc0, 0xff, 0xff, //   ###    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //   #########   
	0xff, 0xff, 0xff, 0xff, 0xff, //   ## ####     
                                      //   ##          
                                      //   ##          
                                      //  #####        
                                      //  #####        
                                      //               
                                      //               

	// @3240 'q' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xc0, 0xff, 0xff, //               
	0xff, 0xfc, 0x00, 0x0f, 0xff, //               
	0xff, 0xfc, 0x3f, 0x0f, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //      #### ### 
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ########## 
	0xff, 0xf0, 0xff, 0xc3, 0xff, //    ##    ###  
	0xf0, 0xf0, 0xff, 0xc3, 0xff, //   ##      ##  
	0xf0, 0xfc, 0x3f, 0x0f, 0xff, //   ##      ##  
	0xf0, 0x00, 0x00, 0x03, 0xff, //   ##      ##  
	0xf0, 0x00, 0x00, 0x03, 0xff, //    ##    ###  
	0xf0, 0xff, 0xff, 0xc3, 0xff, //    #########  
	0xff, 0xff, 0xff, 0xff, 0xff, //      #### ##  
	                              //           ##  
                                      //           ##  
                                      //         ##### 
	                              //         ##### 
	                              //               
	                              //               

	// @3280 'r' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //               
	0xff, 0xf0, 0x00, 0x03, 0xff, //               
	0xff, 0xf0, 0x00, 0x03, 0xff, //   ####  ###   
	0xff, 0xf0, 0xfc, 0x3f, 0xff, //   #### #####  
	0xff, 0xf0, 0xff, 0x0f, 0xff, //     ####  ##  
	0xff, 0xf0, 0xff, 0xc3, 0xff, //     ###       
        0xff, 0xf0, 0xff, 0xc3, 0xff, //     ##        
	0xff, 0xff, 0xff, 0x03, 0xff, //     ##        
	0xff, 0xff, 0xff, 0x0f, 0xff, //     ##        
	0xff, 0xff, 0xff, 0xff, 0xff, //   ########    
	0xff, 0xff, 0xff, 0xff, 0xff, //   ########    
	                              //               
	                              //               
                                      //               
                                      //               
	                              //               
	                              //               

	// @3320 's' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0x3c, 0x0f, 0xff, //               
	0xff, 0xf0, 0x30, 0x0f, 0xff, //               
	0xff, 0xf0, 0xf0, 0xc3, 0xff, //      ######   
	0xff, 0xf0, 0xf0, 0xc3, 0xff, //    ########   
	0xff, 0xf0, 0xc3, 0xc3, 0xff, //    ##    ##   
	0xff, 0xf0, 0xc3, 0xc3, 0xff, //    ####       
	0xff, 0xfc, 0x03, 0x03, 0xff, //     ######    
	0xff, 0xfc, 0x0f, 0x03, 0xff, //        ####   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ##    ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ######     
	                              //               
                                      //               
                                      //               
	                              //               
	                              //               
                                      //               
    
	// @3360 't' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xc3, 0xff, //     ##        
	0xff, 0xff, 0xff, 0xc3, 0xff, //     ##        
	0xff, 0xfc, 0x00, 0x00, 0x0f, //     ##        
	0xff, 0xf0, 0x00, 0x00, 0x0f, //   #########   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //   #########   
	0xff, 0xf0, 0xff, 0xc3, 0xff, //     ##        
	0xff, 0xf0, 0xff, 0xc3, 0xff, //     ##        
	0xff, 0xf0, 0xff, 0xc3, 0xff, //     ##        
	0xff, 0xfc, 0x3f, 0xc3, 0xff, //     ##        
	0xff, 0xfc, 0x3f, 0xff, 0xff, //     ##    ##  
	0xff, 0xff, 0xff, 0xff, 0xff, //     ########  
	0xff, 0xff, 0xff, 0xff, 0xff, //      #####    
	                              //               
                                      //               
	                              //               
	                              //               
                                      //               
	                              //               

	// @3400 'u' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xc3, 0xff, //               
	0xff, 0xfc, 0x00, 0x03, 0xff, //               
	0xff, 0xf0, 0x00, 0x03, 0xff, //               
	0xff, 0xf0, 0xff, 0xff, 0xff, //   ###   ###   
	0xff, 0xf0, 0xff, 0xff, 0xff, //   ###   ###   
	0xff, 0xf0, 0xff, 0xff, 0xff, //    ##    ##   
	0xff, 0xfc, 0x3f, 0xc3, 0xff, //    ##    ##   
	0xff, 0xf0, 0x00, 0x03, 0xff, //    ##    ##   
	0xff, 0xf0, 0x00, 0x03, 0xff, //    ##    ##   
	0xff, 0xf0, 0xff, 0xff, 0xff, //    ##   ###   
	0xff, 0xff, 0xff, 0xff, 0xff, //    #########  
	0xff, 0xff, 0xff, 0xff, 0xff, //     #### ###  
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
	                              //               

	// @3440 'v' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xc3, 0xff, //               
	0xff, 0xff, 0xff, 0x03, 0xff, //               
	0xff, 0xff, 0xf0, 0x03, 0xff, //               
	0xff, 0xff, 0x00, 0xc3, 0xff, //               
	0xff, 0xf0, 0x0f, 0xff, 0xff, //  ####   ####  
	0xff, 0xf0, 0xff, 0xff, 0xff, //  ####   ####  
	0xff, 0xf0, 0x0f, 0xff, 0xff, //   ##     ##   
	0xff, 0xff, 0x00, 0xc3, 0xff, //    ##   ##    
	0xff, 0xff, 0xf0, 0x03, 0xff, //    ##   ##    
	0xff, 0xff, 0xff, 0x03, 0xff, //     ## ##     
	0xff, 0xff, 0xff, 0xc3, 0xff, //     ## ##     
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	                              //               
	                              //               
	                              //               
	                              //               
	                              //               
                                      //               

	// @3480 'w' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xc3, 0xff, //               
	0xff, 0xff, 0xf0, 0x03, 0xff, //               
	0xff, 0xf0, 0x00, 0x03, 0xff, //               
	0xff, 0xf0, 0x0f, 0xc3, 0xff, //               
	0xff, 0xff, 0x03, 0xff, 0xff, //  ####   ####  
	0xff, 0xff, 0xf0, 0x3f, 0xff, //  ####   ####  
	0xff, 0xff, 0x03, 0xff, 0xff, //   ##  #  ##   
	0xff, 0xf0, 0x0f, 0xc3, 0xff, //   ##  #  ##   
	0xff, 0xf0, 0x00, 0x03, 0xff, //   ## ######   
	0xff, 0xff, 0xf0, 0x03, 0xff, //    ### ###    
	0xff, 0xff, 0xff, 0xc3, 0xff, //    ### ###    
	0xff, 0xff, 0xff, 0xff, 0xff, //    ##   ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //    ##   ##    
	                              //               
	                              //               
                                      //               
	                              //               
	                              //               
	                              //               

	// @3520 'x' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //               
	0xff, 0xf0, 0xff, 0xc3, 0xff, //               
	0xff, 0xf0, 0x3f, 0x03, 0xff, //               
	0xff, 0xf0, 0x0c, 0x03, 0xff, //   ####  ####  
	0xff, 0xff, 0xc0, 0xff, 0xff, //   ####  ####  
	0xff, 0xff, 0xc0, 0xff, 0xff, //     ##  ##    
	0xff, 0xf0, 0x0c, 0x03, 0xff, //      ####     
	0xff, 0xf0, 0x3f, 0x03, 0xff, //       ##      
	0xff, 0xf0, 0xff, 0xc3, 0xff, //      ####     
	0xff, 0xf0, 0xff, 0xc3, 0xff, //     ##  ##    
	0xff, 0xff, 0xff, 0xff, 0xff, //   ####  ####  
	0xff, 0xff, 0xff, 0xff, 0xff, //   ####  ####  
	                              //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               

	// @3560 'y' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xf0, 0xff, 0xff, 0xc3, 0xff, //               
	0xf0, 0xff, 0xff, 0x03, 0xff, //               
	0xf0, 0xff, 0xf0, 0x03, 0xff, //               
	0xf0, 0x3f, 0x00, 0xc3, 0xff, //               
	0xf0, 0x00, 0x0f, 0xff, 0xff, //  ####   ####  
	0xf0, 0xc0, 0x3f, 0xff, 0xff, //  ####   ####  
	0xf0, 0xfc, 0x0f, 0xff, 0xff, //   ##     ##   
	0xff, 0xff, 0x00, 0xc3, 0xff, //    ##   ##    
	0xff, 0xff, 0xf0, 0x03, 0xff, //    ##   ##    
	0xff, 0xff, 0xff, 0x03, 0xff, //     ## ##     
	0xff, 0xff, 0xff, 0xc3, 0xff, //     #####     
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ##       
	                              //      ##       
	                              //     ##        
	                              //  #######      
	                              //  #######      
	                              //               
                                      //               

	// @3600 'z' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xf0, 0xff, 0x03, 0xff, //               
	0xff, 0xf0, 0x3f, 0x03, 0xff, //               
	0xff, 0xf0, 0x0f, 0xc3, 0xff, //    ########   
	0xff, 0xf0, 0xc3, 0xc3, 0xff, //    ########   
	0xff, 0xf0, 0xf0, 0xc3, 0xff, //    ##   ##    
	0xff, 0xf0, 0xfc, 0x03, 0xff, //        ##     
	0xff, 0xf0, 0x3f, 0x03, 0xff, //       ##      
	0xff, 0xf0, 0x3f, 0xc3, 0xff, //      ##       
	0xff, 0xff, 0xff, 0xff, 0xff, //     ##   ##   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	0xff, 0xff, 0xff, 0xff, 0xff, //    ########   
	                              //               
                                      //               
                                      //               
                                      //               
	                              //               
                                      //               

	// @3640 '{' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //        ###    
	0xff, 0xff, 0xff, 0xff, 0xff, //       ####    
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xf3, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xc0, 0xff, 0xff, //       ##      
	0xff, 0x00, 0x00, 0x00, 0x0f, //       ##      
	0xfc, 0x00, 0x0c, 0x00, 0x03, //       ##      
	0xfc, 0x3f, 0xff, 0xff, 0xc3, //      ###      
	0xfc, 0x3f, 0xff, 0xff, 0xc3, //     ###       
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	                              //       ##      
                                      //       ####    
                                      //        ###    
                                      //               
	                              //               
	                              //               

	// @3680 '|' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xfc, 0x00, 0x00, 0x00, 0x03, //       ##      
	0xfc, 0x00, 0x00, 0x00, 0x03, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ##      
	                              //       ##      
                                      //       ##      
                                      //       ##      
                                      //               
                                      //               
                                      //               

	// @3720 '}' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //    ###        
	0xff, 0xff, 0xff, 0xff, 0xff, //    ####       
	0xfc, 0x3f, 0xff, 0xff, 0xc3, //      ##       
	0xfc, 0x3f, 0xff, 0xff, 0xc3, //      ##       
	0xfc, 0x00, 0x0c, 0x00, 0x03, //      ##       
	0xff, 0x00, 0x00, 0x00, 0x0f, //      ##       
	0xff, 0xff, 0xc0, 0xff, 0xff, //      ##       
	0xff, 0xff, 0xf3, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //       ###     
	0xff, 0xff, 0xff, 0xff, 0xff, //      ###      
	0xff, 0xff, 0xff, 0xff, 0xff, //      ##       
	0xff, 0xff, 0xff, 0xff, 0xff, //      ##       
	0xff, 0xff, 0xff, 0xff, 0xff, //      ##       
                                      //      ##       
	                              //    ####       
                                      //    ###        
	                              //               
	                              //               
	                              //               

	// @3760 '~' (14 lines)
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xff, 0x0f, 0xff, //               
	0xff, 0xff, 0xff, 0x0f, 0xff, //               
	0xff, 0xff, 0xfc, 0x0f, 0xff, //     ###       
	0xff, 0xff, 0xf0, 0x3f, 0xff, //   ######  ##  
	0xff, 0xff, 0xf0, 0xff, 0xff, //   ##  ######  
	0xff, 0xff, 0xf0, 0xff, 0xff, //        ####   
	0xff, 0xff, 0xf0, 0x3f, 0xff, //               
	0xff, 0xff, 0xfc, 0x3f, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	0xff, 0xff, 0xff, 0xff, 0xff, //               
	                              //               
                                      //               
                                      //               
                                      //               
                                      //               
	                              //               
};


sFONT Font20 = {
  Font20_Table,
  14, /* Width */    // (14 lines)
  5, /* Height */     // (5 bytes/20pixels)
};

/**
  * @}
  */ 


/** @defgroup FONTS_Private_Function_Prototypes
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Functions
  * @{
  */
    
/**
  * @}
  */
  
/**
  * @}
  */ 

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
