/**
  ******************************************************************************
  * @file    font16epd.c
  * @author  MCD Application Team
  * @version V1.2.0
  * @date    06-February-2015
  * @brief   This file provides text font16 for STM32L0538-DISCO's EPD driver. 
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "fontsepd.h"

/** @addtogroup BSP
  * @{
  */

/** @addtogroup STM32L0538_DISCOVERY
  * @{
  */

/** @addtogroup FONTS
  * @brief      This file provides text Font16 for STM32L0538-Discovery's EPD driver.
  * @{
  */  

/** @defgroup FONTS_Private_Types
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Defines
  * @{
  */
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Macros
  * @{
  */
/**
  * @}
  */ 
  

/** @defgroup FONTS_Private_Variables
  * @{
  */
// 
//  Font data for Courier New 12pt
// 

const uint8_t Font16_Table[] = 
{
	// @0 ' ' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @44 '!' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xcc, 0x00, 0x03, //     ##     
	0xff, 0xcc, 0x00, 0x03, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ##     
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @88 '"' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //    ### ### 
	0xff, 0xff, 0xff, 0x0f, //    ### ### 
	0xff, 0xff, 0xc0, 0x0f, //     #   #  
	0xff, 0xff, 0xff, 0x0f, //     #   #  
	0xff, 0xff, 0xff, 0xff, //     #   #  
	0xff, 0xff, 0xff, 0x0f, //            
	0xff, 0xff, 0xc0, 0x0f, //            
	0xff, 0xff, 0xff, 0x0f, //            
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @132 '#' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ## ##  
	0xff, 0xff, 0x33, 0xff, //     ## ##  
	0xff, 0x00, 0x03, 0xff, //     ## ##  
	0xff, 0x00, 0x00, 0x03, //     ## ##  
	0xff, 0xff, 0x30, 0x03, //   ######## 
	0xff, 0x00, 0x03, 0xff, //    ## ##   
	0xff, 0x00, 0x00, 0x03, //   ######## 
	0xff, 0xff, 0x30, 0x03, //    ## ##   
	0xff, 0xff, 0x33, 0xff, //    ## ##   
	0xff, 0xff, 0xff, 0xff, //    ## ##   
	                        //    ## ##   
	                        //            
	                        //            
	                        //            
	                        //            

	// @176 '$' (11 lines)
	0xff, 0xff, 0xff, 0xff, //      #     
	0xff, 0xff, 0xff, 0xff, //    ######  
	0xff, 0xc0, 0xfc, 0x0f, //   ##   ##  
	0xff, 0xc0, 0xf0, 0x03, //   ##   ##  
	0xff, 0xcf, 0xc0, 0xf3, //   ###      
	0xfc, 0x0f, 0xc3, 0xf0, //    ####    
	0xff, 0xcf, 0x03, 0xf3, //     ####   
	0xff, 0xc0, 0x0f, 0x03, //       ###  
	0xff, 0xf0, 0x3f, 0x03, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //   ######   
	                        //      #     
                          //      #     
	                        //            
	                        //            
	                        //            

	// @220 '%' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //    ##      
	0xff, 0xff, 0x3f, 0x0f, //   #  #     
	0xff, 0xff, 0x0c, 0xf3, //   #  #     
	0xff, 0xff, 0xcc, 0xf3, //    ##   ## 
	0xff, 0xff, 0xc3, 0x0f, //      ####  
	0xff, 0xf0, 0xc3, 0xff, //    ####    
	0xff, 0xcf, 0x33, 0xff, //   ##   ##  
	0xff, 0xcf, 0x30, 0xff, //       #  # 
	0xff, 0xf0, 0xfc, 0xff, //       #  # 
	0xff, 0xff, 0xff, 0xff, //        ##  
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @264 '&' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xf0, 0xff, 0xff, //     ####   
	0xff, 0xc0, 0x30, 0x3f, //    ##      
	0xff, 0xcf, 0x00, 0x0f, //    ##      
	0xff, 0xcc, 0x0f, 0xcf, //    ##      
	0xff, 0xf0, 0xff, 0xcf, //     ##     
	0xff, 0xc0, 0x3f, 0xcf, //    ### ##  
	0xff, 0xcf, 0x3f, 0xcf, //   ## ###   
	0xff, 0xff, 0xff, 0xff, //   ##  ##   
	0xff, 0xff, 0xff, 0xff, //    ### ##  
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @308 ''' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ###   
	0xff, 0xff, 0xff, 0xff, //      ###   
	0xff, 0xff, 0xff, 0xff, //       #    
	0xff, 0xff, 0xff, 0x0f, //       #    
	0xff, 0xff, 0xc0, 0x0f, //       #    
	0xff, 0xff, 0xff, 0x0f, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @352 '(' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //       ##   
	0xff, 0xff, 0xff, 0xff, //       ##   
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xf0, 0x00, 0xff, //     ###    
	0xff, 0xc0, 0x00, 0x3f, //     ##     
	0xfc, 0x03, 0xfc, 0x03, //     ##     
	0xfc, 0x3f, 0xff, 0xc3, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ###    
	0xff, 0xff, 0xff, 0xff, //      ##    
	                        //       ##   
	                        //       ##   
	                        //            
	                        //            
	                        //            

	// @396 ')' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //    ##      
	0xff, 0xff, 0xff, 0xff, //    ##      
	0xfc, 0x3f, 0xff, 0xc3, //     ##     
	0xfc, 0x03, 0xfc, 0x03, //     ###    
	0xff, 0xc0, 0x00, 0x3f, //      ##    
	0xff, 0xf0, 0x00, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //     ###    
	0xff, 0xff, 0xff, 0xff, //     ##     
	                        //    ##     
	                        //    ##      
	                        //            
	                        //            
                          //            

	// @440 '*' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xfc, 0x3f, //      ##    
	0xff, 0xff, 0x0c, 0x3f, //   ######## 
	0xff, 0xff, 0x00, 0x3f, //   ######## 
	0xff, 0xff, 0xf0, 0x03, //     ####   
	0xff, 0xff, 0xf0, 0x03, //    ######  
	0xff, 0xff, 0x00, 0x3f, //    ##  ##  
	0xff, 0xff, 0x0c, 0x3f, //            
	0xff, 0xff, 0xfc, 0x3f, //            
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
                          //            
                          //            
                          //            

	// @484 '+' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //      #     
	0xff, 0xff, 0xcf, 0xff, //      #     
	0xff, 0xf0, 0x00, 0x3f, //      #     
	0xff, 0xff, 0xcf, 0xff, //   #######  
	0xff, 0xff, 0xcf, 0xff, //      #     
	0xff, 0xff, 0xcf, 0xff, //      #     
	0xff, 0xff, 0xff, 0xff, //      #     
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @528 ',' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xf0, 0x3f, 0xff, 0xff, //            
	0xff, 0x03, 0xff, 0xff, //            
	0xff, 0xf3, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      #     
                          //     ##     
	                        //     #      
                          //     #      
	                        //            
	                        //            

	// @572 '-' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //   #######  
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @616 '.' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xc3, 0xff, 0xff, //            
	0xff, 0xc3, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @660 '/' (11 lines)
	0xff, 0xff, 0xff, 0xff, //         ## 
	0xff, 0xff, 0xff, 0xff, //         ## 
	0xfc, 0x3f, 0xff, 0xff, //        ##  
	0xfc, 0x03, 0xff, 0xff, //        ##  
	0xff, 0xc0, 0x3f, 0xff, //       ##   
	0xff, 0xfc, 0x0f, 0xff, //       ##   
	0xff, 0xff, 0xc0, 0xff, //      ##    
	0xff, 0xff, 0xf0, 0x0f, //     ##     
	0xff, 0xff, 0xff, 0x00, //     ##     
	0xff, 0xff, 0xff, 0xf0, //    ##      
	0xff, 0xff, 0xff, 0xff, //    ##      
	                        //   ##       
	                        //   ##       
	                        //            
	                        //            
	                        //            

	// @704 '0' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ###    
	0xff, 0xfc, 0x00, 0x3f, //    ## ##   
	0xff, 0xf0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xc3, 0xff, 0xc3, //   ##   ##  
	0xff, 0xcf, 0xff, 0xf3, //   ##   ##  
	0xff, 0xc3, 0xff, 0xc3, //   ##   ##  
	0xff, 0xf0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xfc, 0x00, 0x3f, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //    ## ##   
	0xff, 0xff, 0xff, 0xff, //     ###    
                          //            
                          //            
	                        //            
	                        //            
	                        //            

	// @748 '1' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xcf, 0xff, 0xcf, //   #####    
	0xff, 0xcf, 0xff, 0xcf, //      ##    
	0xff, 0xcf, 0xff, 0xcf, //      ##    
	0xff, 0xc0, 0x00, 0x03, //      ##    
	0xff, 0xc0, 0x00, 0x03, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //   ######## 
	                        //            
	                        //            
	                        //            
	                        //            
                          //            

	// @792 '2' (11 lines)
  0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ####   
	0xff, 0xc3, 0xfc, 0x3f, //    ##  ##  
	0xff, 0xc0, 0xfc, 0x0f, //   ##   ##  
	0xff, 0xcc, 0x3f, 0xc3, //   ##   ##  
	0xff, 0xcf, 0x0f, 0xf3, //       ##   
	0xff, 0xcf, 0xc3, 0xf3, //      ##    
	0xff, 0xcf, 0xf0, 0x03, //     ##     
	0xff, 0xcf, 0xfc, 0x0f, //    ##      
	0xff, 0xff, 0xff, 0xff, //   ##       
	0xff, 0xff, 0xff, 0xff, //   #######  
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @836 '3' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xf3, 0xff, 0xcf, //   ######   
	0xff, 0xc3, 0xff, 0xc3, //  ##    ##  
	0xff, 0xcf, 0xf3, 0xf3, //        ##  
	0xff, 0xcf, 0xf3, 0xf3, //       ##   
	0xff, 0xcf, 0xf3, 0xf3, //    #####   
	0xff, 0xcf, 0xc0, 0xf3, //       ###  
	0xff, 0xc0, 0x00, 0x03, //        ##  
	0xff, 0xf0, 0x0f, 0x0f, //        ##  
	0xff, 0xff, 0xff, 0xff, //  ##    ##  
	0xff, 0xff, 0xff, 0xff, //   ######   
	                        //            
                          //            
	                        //            
	                        //            
	                        //            

	// @880 '4' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ###   
	0xff, 0xfc, 0x3f, 0xff, //      ###   
	0xff, 0xfc, 0x03, 0xff, //     ####   
	0xff, 0xcc, 0xf0, 0x3f, //     # ##   
	0xff, 0xcc, 0xff, 0x03, //    ## ##   
	0xff, 0xc0, 0x00, 0x03, //    #  ##   
	0xff, 0xc0, 0x00, 0x03, //   ##  ##   
	0xff, 0xcc, 0xff, 0xff, //   #######  
	0xff, 0xff, 0xff, 0xff, //       ##   
	0xff, 0xff, 0xff, 0xff, //     #####  
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @924 '5' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //    ######  
	0xff, 0xf3, 0xff, 0xff, //    ##      
	0xff, 0xcf, 0xc0, 0x03, //    ##      
	0xff, 0xcf, 0xf0, 0x03, //    ##      
	0xff, 0xcf, 0xf3, 0xf3, //    #####   
	0xff, 0xcf, 0xf3, 0xf3, //    #   ##  
	0xff, 0xc0, 0x03, 0xf3, //        ##  
	0xff, 0xf0, 0x0f, 0xf3, //        ##  
	0xff, 0xff, 0xff, 0xff, //   #    ##  
	0xff, 0xff, 0xff, 0xff, //    #####   
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @968 '6' (11 lines)
  0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ####  
	0xff, 0xfc, 0x00, 0xff, //    ###     
	0xff, 0xf0, 0x00, 0x3f, //    ##      
	0xff, 0xc3, 0xcf, 0x0f, //   ##       
	0xff, 0xcf, 0xf3, 0xc3, //   ## ###   
	0xff, 0xcf, 0xf3, 0xf3, //   ###  ##  
	0xff, 0xc0, 0x03, 0xf3, //   ##   ##  
	0xff, 0xf0, 0x0f, 0xf3, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //    ##  ##  
	0xff, 0xff, 0xff, 0xff, //     ####   
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1012 '7' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //   #######   
	0xff, 0xff, 0xff, 0xc3, //   #    ##   
	0xff, 0xff, 0xff, 0xf3, //        ##   
	0xff, 0xff, 0xff, 0xf3, //       ##    
	0xff, 0xc0, 0xff, 0xf3, //       ##    
	0xff, 0xc0, 0x00, 0xf3, //       ##    
  0xff, 0xff, 0x00, 0x03, //       ##    
	0xff, 0xff, 0xff, 0x03, //      ##     
	0xff, 0xff, 0xff, 0xff, //      ##     
	0xff, 0xff, 0xff, 0xff, //      ##     
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1056 '8' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //    #####   
	0xff, 0xf0, 0x0c, 0x0f, //   ##   ##  
	0xff, 0xc0, 0x00, 0x03, //   ##   ##  
	0xff, 0xcf, 0xf3, 0xf3, //   ##   ##  
	0xff, 0xcf, 0xf3, 0xf3, //    #####   
	0xff, 0xcf, 0xf3, 0xf3, //   ##   ##  
	0xff, 0xc0, 0x00, 0x03, //   ##   ##  
	0xff, 0xf0, 0x0c, 0x0f, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //    #####   
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1100 '9' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //    ####    
	0xff, 0xcf, 0xf0, 0x0f, //   ##  ##   
	0xff, 0xcf, 0xc0, 0x03, //   ##   ##  
	0xff, 0xcf, 0xcf, 0xf3, //   ##   ##  
	0xff, 0xc3, 0xcf, 0xf3, //   ##  ###  
	0xff, 0xf0, 0xf3, 0xc3, //    ### ##  
	0xff, 0xf0, 0x00, 0x0f, //        ##  
	0xff, 0xff, 0x00, 0x3f, //       ##   
	0xff, 0xff, 0xff, 0xff, //      ###   
	0xff, 0xff, 0xff, 0xff, //   ####     
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1144 ':' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xc3, 0xf0, 0xff, //     ##     
	0xff, 0xc3, 0xf0, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	                        //            
	                        //            
                          //            
                          //            
                          //            

	// @1188 ';' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xfc, 0x3f, 0xff, 0xff, //       ##   
	0xff, 0xc3, 0xff, 0xff, //       ##   
	0xff, 0xf3, 0xf0, 0xff, //            
	0xff, 0xff, 0xf0, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	                        //     #      
                          //     #      
                          //            
	                        //            
	                        //            

	// @1232 '<' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //         ## 
	0xff, 0xff, 0x33, 0xff, //       ##   
	0xff, 0xff, 0x33, 0xff, //      #     
	0xff, 0xfc, 0xfc, 0xff, //    ##      
	0xff, 0xf3, 0xff, 0x3f, //  ##        
	0xff, 0xf3, 0xff, 0x3f, //    ##      
	0xff, 0xcf, 0xff, 0xcf, //      #     
	0xff, 0xcf, 0xff, 0xcf, //       ##   
	0xff, 0xff, 0xff, 0xff, //         ## 
	                        //            
                          //            
	                        //            
	                        //            
                          //            

	// @1276 '=' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0x33, 0xff, //            
	0xff, 0xff, 0x33, 0xff, //            
	0xff, 0xff, 0x33, 0xff, //            
	0xff, 0xff, 0x33, 0xff, //   ####### 
	0xff, 0xff, 0x33, 0xff, //            
	0xff, 0xff, 0x33, 0xff, //   ####### 
	0xff, 0xff, 0x33, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1320 '>' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xcf, 0xff, 0xcf, //  ##        
	0xff, 0xf3, 0xff, 0x3f, //    ##      
	0xff, 0xf3, 0xff, 0x3f, //      #     
	0xff, 0xfc, 0xfc, 0xff, //       ##   
	0xff, 0xff, 0x33, 0xff, //         ## 
	0xff, 0xff, 0x33, 0xff, //       ##   
	0xff, 0xff, 0xcf, 0xff, //      #     
	0xff, 0xff, 0xcf, 0xff, //    ##      
	0xff, 0xff, 0xff, 0xff, //  ##        
	                        //            
                          //            
                          //            
                          //            
                          //            

	// @1364 '?' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xfc, 0x3f, //    #####   
	0xff, 0xff, 0xfc, 0x0f, //   ##   ##  
	0xff, 0xcc, 0x3f, 0xcf, //   ##   ##  
	0xff, 0xcc, 0x0f, 0xcf, //        ##  
	0xff, 0xff, 0xcf, 0xcf, //      ###   
	0xff, 0xff, 0xc0, 0x0f, //     ##     
	0xff, 0xff, 0xf0, 0x3f, //     ##     
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ##     
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1408 '@' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ###    
	0xff, 0xf0, 0x00, 0x3f, //    #   #   
	0xff, 0xcf, 0xff, 0xcf, //   #    #   
	0xff, 0x3f, 0x0f, 0xf3, //   #    #   
	0xff, 0x3c, 0xf3, 0xf3, //   #  ###   
	0xff, 0x3c, 0xf3, 0xf3, //   # #  #   
	0xff, 0xcc, 0x00, 0x0f, //   # #  #   
	0xff, 0xff, 0xff, 0xff, //   #  ###   
	0xff, 0xff, 0xff, 0xff, //   #        
	0xff, 0xff, 0xff, 0xff, //    #   #   
	                        //     ###    
	                        //            
	                        //            
	                        //            
	                        //            

	// @1452 'A' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xff, //            
	0xff, 0xc0, 0xff, 0xcf, //   ######   
	0xff, 0xc0, 0x03, 0xcf, //     ####   
	0xff, 0xcf, 0x00, 0x0f, //     #  #   
	0xff, 0xff, 0x3f, 0x0f, //    ##  ##  
	0xff, 0xff, 0x3f, 0x0f, //    ##  ##  
	0xff, 0xcf, 0x00, 0x0f, //    ######  
	0xff, 0xc0, 0x03, 0xff, //   ##    ## 
	0xff, 0xc0, 0xff, 0xff, //   ##    ## 
	0xff, 0xcf, 0xff, 0xff, //  ####  ####
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1496 'B' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
  0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc0, 0x00, 0x0f, //  #######   
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xcf, 0xcf, //   ##   ##  
	0xff, 0xcf, 0xcf, 0xcf, //   ##   ##  
	0xff, 0xcf, 0xcf, 0xcf, //   ######   
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xf0, 0x30, 0x3f, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //  #######   
                          //            
                          //            
	                        //            
	                        //            
	                        //            

	// @1540 'C' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x00, 0xff, //            
	0xff, 0xf0, 0x00, 0x3f, //    ##### # 
	0xff, 0xc3, 0xff, 0x0f, //   ##    ## 
	0xff, 0xcf, 0xff, 0xcf, //  ##      # 
	0xff, 0xcf, 0xff, 0xcf, //  ##        
	0xff, 0xcf, 0xff, 0xcf, //  ##        
	0xff, 0xcf, 0xff, 0xcf, //  ##        
	0xff, 0xf3, 0xff, 0x3f, //  ##      # 
	0xff, 0xfc, 0xfc, 0x0f, //   ##    #  
	0xff, 0xff, 0xff, 0xff, //    #####   
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1584 'D' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc0, 0x00, 0x0f, //  #######   
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xff, 0xcf, //   ##    ## 
	0xff, 0xcf, 0xff, 0xcf, //   ##    ## 
	0xff, 0xcf, 0xff, 0xcf, //   ##    ## 
	0xff, 0xc3, 0xff, 0x0f, //   ##    ## 
	0xff, 0xf0, 0x00, 0x3f, //   ##    ## 
	0xff, 0xfc, 0x00, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //  #######   
	                        //            
	                        //            
	                        //            
                          //            
	                        //            

	// @1628 'E' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc0, 0x00, 0x0f, //  ########  
	0xff, 0xc0, 0x00, 0x0f, //   ##    #  
	0xff, 0xcf, 0xcf, 0xcf, //   ##    #  
	0xff, 0xcf, 0xcf, 0xcf, //   ##  #    
	0xff, 0xcf, 0x03, 0xcf, //   #####    
	0xff, 0xcf, 0xff, 0xcf, //   ##  #    
	0xff, 0xc0, 0xfc, 0x0f, //   ##    #  
	0xff, 0xff, 0xff, 0xff, //   ##    #  
	0xff, 0xff, 0xff, 0xff, //  ########  
	                        //            
	                        //            
	                        //            
	                        //            
                          //            

	// @1672 'F' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc0, 0x00, 0x0f, //  ######### 
	0xff, 0xc0, 0x00, 0x0f, //   ##     # 
	0xff, 0xcf, 0xcf, 0xcf, //   ##     # 
	0xff, 0xcf, 0xcf, 0xcf, //   ##  #    
	0xff, 0xff, 0x03, 0xcf, //   #####    
	0xff, 0xff, 0xff, 0xcf, //   ##  #    
	0xff, 0xff, 0xfc, 0x0f, //   ##       
	0xff, 0xff, 0xff, 0xff, //   ##       
	0xff, 0xff, 0xff, 0xff, //  #####     
                          //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1716 'G' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x00, 0xff, //            
	0xff, 0xf0, 0x00, 0x3f, //    #### #  
	0xff, 0xc3, 0xff, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xff, 0xcf, //  ##     #  
	0xff, 0xcf, 0x3f, 0xcf, //  ##        
	0xff, 0xcf, 0x3f, 0xcf, //  ##        
	0xff, 0xc0, 0x3f, 0x3f, //  ##  ##### 
	0xff, 0xc0, 0x3c, 0x0f, //  ##    ##  
	0xff, 0xff, 0x3f, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //    #####   
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1760 'H' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc0, 0x00, 0x0f, //  #### #### 
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xcf, 0xcf, //   ##   ##  
	0xff, 0xff, 0xcf, 0xff, //   ##   ##  
	0xff, 0xcf, 0xcf, 0xcf, //   #######  
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xff, 0xcf, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //  #### #### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1804 'I' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //   ######## 
	0xff, 0xcf, 0xff, 0xcf, //      ##    
	0xff, 0xcf, 0xff, 0xcf, //      ##    
	0xff, 0xc0, 0x00, 0x0f, //      ##    
	0xff, 0xc0, 0x00, 0x0f, //      ##    
	0xff, 0xcf, 0xff, 0xcf, //      ##    
	0xff, 0xcf, 0xff, 0xcf, //      ##    
	0xff, 0xcf, 0xff, 0xcf, //      ##    
	0xff, 0xff, 0xff, 0xff, //   ######## 
                          //            
                          //            
                          //            
	                        //            
	                        //            

	// @1848 'J' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xf0, 0x3f, 0xff, //            
	0xff, 0xc0, 0x3f, 0xff, //    ####### 
	0xff, 0xcf, 0xff, 0xcf, //       ##   
	0xff, 0xcf, 0xff, 0xcf, //       ##   
	0xff, 0xcf, 0xff, 0xcf, //       ##   
	0xff, 0xc0, 0x00, 0x0f, //       ##   
	0xff, 0xf0, 0x00, 0x0f, //  ##   ##   
	0xff, 0xff, 0xff, 0xcf, //  ##   ##   
	0xff, 0xff, 0xff, 0xcf, //  ##   ##   
	0xff, 0xff, 0xff, 0xff, //   #####    
	                        //            
	                        //            
	                        //            
                          //            
                          //            

	// @1892 'K' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc0, 0x00, 0x0f, //  #### #### 
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xcf, 0x0f, 0xcf, //   ##  ##   
	0xff, 0xff, 0x03, 0xff, //   ## ##    
	0xff, 0xfc, 0x30, 0xcf, //   ####     
	0xff, 0xc0, 0xfc, 0x0f, //   #####    
	0xff, 0xc3, 0xff, 0x0f, //   ##  ##   
	0xff, 0xcf, 0xff, 0xcf, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //  ####  ### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1936 'L' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xcf, 0xff, 0xcf, //  ######    
	0xff, 0xc0, 0x00, 0x0f, //    ##      
	0xff, 0xc0, 0x00, 0x0f, //    ##      
	0xff, 0xcf, 0xff, 0xcf, //    ##      
	0xff, 0xcf, 0xff, 0xcf, //    ##      
	0xff, 0xcf, 0xff, 0xff, //    ##    # 
	0xff, 0xcf, 0xff, 0xff, //    ##    # 
	0xff, 0xc0, 0x3f, 0xff, //    ##    # 
	0xff, 0xff, 0xff, 0xff, //  ######### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @1980 'M' (11 lines)
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc0, 0x00, 0x0f, //            
	0xff, 0xc0, 0x00, 0x0f, // ###     ###
	0xff, 0xcf, 0xf0, 0xff, //  ##     ## 
	0xff, 0xcf, 0x03, 0xff, //  ###   ### 
	0xff, 0xfc, 0x3f, 0xff, //  #### #### 
	0xff, 0xcf, 0x03, 0xff, //  ## # # ## 
	0xff, 0xcf, 0xf0, 0xff, //  ## ### ## 
	0xff, 0xc0, 0x00, 0x0f, //  ##  #  ## 
	0xff, 0xc0, 0x00, 0x0f, //  ##     ## 
	0xff, 0xcf, 0xff, 0xcf, // ##### #####
                          //            
                          //            
                          //            
                          //            
                          //            

	// @2024 'N' (11 lines)
  0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
  0xff, 0xc0, 0x00, 0x0f, //  ###  #### 
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xf0, 0xff, //   ###  ##  
	0xff, 0xff, 0x03, 0xff, //   #### ##  
	0xff, 0xfc, 0x3f, 0xcf, //   ## # ##  
	0xff, 0xc0, 0x00, 0x0f, //   ## ####  
	0xff, 0xc0, 0x00, 0x0f, //   ##  ###  
	0xff, 0xff, 0xff, 0xcf, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //  ####  ##  
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @2068 'O' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x00, 0xff, //            
	0xff, 0xf0, 0x00, 0x3f, //    #####   
	0xff, 0xc3, 0xff, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xff, 0xcf, //  ##     ## 
	0xff, 0xcf, 0xff, 0xcf, //  ##     ## 
	0xff, 0xcf, 0xff, 0xcf, //  ##     ## 
	0xff, 0xc3, 0xff, 0x0f, //  ##     ## 
	0xff, 0xf0, 0x00, 0x3f, //  ##     ## 
	0xff, 0xfc, 0x00, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //    #####   
                          //            
                          //            
	                        //            
	                        //            
	                        //            

	// @2112 'P' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc0, 0x00, 0x0f, //  #######   
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xcf, 0x3f, 0xcf, //   ##   ##  
	0xff, 0xcf, 0x3f, 0xcf, //   ##   ##  
	0xff, 0xcf, 0x3f, 0xcf, //   ##   ##  
	0xff, 0xff, 0x00, 0x0f, //   ######   
	0xff, 0xff, 0xc0, 0x3f, //   ##       
	0xff, 0xff, 0xff, 0xff, //   ##       
	0xff, 0xff, 0xff, 0xff, //  ######    
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @2156 'Q' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x00, 0xff, //            
	0xff, 0xf0, 0x00, 0x3f, //    #####   
	0xfc, 0xc3, 0xff, 0x0f, //   ##   ##  
	0xfc, 0x0f, 0xff, 0xcf, //  ##     ## 
	0xfc, 0x0f, 0xff, 0xcf, //  ##     ## 
	0xfc, 0xcf, 0xff, 0xcf, //  ##     ## 
	0xfc, 0xc3, 0xff, 0x0f, //  ##     ## 
	0xfc, 0x30, 0x00, 0x3f, //  ##     ## 
	0xff, 0x3c, 0x00, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //    #####   
	                        //     ##  ## 
	                        //    ######  
	                        //            
	                        //            
	                        //            

	// @2200 'R' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc0, 0x00, 0x0f, //  #######   
	0xff, 0xc0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xcf, 0xcf, //   ##   ##  
	0xff, 0xcf, 0xcf, 0xcf, //   ##   ##  
	0xff, 0xff, 0x0f, 0xcf, //   #####    
	0xff, 0xf0, 0x30, 0x0f, //   ##  ##   
	0xff, 0xc0, 0xf0, 0x3f, //   ##   ##  
	0xff, 0xcf, 0xff, 0xff, //   ##   ##  
	0xff, 0xcf, 0xff, 0xff, //  #####  ###
	                        //            
	                        //            
                          //            
                          //            
	                        //            

	// @2244 'S' (11 lines)
  0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xc0, 0xf0, 0x3f, //    ######  
	0xff, 0xc0, 0xc0, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xc3, 0xcf, //   ##   ##  
	0xff, 0xcf, 0xcf, 0xcf, //   ###      
	0xff, 0xcf, 0x0f, 0xcf, //    #####   
	0xff, 0xc0, 0x0c, 0x0f, //       ###  
	0xff, 0xf0, 0x3c, 0x0f, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //   ######   
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @2288 'T' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xf0, 0x0f, //            
	0xff, 0xcf, 0xff, 0xcf, //  ########  
	0xff, 0xcf, 0xff, 0xcf, //  #  ##  #  
	0xff, 0xc0, 0x00, 0x0f, //  #  ##  #  
	0xff, 0xc0, 0x00, 0x0f, //  #  ##  #  
	0xff, 0xcf, 0xff, 0xcf, //     ##     
	0xff, 0xcf, 0xff, 0xcf, //     ##     
	0xff, 0xff, 0xf0, 0x0f, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //   ######   
	                        //            
                          //            
	                        //            
	                        //            
	                        //            

	// @2332 'U' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xcf, //            
	0xff, 0xf0, 0x00, 0x0f, //  #### #### 
	0xff, 0xf0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xcf, 0xff, 0xcf, //   ##   ##  
	0xff, 0xcf, 0xff, 0xff, //   ##   ##  
	0xff, 0xcf, 0xff, 0xcf, //   ##   ##  
	0xff, 0xf0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xf0, 0x00, 0x0f, //   ##   ##  
	0xff, 0xff, 0xff, 0xcf, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //    #####   
	                        //            
	                        //            
                          //            
                          //            
                          //            

	// @2376 'V' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xcf, //            
	0xff, 0xff, 0xfc, 0x0f, //  #### #### 
	0xff, 0xff, 0x00, 0x0f, //   ##   ##  
	0xff, 0xc0, 0x03, 0xcf, //   ##   ##  
	0xff, 0xc3, 0xff, 0xff, //    ## ##   
	0xff, 0xc0, 0x03, 0xcf, //    ## ##   
	0xff, 0xff, 0x00, 0x0f, //    ## ##   
	0xff, 0xff, 0xfc, 0x0f, //     # #    
	0xff, 0xff, 0xff, 0xcf, //     ###    
	0xff, 0xff, 0xff, 0xff, //     ###    
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @2420 'W' (11 lines)
	0xff, 0xff, 0xff, 0xcf, //            
	0xff, 0xff, 0xc0, 0x0f, //            
	0xff, 0xc0, 0x00, 0x0f, // ##### #####
	0xff, 0xc0, 0xff, 0xcf, //  ##     ## 
	0xff, 0xf0, 0x03, 0xcf, //  ##  #  ## 
	0xff, 0xff, 0xc0, 0xff, //  ## ### ## 
	0xff, 0xf0, 0x03, 0xcf, //  ## ### ## 
	0xff, 0xc0, 0xff, 0xcf, //   # # # #  
	0xff, 0xc0, 0x00, 0x0f, //   ### ###  
	0xff, 0xff, 0xc0, 0x0f, //   ### ###  
	0xff, 0xff, 0xff, 0xcf, //   ##   ##  
                          //            
                          //            
	                        //            
                          //            
                          //            

	// @2464 'X' (11 lines)
  0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xcf, //            
	0xff, 0xc3, 0xff, 0x0f, //  #### #### 
	0xff, 0xc0, 0xfc, 0x0f, //   ##   ##  
	0xff, 0xcc, 0x00, 0xcf, //    ## ##   
	0xff, 0xff, 0x03, 0xff, //     ###    
	0xff, 0xcc, 0x00, 0xcf, //     ###    
	0xff, 0xc0, 0xfc, 0x0f, //     ###    
	0xff, 0xc3, 0xff, 0x0f, //    ## ##   
	0xff, 0xcf, 0xff, 0xcf, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //  #### #### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @2508 'Y' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xcf, //            
	0xff, 0xff, 0xff, 0x0f, //  ####  ####
	0xff, 0xcf, 0xfc, 0x0f, //   ##    ## 
	0xff, 0xcf, 0xf0, 0xcf, //    ##  ##  
	0xff, 0xc0, 0x03, 0xff, //     ####   
	0xff, 0xc0, 0x03, 0xff, //      ##    
	0xff, 0xcf, 0xf0, 0xcf, //      ##    
	0xff, 0xcf, 0xfc, 0x0f, //      ##    
	0xff, 0xff, 0xff, 0x0f, //      ##    
	0xff, 0xff, 0xff, 0xcf, //    ######  
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @2552 'Z' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xc3, 0xfc, 0x0f, //   #######  
	0xff, 0xc0, 0xff, 0xcf, //   #    ##  
	0xff, 0xcc, 0x3f, 0xcf, //   #   ##   
	0xff, 0xcf, 0x03, 0xcf, //      ##    
	0xff, 0xcf, 0xf0, 0xcf, //      #     
	0xff, 0xcf, 0xfc, 0x0f, //     ##     
	0xff, 0xc0, 0xff, 0x0f, //    ##   #  
	0xff, 0xff, 0xff, 0xff, //   ##    #  
	0xff, 0xff, 0xff, 0xff, //   #######  
	                        //            
	                        //            
                          //            
                          //            
	                        //            

	// @2596 '[' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ####  
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xfc, 0x00, 0x00, 0x03, //      ##    
	0xfc, 0x00, 0x00, 0x03, //      ##    
	0xfc, 0xff, 0xff, 0xf3, //      ##    
	0xfc, 0xff, 0xff, 0xf3, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
                                //      ##    
	                        //      ####  
                                //            
                                //            
                                //            

	// @2640 '\' (11 lines)
	0xff, 0xff, 0xff, 0xff, //   ##       
	0xff, 0xff, 0xff, 0xff, //   ##       
	0xff, 0xff, 0xff, 0xf0, //    ##      
	0xff, 0xff, 0xff, 0x00, //    ##      
	0xff, 0xff, 0xf0, 0x0f, //     ##     
	0xff, 0xff, 0xc0, 0xff, //     ##     
	0xff, 0xfc, 0x0f, 0xff, //      ##    
	0xff, 0xc0, 0x3f, 0xff, //       ##   
	0xfc, 0x03, 0xff, 0xff, //       ##   
	0xfc, 0x3f, 0xff, 0xff, //        ##  
	0xff, 0xff, 0xff, 0xff, //        ##  
	                        //         ## 
	                        //         ## 
	                        //            
	                        //            
	                        //            

	// @2684 ']' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //    ####    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xfc, 0xff, 0xff, 0xf3, //      ##    
	0xfc, 0xff, 0xff, 0xf3, //      ##    
	0xfc, 0x00, 0x00, 0x03, //      ##    
	0xfc, 0x00, 0x00, 0x03, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	                        //      ##    
	                        //    ####    
	                        //            
	                        //            
	                        //            

	// @2728 '^' (11 lines)
	0xff, 0xff, 0xff, 0xff, //      #     
	0xff, 0xff, 0xff, 0xff, //     # #    
	0xff, 0xff, 0xf0, 0xff, //     # #    
	0xff, 0xff, 0xff, 0x3f, //    #   #   
	0xff, 0xff, 0xff, 0xc3, //   #     #  
	0xff, 0xff, 0xff, 0xfc, //   #     #  
	0xff, 0xff, 0xff, 0xc3, //            
	0xff, 0xff, 0xff, 0x3f, //            
	0xff, 0xff, 0xf0, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
                          //            
	                        //            
	                        //            
                          //            

	// @2772 '_' (11 lines)
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	0x3f, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
	                        //            
	                        //            
	                        // ###########

	// @2816 '`' (11 lines)
	0xff, 0xff, 0xff, 0xff, //     #      
	0xff, 0xff, 0xff, 0xff, //      #     
	0xff, 0xff, 0xff, 0xff, //       #    
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xfc, //            
	0xff, 0xff, 0xff, 0xf3, //            
	0xff, 0xff, 0xff, 0xcf, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @2860 'a' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xf0, 0xff, 0xff, //            
	0xff, 0xc0, 0x3c, 0xff, //            
	0xff, 0xcf, 0x3c, 0xff, //    #####   
	0xff, 0xcf, 0x3c, 0xff, //        ##  
	0xff, 0xf3, 0x3c, 0xff, //        ##  
	0xff, 0xc0, 0x00, 0xff, //    ######  
	0xff, 0xc0, 0x03, 0xff, //   ##   ##  
	0xff, 0xcf, 0xff, 0xff, //   ##  ###  
	0xff, 0xff, 0xff, 0xff, //    ### ### 
	                        //            
                          //            
                          //            
                          //            
                          //            

	// @2904 'b' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xf3, //  ###       
	0xff, 0xc0, 0x00, 0x03, //   ##       
	0xff, 0xc0, 0x00, 0x03, //   ##       
	0xff, 0xf3, 0xf3, 0xff, //   ## ###   
	0xff, 0xcf, 0xfc, 0xff, //   ###  ##  
	0xff, 0xcf, 0xfc, 0xff, //   ##    ## 
	0xff, 0xc3, 0xf0, 0xff, //   ##    ## 
	0xff, 0xf0, 0x03, 0xff, //   ##    ## 
	0xff, 0xfc, 0x0f, 0xff, //   ###  ##  
	0xff, 0xff, 0xff, 0xff, //  ### ###   
	                        //            
                          //            
                          //            
                          //            
                          //            

	// @2948 'c' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x0f, 0xff, //            
	0xff, 0xf0, 0x03, 0xff, //            
	0xff, 0xc3, 0xf0, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //    #### #  
	0xff, 0xcf, 0xfc, 0xff, //   ##   ##  
	0xff, 0xcf, 0xfc, 0xff, //  ##     #  
	0xff, 0xc3, 0xf3, 0xff, //  ##        
	0xff, 0xf0, 0xc0, 0xff, //  ##     #  
	0xff, 0xff, 0xff, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //    #####   
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @2992 'd' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x0f, 0xff, //       ###  
	0xff, 0xf0, 0x03, 0xff, //        ##  
	0xff, 0xc3, 0xf0, 0xff, //        ##  
	0xff, 0xcf, 0xfc, 0xff, //    ### ##  
	0xff, 0xcf, 0xfc, 0xff, //   ##  ###  
	0xff, 0xf3, 0xf3, 0xf3, //  ##    ##  
	0xff, 0xc0, 0x00, 0x03, //  ##    ##  
	0xff, 0xc0, 0x00, 0x03, //  ##    ##  
	0xff, 0xcf, 0xff, 0xff, //   ##  ###  
	0xff, 0xff, 0xff, 0xff, //    ### ### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3036 'e' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x0f, 0xff, //            
	0xff, 0xf0, 0x03, 0xff, //            
	0xff, 0xc3, 0x30, 0xff, //            
	0xff, 0xcf, 0x3c, 0xff, //    #####   
	0xff, 0xcf, 0x3c, 0xff, //   ##   ##  
	0xff, 0xcf, 0x30, 0xff, //  ##     ## 
	0xff, 0xc3, 0x03, 0xff, //  ######### 
	0xff, 0xf3, 0x0f, 0xff, //  ##        
	0xff, 0xff, 0xff, 0xff, //   ##    ## 
	0xff, 0xff, 0xff, 0xff, //    ######  
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3080 'f' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ######
	0xff, 0xcf, 0xfc, 0xff, //     ##     
	0xff, 0xcf, 0xfc, 0xff, //     ##     
	0xff, 0xc0, 0x00, 0x0f, //   #######  
	0xff, 0xc0, 0x00, 0x03, //     ##     
	0xff, 0xcf, 0xfc, 0xf3, //     ##     
	0xff, 0xcf, 0xfc, 0xf3, //     ##     
	0xff, 0xcf, 0xfc, 0xf3, //     ##     
	0xff, 0xff, 0xff, 0xf3, //     ##     
	0xff, 0xff, 0xff, 0xf3, //   #######  
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3124 'g' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x0f, 0xff, //            
	0xff, 0xf0, 0x03, 0xff, //            
	0xf3, 0xc3, 0xf0, 0xff, //            
	0xf3, 0xcf, 0xfc, 0xff, //    ### ### 
	0xf3, 0xcf, 0xfc, 0xff, //   ##  ###  
	0xf3, 0xf3, 0xf3, 0xff, //  ##    ##  
	0xf0, 0x00, 0x00, 0xff, //  ##    ##  
	0xfc, 0x00, 0x00, 0xff, //  ##    ##  
	0xff, 0xff, 0xfc, 0xff, //   ##  ###  
	0xff, 0xff, 0xff, 0xff, //    ### ##  
	                        //        ##  
	                        //        ##  
	                        //    #####   
                          //            
	                        //            

	// @3168 'h' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xf3, //  ###       
	0xff, 0xc0, 0x00, 0x03, //   ##       
	0xff, 0xc0, 0x00, 0x03, //   ##       
	0xff, 0xcf, 0xf3, 0xff, //   ## ###   
	0xff, 0xff, 0xfc, 0xff, //   ###  ##  
	0xff, 0xcf, 0xfc, 0xff, //   ##   ##  
	0xff, 0xc0, 0x00, 0xff, //   ##   ##  
	0xff, 0xc0, 0x03, 0xff, //   ##   ##  
	0xff, 0xcf, 0xff, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //  #### #### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3212 'i' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xcf, 0xfc, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //    ####    
	0xff, 0xc0, 0x00, 0xc3, //      ##    
	0xff, 0xc0, 0x00, 0xc3, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //   ######## 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3256 'j' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xf3, 0xff, 0xfc, 0xff, //      ##    
	0xf3, 0xff, 0xfc, 0xff, //            
	0xf3, 0xff, 0xfc, 0xff, //   ######   
	0xf3, 0xff, 0xfc, 0xc3, //       ##   
	0xf0, 0x00, 0x00, 0xc3, //       ##   
	0xfc, 0x00, 0x00, 0xff, //       ##   
	0xff, 0xff, 0xff, 0xff, //       ##   
	0xff, 0xff, 0xff, 0xff, //       ##   
	0xff, 0xff, 0xff, 0xff, //       ##   
	                        //       ##   
	                        //       ##   
                          //   #####    
	                        //            
                          //            

	// @3300 'k' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xf3, //  ###       
	0xff, 0xc0, 0x00, 0x03, //   ##       
	0xff, 0xc0, 0x00, 0x03, //   ##       
	0xff, 0xff, 0x0f, 0xff, //   ## ####  
	0xff, 0xcc, 0x00, 0xff, //   ## ##    
	0xff, 0xc0, 0xf0, 0xff, //   ####     
	0xff, 0xc3, 0xfc, 0xff, //   ####     
	0xff, 0xcf, 0xfc, 0xff, //   ## ##    
	0xff, 0xcf, 0xff, 0xff, //   ##  ##   
	0xff, 0xff, 0xff, 0xff, //  ### ##### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3344 'l' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xff, 0xff, //    ####    
	0xff, 0xcf, 0xff, 0xf3, //      ##    
	0xff, 0xcf, 0xff, 0xf3, //      ##    
	0xff, 0xc0, 0x00, 0x03, //      ##    
	0xff, 0xc0, 0x00, 0x03, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xcf, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //   ######## 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3388 'm' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //            
	0xff, 0xc0, 0x00, 0xff, //            
	0xff, 0xc0, 0x00, 0xff, //            
	0xff, 0xff, 0xfc, 0xff, //  ########  
	0xff, 0xc0, 0x00, 0xff, //   ## ## ## 
	0xff, 0xc0, 0x00, 0xff, //   ## ## ## 
	0xff, 0xff, 0xfc, 0xff, //   ## ## ## 
	0xff, 0xc0, 0x00, 0xff, //   ## ## ## 
	0xff, 0xc0, 0x03, 0xff, //   ## ## ## 
	0xff, 0xcf, 0xff, 0xff, //  ### ## ###
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3432 'n' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //            
	0xff, 0xc0, 0x00, 0xff, //            
	0xff, 0xc0, 0x00, 0xff, //            
	0xff, 0xcf, 0xf3, 0xff, //  ### ###   
	0xff, 0xff, 0xfc, 0xff, //   ###  ##  
	0xff, 0xcf, 0xfc, 0xff, //   ##   ##  
	0xff, 0xc0, 0x00, 0xff, //   ##   ##  
	0xff, 0xc0, 0x03, 0xff, //   ##   ##  
	0xff, 0xcf, 0xff, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //  #### #### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3476 'o' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x0f, 0xff, //            
	0xff, 0xf0, 0x03, 0xff, //            
	0xff, 0xc3, 0xf0, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //    #####   
	0xff, 0xcf, 0xfc, 0xff, //   ##   ##  
	0xff, 0xcf, 0xfc, 0xff, //  ##     ## 
	0xff, 0xc3, 0xf0, 0xff, //  ##     ## 
	0xff, 0xf0, 0x03, 0xff, //  ##     ## 
	0xff, 0xfc, 0x0f, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //    #####   
	                        //            
	                        //            
	                        //            
	                        //            
                          //            

	// @3520 'p' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xf3, 0xff, 0xfc, 0xff, //            
	0xf0, 0x00, 0x00, 0xff, //            
	0xf0, 0x00, 0x00, 0xff, //            
	0xf3, 0xf3, 0xf3, 0xff, //  ### ###   
	0xf3, 0xcf, 0xfc, 0xff, //   ###  ##  
	0xff, 0xcf, 0xfc, 0xff, //   ##    ## 
	0xff, 0xc3, 0xf0, 0xff, //   ##    ## 
	0xff, 0xf0, 0x03, 0xff, //   ##    ## 
	0xff, 0xfc, 0x0f, 0xff, //   ###  ##  
	0xff, 0xff, 0xff, 0xff, //   ## ###   
	                        //   ##       
	                        //   ##       
	                        //  #####     
	                        //            
	                        //            

	// @3564 'q' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xfc, 0x0f, 0xff, //            
	0xff, 0xf0, 0x03, 0xff, //            
	0xff, 0xc3, 0xf0, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //    ### ### 
	0xf3, 0xcf, 0xfc, 0xff, //   ##  ###  
	0xf3, 0xf3, 0xf3, 0xff, //  ##    ##  
	0xf0, 0x00, 0x00, 0xff, //  ##    ##  
	0xf0, 0x00, 0x00, 0xff, //  ##    ##  
	0xf3, 0xff, 0xfc, 0xff, //   ##  ###  
	0xff, 0xff, 0xff, 0xff, //    ### ##  
	                        //        ##  
	                        //        ##  
	                        //      ##### 
	                        //            
                          //            

	// @3608 'r' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //            
	0xff, 0xc0, 0x00, 0xff, //            
	0xff, 0xc0, 0x00, 0xff, //  #### ###  
	0xff, 0xcf, 0xf3, 0xff, //    ###  ## 
	0xff, 0xcf, 0xfc, 0xff, //    ##      
	0xff, 0xcf, 0xfc, 0xff, //    ##      
	0xff, 0xff, 0xf0, 0xff, //    ##      
	0xff, 0xff, 0xf3, 0xff, //    ##      
	0xff, 0xff, 0xff, 0xff, //  #######   
	                        //            
                          //            
                          //            
	                        //            
	                        //            

	// @3652 's' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xc3, 0xc3, 0xff, //            
	0xff, 0xc3, 0x00, 0xff, //            
	0xff, 0xcf, 0x0c, 0xff, //            
	0xff, 0xcf, 0x0c, 0xff, //    ######  
	0xff, 0xcc, 0x3c, 0xff, //   ##   ##  
	0xff, 0xc0, 0x30, 0xff, //   ####     
	0xff, 0xf0, 0xf0, 0xff, //    #####   
	0xff, 0xff, 0xff, 0xff, //       ###  
	0xff, 0xff, 0xff, 0xff, //   ##   ##  
	0xff, 0xff, 0xff, 0xff, //   ######   
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3696 't' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xfc, 0xff, //    ##      
	0xff, 0xff, 0xfc, 0xff, //    ##      
	0xff, 0xf0, 0x00, 0x03, //    ##      
	0xff, 0xc0, 0x00, 0x03, //  #######   
	0xff, 0xcf, 0xfc, 0xff, //    ##      
	0xff, 0xcf, 0xfc, 0xff, //    ##      
	0xff, 0xcf, 0xfc, 0xff, //    ##      
	0xff, 0xf3, 0xff, 0xff, //    ##      
	0xff, 0xff, 0xff, 0xff, //    ##   #  
	0xff, 0xff, 0xff, 0xff, //     ####   
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3740 'u' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xfc, 0xff, //            
	0xff, 0xf0, 0x00, 0xff, //            
	0xff, 0xc0, 0x00, 0xff, //            
	0xff, 0xcf, 0xff, 0xff, //  ###  ###  
	0xff, 0xcf, 0xff, 0xff, //   ##   ##  
	0xff, 0xf3, 0xfc, 0xff, //   ##   ##  
	0xff, 0xc0, 0x00, 0xff, //   ##   ##  
	0xff, 0xc0, 0x00, 0xff, //   ##   ##  
	0xff, 0xcf, 0xff, 0xff, //   ##  ###  
	0xff, 0xff, 0xff, 0xff, //    ### ### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3748 'v' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xfc, 0xff, //            
	0xff, 0xff, 0xc0, 0xff, //            
	0xff, 0xfc, 0x00, 0xff, //            
	0xff, 0xc0, 0x3c, 0xff, //  #### #### 
	0xff, 0xc3, 0xff, 0xff, //   ##   ##  
	0xff, 0xc0, 0x3c, 0xff, //   ##   ##  
	0xff, 0xfc, 0x00, 0xff, //    ## ##   
	0xff, 0xff, 0xc0, 0xff, //    ## ##   
	0xff, 0xff, 0xfc, 0xff, //     ###    
	0xff, 0xff, 0xff, 0xff, //     ###    
	                        //            
	                        //            
	                        //            
	                        //            
                          //            

	// @3828 'w' (11 lines)
	0xff, 0xff, 0xfc, 0xff, //            
	0xff, 0xff, 0x00, 0xff, //            
	0xff, 0xc0, 0x00, 0xff, //            
	0xff, 0xc0, 0xfc, 0xff, //            
	0xff, 0xf0, 0x3f, 0xff, // ####   ####
	0xff, 0xff, 0x0f, 0xff, //  ##     ## 
	0xff, 0xf0, 0x3f, 0xff, //  ##  #  ## 
	0xff, 0xc0, 0xfc, 0xff, //  ## ### ## 
	0xff, 0xc0, 0x00, 0xff, //   ### ###  
	0xff, 0xff, 0x00, 0xff, //   ### ###  
	0xff, 0xff, 0xfc, 0xff, //   ##   ##  
	                        //            
                          //            
                          //            
	                        //            
                          //            

	// @3872 'x' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //            
	0xff, 0xcf, 0xfc, 0xff, //            
	0xff, 0xc3, 0xf0, 0xff, //            
	0xff, 0xc0, 0x00, 0xff, //  #### #### 
	0xff, 0xfc, 0x0f, 0xff, //    ## ##   
	0xff, 0xc0, 0x00, 0xff, //     ###    
	0xff, 0xc3, 0xf0, 0xff, //     ###    
	0xff, 0xcf, 0xfc, 0xff, //     ###    
	0xff, 0xcf, 0xfc, 0xff, //    ## ##   
	0xff, 0xff, 0xff, 0xff, //  #### #### 
	                        //            
	                        //            
	                        //            
	                        //            
	                        //            

	// @3916 'y' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xfc, 0xff, //            
	0xf3, 0xff, 0xf0, 0xff, //            
	0xf3, 0xff, 0x00, 0xff, //            
	0xf0, 0xf0, 0x0c, 0xff, //  ####  ####
	0xf0, 0x03, 0xff, 0xff, //   ##    ## 
	0xf3, 0x00, 0xff, 0xff, //    ##  ##  
	0xff, 0xf0, 0x0c, 0xff, //    ##  ##  
	0xff, 0xff, 0x00, 0xff, //     # ##   
	0xff, 0xff, 0xf0, 0xff, //     ####   
	0xff, 0xff, 0xfc, 0xff, //      ##    
                          //      ##    
                          //     ##     
                          //   #####    
                          //            
	                        //            

	// @3960 'z' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xc3, 0xf0, 0xff, //            
	0xff, 0xc0, 0xfc, 0xff, //            
	0xff, 0xcc, 0x3c, 0xff, //   #######  
	0xff, 0xcf, 0x3c, 0xff, //   #    ##  
	0xff, 0xcf, 0x0c, 0xff, //       ##   
	0xff, 0xcf, 0xc0, 0xff, //     ###    
	0xff, 0xc3, 0xf0, 0xff, //    ##      
	0xff, 0xff, 0xff, 0xff, //   ##    #  
	0xff, 0xff, 0xff, 0xff, //   #######  
	                        //            
                          //            
                          //            
                          //            
                          //            

	// @4004 '{' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0x3f, 0xff, //     ##     
	0xff, 0x00, 0x00, 0x0f, //     ##     
	0xfc, 0x00, 0xc0, 0x03, //     ##     
	0xfc, 0xff, 0xff, 0xf3, //     ##     
	0xff, 0xff, 0xff, 0xff, //    ##      
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //     ##     
	                        //     ##     
                          //      ##    
	                        //            
                          //            
                          //            

	// @4048 '|' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xfc, 0x00, 0x00, 0x03, //      ##    
	0xfc, 0x00, 0x00, 0x03, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	                        //      ##    
	                        //      ##    
	                        //            
                          //            
                          //            

	// @4092 '}' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //     ##     
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xfc, 0xff, 0xff, 0xf3, //      ##    
	0xfc, 0x00, 0xc0, 0x03, //      ##    
	0xff, 0x00, 0x00, 0x0f, //      ##    
	0xff, 0xff, 0x3f, 0xff, //       ##   
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	0xff, 0xff, 0xff, 0xff, //      ##    
	                        //      ##    
	                        //     ##     
	                        //            
	                        //            
                          //            

	// @4136 '~' (11 lines)
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xf3, 0xff, //            
	0xff, 0xff, 0xf3, 0xff, //            
	0xff, 0xff, 0xcf, 0xff, //    ##      
	0xff, 0xff, 0x3f, 0xff, //   #  #  #  
	0xff, 0xff, 0x3f, 0xff, //       ##   
	0xff, 0xff, 0xcf, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	0xff, 0xff, 0xff, 0xff, //            
	                        //            
	                        //            
                          //            
                          //            
                          //            
};

sFONT Font16 = {
  Font16_Table,
  11, /* Width */    // (11 lines)
  4, /* Height */    // (4 bytes/16pixels)
};

/**
  * @}
  */ 


/** @defgroup FONTS_Private_Function_Prototypes
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup FONTS_Private_Functions
  * @{
  */
    
/**
  * @}
  */
  
/**
  * @}
  */ 

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
