#include "mbed.h"
#include "stm32l4r9i_discovery_lcd.h"
#include "stlogo.h"

int main()
{
    char desc[50];

    printf("\nSTART DISCO-L4R9I LCD EXAMPLE\n");

    /* Avoid deepsleep */
    sleep_manager_lock_deep_sleep();

    if (BSP_LCD_Init() != LCD_OK) {
        error("BSP_LCD_Init");
    }

    while (BSP_LCD_IsFrameBufferAvailable() != LCD_OK);

    /* Set LCD Foreground Layer  */
    BSP_LCD_SelectLayer(LTDC_DEFAULT_ACTIVE_LAYER);

    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);

    /* Clear the LCD */
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_Clear(LCD_COLOR_WHITE);

    /* Set the LCD Text Color */
    BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);

    /* Display LCD messages */
    BSP_LCD_DisplayStringAt(0, 50, (uint8_t *)"DISCO_L4R9I BSP", CENTER_MODE);
    BSP_LCD_DisplayStringAt(0, 75, (uint8_t *)"Drivers examples", CENTER_MODE);

    /* Draw Bitmap */
    BSP_LCD_DrawBitmap((BSP_LCD_GetXSize() - 80) / 2, 105, (uint8_t *)stlogo);

    BSP_LCD_SetFont(&Font16);
    BSP_LCD_DisplayStringAt(0, BSP_LCD_GetYSize() - 70, (uint8_t *)"Thank you", CENTER_MODE);

    BSP_LCD_SetFont(&Font16);
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_FillRect(0, BSP_LCD_GetYSize() / 2, BSP_LCD_GetXSize(), 80);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_DisplayStringAt(0, BSP_LCD_GetYSize() / 2 + 10, (uint8_t *)"Check API in", CENTER_MODE);
    BSP_LCD_DisplayStringAt(0, BSP_LCD_GetYSize() / 2 + 25, (uint8_t *)"BSP_DISCO_L4R9I/Drivers/BSP/", CENTER_MODE);
    BSP_LCD_DisplayStringAt(0, BSP_LCD_GetYSize() / 2 + 40, (uint8_t *)"STM32L4R9I-Discovery/", CENTER_MODE);
    BSP_LCD_DisplayStringAt(0, BSP_LCD_GetYSize() / 2 + 55, (uint8_t *)"stm32l4r9i_discovery_lcd.h", CENTER_MODE);

    /* Refresh display */
    BSP_LCD_Refresh();
}
