#include "mbed.h"
#include "stm32l496g_discovery.h"
#include "stm32l496g_discovery_lcd.h"
#include "stm32l496g_discovery_sram.h"

#define BUFFER_SIZE              ((uint32_t)0x1000)
#define SRAM_WRITE_READ_ADDR     ((uint32_t)0x0800)

uint16_t sram_aTxBuffer[BUFFER_SIZE];
uint16_t sram_aRxBuffer[BUFFER_SIZE];

__IO uint8_t  write_complete = 0;

static void print_demo_title(void);
static void Fill_Buffer(uint16_t *pBuffer, uint32_t uwBufferLength, uint32_t uwOffset);
static uint8_t Buffercmp(uint16_t* pBuffer1, uint16_t* pBuffer2, uint16_t BufferLength);

int main()
{
    print_demo_title();

    ThisThread::sleep_for(500);

    /*##-1- Configure the SRAM device ##########################################*/
    if (BSP_SRAM_Init() == SRAM_OK) {
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"SRAM INIT OK", LEFT_MODE);
    } else {
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"SRAM INIT FAIL", LEFT_MODE);
    }

    ThisThread::sleep_for(500);

    /*##-2- SRAM memory read/write access ######################################*/

    /* Fill the buffer to write */
    Fill_Buffer(sram_aTxBuffer, BUFFER_SIZE, 0xC000);
    /* Empty the buffer to read */
    Fill_Buffer(sram_aRxBuffer, BUFFER_SIZE, 0);

    /* Write data to the SRAM memory */
    if (BSP_SRAM_WriteData(SRAM_DEVICE_ADDR + SRAM_WRITE_READ_ADDR, sram_aTxBuffer, BUFFER_SIZE) == SRAM_OK) {
        BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"SRAM WRITE OK", LEFT_MODE);
    } else {
        BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"SRAM WRITE FAIL", LEFT_MODE);
    }

    ThisThread::sleep_for(500);

    /* Read back data from the SRAM memory */
    if (BSP_SRAM_ReadData(SRAM_DEVICE_ADDR + SRAM_WRITE_READ_ADDR, sram_aRxBuffer, BUFFER_SIZE) == SRAM_OK) {
        BSP_LCD_DisplayStringAt(0, LINE(7), (uint8_t *)"SRAM READ OK", LEFT_MODE);
    } else {
        BSP_LCD_DisplayStringAt(0, LINE(7), (uint8_t *)"SRAM READ FAIL", LEFT_MODE);
    }

    ThisThread::sleep_for(1000);

    /* Check read data */
    if (Buffercmp(sram_aRxBuffer, sram_aTxBuffer, BUFFER_SIZE) == 0) {
        BSP_LCD_DisplayStringAt(0, LINE(8), (uint8_t *)"SRAM COMPARE OK", LEFT_MODE);
    } else {
        BSP_LCD_DisplayStringAt(0, LINE(8), (uint8_t *)"SRAM COMPARE FAIL", LEFT_MODE);
    }
}

static void print_demo_title(void)
{
    BSP_LCD_Init();
    BSP_LCD_Clear(LCD_COLOR_WHITE);

    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_FillRect(0, 0, BSP_LCD_GetXSize(), 80);

    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(0, 0, (uint8_t *)"SRAM", CENTER_MODE);
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_DisplayStringAt(0, 30, (uint8_t *)"This example shows how to write", CENTER_MODE);
    BSP_LCD_DisplayStringAt(0, 45, (uint8_t *)"and read data on the SRAM", CENTER_MODE);
    BSP_LCD_SetFont(&Font20);
}


/**
  * @brief  Fills buffer with user predefined data.
  * @param  pBuffer: pointer on the buffer to fill
  * @param  uwBufferLength: size of the buffer to fill
  * @param  uwOffset: first value to fill on the buffer
  * @retval None
  */
static void Fill_Buffer(uint16_t *pBuffer, uint32_t uwBufferLength, uint32_t uwOffset)
{
    uint32_t tmpindex = 0;

    /* Put in global buffer different values */
    for (tmpindex = 0; tmpindex < uwBufferLength; tmpindex++ ) {
        pBuffer[tmpindex] = tmpindex + uwOffset;
    }
}

/**
  * @brief  Compares two buffers.
  * @param  pBuffer1, pBuffer2: buffers to be compared.
  * @param  BufferLength: buffer's length
  * @retval 0: pBuffer identical to pBuffer1
  *         1: pBuffer differs from pBuffer1
  */
static uint8_t Buffercmp(uint16_t* pBuffer1, uint16_t* pBuffer2, uint16_t BufferLength)
{
    while (BufferLength--) {
        if (*pBuffer1 != *pBuffer2) {
            return 1;
        }

        pBuffer1++;
        pBuffer2++;
    }

    return 0;
}
