#include "mbed.h"
#include "stm32l496g_discovery_lcd.h"
#include "stm32l496g_discovery_ts.h"

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;

    BSP_LCD_Init();
    BSP_LCD_SetFont(&Font20);
    BSP_LCD_Clear(LCD_COLOR_BLUE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"DISCO_L496AG", CENTER_MODE);
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"LCDTS DEMO", CENTER_MODE);
    wait(1);

    if (BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize()) != TS_OK)
    {
      BSP_LCD_Clear(LCD_COLOR_RED);
      BSP_LCD_SetBackColor(LCD_COLOR_RED);
      BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
      BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TS INIT FAIL", CENTER_MODE);
    }
    else
    {
      BSP_LCD_Clear(LCD_COLOR_GREEN);
      BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
      BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
      BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TS INIT OK", CENTER_MODE);
    }
    wait(0.5);

    BSP_LCD_SetFont(&Font16);
    BSP_LCD_Clear(LCD_COLOR_BLUE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);

    while(1) {

      BSP_TS_GetState(&TS_State);

      if (TS_State.touchDetected)
      {
        // Clear lines corresponding to old touches coordinates
        if (TS_State.touchDetected < prev_nb_touches)
        {
          for (idx = (TS_State.touchDetected + 1); idx <= TS_MAX_NB_TOUCH; idx++)
          {
            BSP_LCD_ClearStringLine(idx);
          }
        }
        prev_nb_touches = TS_State.touchDetected;

        cleared = 0;

        sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
        BSP_LCD_DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);

        for (idx = 0; idx < TS_State.touchDetected; idx++)
        {
          x = TS_State.touchX[idx];
          y = TS_State.touchY[idx];
          sprintf((char*)text, "Touch %d: x=%d y=%d", idx+1, x, y);
          BSP_LCD_DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
          BSP_LCD_DrawHLine(x-10, y, 20);
          BSP_LCD_DrawVLine(x, y-10, 20);
        }
      }
      else
      {
        if (!cleared)
        {
          sprintf((char*)text, "Touches: 0");
          BSP_LCD_DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
          cleared = 1;
        }
      }

    }

}
