#include "mbed.h"

#define USE_PRINTF (1)

// Joystick button
InterruptIn center(JOYSTICK_CENTER);
InterruptIn left(JOYSTICK_LEFT);
InterruptIn right(JOYSTICK_RIGHT);
InterruptIn up(JOYSTICK_UP);
InterruptIn down(JOYSTICK_DOWN);

// LEDs
DigitalOut led_green(LED1);
DigitalOut led_red(LED2);

void center_released() {
    led_green = 0;
#if USE_PRINTF == 1
    printf("center button released\n");
#endif  
}

void center_pressed() {
    led_green = 1;
#if USE_PRINTF == 1  
    printf("center button pressed\n");
#endif  
}

void left_released() {
    led_green = 0;
#if USE_PRINTF == 1
    printf("left button released\n");
#endif  
}

void left_pressed() {
    led_green = 1;
#if USE_PRINTF == 1  
    printf("left button pressed\n");
#endif  
}

void right_released() {
    led_green = 0;
#if USE_PRINTF == 1
    printf("right button released\n");
#endif  
}

void right_pressed() {
    led_green = 1;
#if USE_PRINTF == 1  
    printf("right button pressed\n");
#endif  
}

void up_released() {
    led_green = 0;
#if USE_PRINTF == 1
    printf("up button released\n");
#endif  
}

void up_pressed() {
    led_green = 1;
#if USE_PRINTF == 1  
    printf("up button pressed\n");
#endif  
}

void down_released() {
    led_green = 0;
#if USE_PRINTF == 1
    printf("down button released\n");
#endif  
}

void down_pressed() {
    led_green = 1;
#if USE_PRINTF == 1  
    printf("down button pressed\n");
#endif  
}

int main() {

#if USE_PRINTF == 1  
    int i = 0;
    printf("\nStart!\n");
#endif
  
    // Both rise and fall edges generate an interrupt
    center.fall(&center_released);
    center.rise(&center_pressed);
    left.fall(&left_released);
    left.rise(&left_pressed);
    right.fall(&right_released);
    right.rise(&right_pressed);
    up.fall(&up_released);
    up.rise(&up_pressed);
    down.fall(&down_released);
    down.rise(&down_pressed);

    // Add pull-down on these pins
    // Warning: must be done AFTER edges setting
    left.mode(PullDown);
    right.mode(PullDown);
    up.mode(PullDown);
    down.mode(PullDown);
    
    while (1) {
        led_red = !led_red;
        wait(1.0);
#if USE_PRINTF == 1      
        printf("main %d\n", i++);
#endif      
    }
}
