#include "mbed.h"
#include "LCD_DISCO_L476VG.h"

LCD_DISCO_L476VG lcd;

DigitalOut led_green(LED1);
DigitalOut led_red(LED2);

InterruptIn joy_down(JOYSTICK_DOWN);
InterruptIn joy_up(JOYSTICK_UP);
InterruptIn joy_center(JOYSTICK_CENTER);

#define MODE_WAKEUP     0  // IDD=19mA
#define MODE_SLEEP      1  // IDD=10mA
#define MODE_DEEP_SLEEP 2  // IDD= 1mA

static int deepsleep_mode = MODE_WAKEUP;

// Used to enter in wake up mode
void wakeup_tasks()
{
    led_green = 1;
    led_red = 1;
    lcd.Clear();
    printf("WAKEUP\n");
    lcd.DisplayString((uint8_t *)"WAKEUP");
    deepsleep_mode = MODE_WAKEUP;
}

// Used to enter in deepsleep mode
void joy_down_pressed()
{
    deepsleep_mode = MODE_DEEP_SLEEP;
}

// Used to enter in sleep mode
void joy_up_pressed()
{
    deepsleep_mode = MODE_SLEEP;
}

int main()
{
    led_green = 1;
    led_red = 1;
    lcd.Clear();
    printf("HELLO\n");
    lcd.DisplayString((uint8_t *)"HELLO");

    // Configure the buttons
    joy_down.rise(&joy_down_pressed);
    joy_down.mode(PullDown);
    joy_up.rise(&joy_up_pressed);
    joy_up.mode(PullDown);
    joy_center.rise(&wakeup_tasks);
    joy_center.mode(PullDown);

    while(1) {

        if (deepsleep_mode == MODE_SLEEP) {
            lcd.Clear();
            printf("SLEEP\n");
            lcd.DisplayString((uint8_t *)"SLEEP");
            led_red = 0;
            wait(1);
            sleep();
            wakeup_tasks();
        }
        if (deepsleep_mode == MODE_DEEP_SLEEP) {
            lcd.Clear();
            printf("DEEP_SLEEP\n");
            lcd.DisplayString((uint8_t *)"DEEP");
            led_green = 0;
            wait(.1);
            deepsleep();
            wakeup_tasks();
        }
    }
}
