#include "mbed.h"
#include "LCD_DISCO_L476VG.h"

LCD_DISCO_L476VG lcd;

DigitalOut led_green(LED1);

int main()
{
    uint8_t DisplayedString[7] = {0};
    uint8_t title[] = "      DISCOVERY STM32L476";
  
    printf("\nHello\n");
    led_green = 1;
    lcd.Clear();
    lcd.DisplayString((uint8_t *)"HELLO");
    ThisThread::sleep_for(5000);
    led_green = 0;
    
    while(1) {
        printf("Scroll sequence\n");
        lcd.Clear();
        lcd.ScrollSentence(title, 1, 400);
        lcd.Clear();
        led_green = !led_green;
  
        for(uint32_t BarNumber = 0; BarNumber <= 4; BarNumber++) {
            printf("BAR = %d\n", BarNumber);
            sprintf((char *)DisplayedString, "BAR %d", BarNumber);
            lcd.DisplayString(DisplayedString);
            lcd.BarLevelConfig((uint8_t)BarNumber);
            ThisThread::sleep_for(1000);
        }
    }
}
