#include "mbed.h"
#include "stm32h747i_discovery.h"
#include "stm32h747i_discovery_lcd.h"
#include "stlogo.h"

static void DISCO_LCD_INIT(void)
{
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(1, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(1);
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_Clear(LCD_COLOR_WHITE);
}

static void LCD_Demo_Setup(void)
{
    /* Set LCD Demo description */
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_FillRect(0, 0, BSP_LCD_GetXSize(), 80);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(0, 10, (uint8_t *)"LCD", CENTER_MODE);
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_DisplayStringAt(0, 45, (uint8_t *)"This example shows different feature", CENTER_MODE);

    /* Set the LCD Text Color */
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_DrawRect(10, 90, BSP_LCD_GetXSize() - 20, BSP_LCD_GetYSize() - 100);
    BSP_LCD_DrawRect(11, 91, BSP_LCD_GetXSize() - 22, BSP_LCD_GetYSize() - 102);
}

/**
  * @brief  Show LCD Features
  * @param  feature : feature index
  * @retval None
  */
static void LCD_Demo_Feature(uint8_t feature)
{
    int32_t i = 0;

    Point Points[] = {{20, 150}, {80, 150}, {80, 200}};
    Point Points2[3];
    uint8_t text[50];

    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_FillRect(12, 92, BSP_LCD_GetXSize() - 24, BSP_LCD_GetYSize() - 104);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font16);

    switch (feature) {
        case 0:
            /* Text Feature */
            BSP_LCD_SetFont(&Font16);
            BSP_LCD_DisplayStringAt(14, 100, (uint8_t *)"Left aligned Text", LEFT_MODE);
            BSP_LCD_DisplayStringAt(14, 115, (uint8_t *)"Center aligned Text", CENTER_MODE);
            BSP_LCD_DisplayStringAt(14, 130, (uint8_t *)"Right aligned Text", RIGHT_MODE);
            BSP_LCD_SetFont(&Font24);
            BSP_LCD_DisplayStringAt(14, 180, (uint8_t *)"Font24", LEFT_MODE);
            BSP_LCD_SetFont(&Font20);
            BSP_LCD_DisplayStringAt(BSP_LCD_GetXSize() / 2 - 20, 180, (uint8_t *)"Font20", LEFT_MODE);
            BSP_LCD_SetFont(&Font16);
            BSP_LCD_DisplayStringAt(BSP_LCD_GetXSize() - 80, 184, (uint8_t *)"Font16", LEFT_MODE);
            break;

        case 1:
            /* Draw misc. Shapes */
            BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
            BSP_LCD_DrawRect(20, 100, 60, 40);
            BSP_LCD_FillRect(100, 100, 60, 40);

            BSP_LCD_SetTextColor(LCD_COLOR_GRAY);
            BSP_LCD_DrawCircle(BSP_LCD_GetXSize() - 120, 120, 20);
            BSP_LCD_FillCircle(BSP_LCD_GetXSize() - 40, 120, 20);

            BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
            BSP_LCD_DrawPolygon(Points, 3);

            BSP_LCD_SetTextColor(LCD_COLOR_RED);
            BSP_LCD_DrawEllipse(130, 170, 30, 20);
            BSP_LCD_FillEllipse(200, 170, 30, 20);

            BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
            BSP_LCD_DrawHLine(20, BSP_LCD_GetYSize() - 30, BSP_LCD_GetXSize() / 5);
            BSP_LCD_DrawLine(100, BSP_LCD_GetYSize() - 20, 230, BSP_LCD_GetYSize() - 50);
            BSP_LCD_DrawLine(100, BSP_LCD_GetYSize() - 50, 230, BSP_LCD_GetYSize() - 20);

            Points2[0].X = BSP_LCD_GetXSize() - 80;
            Points2[0].Y = 150;
            Points2[1].X = BSP_LCD_GetXSize() - 20;
            Points2[1].Y = 150;
            Points2[2].X = BSP_LCD_GetXSize() - 20;
            Points2[2].Y = 200;

            BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
            BSP_LCD_FillPolygon(Points2, 3);
            break;

        case 2:
            /* Draw Bitmap */
            BSP_LCD_DrawBitmap(20, 100, (uint8_t *)stlogo);
            HAL_Delay(500);

            BSP_LCD_DrawBitmap(BSP_LCD_GetXSize() / 2 - 40, 100, (uint8_t *)stlogo);
            HAL_Delay(500);

            BSP_LCD_DrawBitmap(BSP_LCD_GetXSize() - 100, 100, (uint8_t *)stlogo);
            HAL_Delay(500);

            BSP_LCD_DrawBitmap(20, BSP_LCD_GetYSize() - 80, (uint8_t *)stlogo);
            HAL_Delay(500);

            BSP_LCD_DrawBitmap(BSP_LCD_GetXSize() / 2 - 40, BSP_LCD_GetYSize() - 80, (uint8_t *)stlogo);
            HAL_Delay(500);

            BSP_LCD_DrawBitmap(BSP_LCD_GetXSize() - 100, BSP_LCD_GetYSize() - 80, (uint8_t *)stlogo);
            HAL_Delay(500);
            break;

        case 3:
            /* Set the LCD Back Color and Text Color*/
            BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
            BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
            BSP_LCD_SetFont(&Font24);

            /*  Set the brightness */
            for (i = 100; i >= 0; i -= 10) {
                sprintf((char *)text, " Brightness  =  %d ", (int)i);
                BSP_LCD_DisplayStringAt(0, BSP_LCD_GetYSize() / 2 + 45, (uint8_t *)text, CENTER_MODE);
                BSP_LCD_SetBrightness(i);
                HAL_Delay(300);
            }

            for (i = 0; i <= 100; i += 10) {
                sprintf((char *)text, " Brightness  =  %d ", (int)i);
                BSP_LCD_DisplayStringAt(0, BSP_LCD_GetYSize() / 2 + 45, (uint8_t *)text, CENTER_MODE);
                BSP_LCD_SetBrightness(i);
                HAL_Delay(300);
            }
            break;
    }
}


int main()
{
    printf("\nSTART\n");

    DISCO_LCD_INIT();
    LCD_Demo_Setup();

    while (1) {
        for (int LCD_Feature = 0; LCD_Feature < 4; ++LCD_Feature) {
            printf("Demo LCD feature %d\n", LCD_Feature);
            LCD_Demo_Feature(LCD_Feature);
            HAL_Delay(10000);
        }
    }
}
