#include "mbed.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

InterruptIn mybutton(USER_BUTTON);

double tempo = 0.2;    //time to wait

void changetempo()
{
    if(tempo == 0.2)   // If leds have low frequency
        tempo = 0.1;   // Set the fast frequency
    else               // If les have fast frequency
        tempo = 0.2;   // Set the low frequency
}

int main()
{
    myled1 = 0;            //LED1 is OFF
    myled2 = 0;            //LED2 is OFF
    myled3 = 0;            //LED3 is OFF

    mybutton.fall(&changetempo);  //Interrupt to change tempo

    while(1) {
        myled1 = 1;   // LED2 is ON
        wait(tempo);  // wait tempo
        myled1 = 0;   // LED2 is OFF
        myled2 = 1;   // LED1 is ON
        wait(tempo);  // wait tempo
        myled2 = 0;   // LED1 is OFF
        myled3 = 1;   // LED3 is ON
        wait(tempo);  // wait tempo
        myled3 = 0;   // LED3 is OFF
    }
}
