#include "mbed.h"
#include "stm32f769i_discovery_lcd.h"
#include "stm32f769i_discovery_sd.h"

int main()
{
    uint8_t SD_state = MSD_OK;
    static uint8_t prev_status = 2;

    printf("\n\n SD EXAMPLE FOR DISCO-F769NI START:\n");

    /* Init LCD and display example information */
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(0, LCD_FB_START_ADDRESS);
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_FillRect(0, 0, BSP_LCD_GetXSize(), 40);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(0, 0, (uint8_t *)"SD basic example", CENTER_MODE);

    /* SD init */
    SD_state = BSP_SD_Init();
    printf("BSP_SD_Init return %d\n", SD_state);

    if (SD_state != MSD_OK) {
        BSP_LCD_DisplayStringAt(20, 100, (uint8_t *)"SD shall be inserted before running test", LEFT_MODE);

    } else {
        BSP_LCD_DisplayStringAt(20, 100, (uint8_t *)"SD Initialization : OK", LEFT_MODE);

        SD_state = BSP_SD_Erase(0, (BLOCKSIZE * 50));
        /* Wait until SD card is ready to use for new operation */
        while (BSP_SD_GetCardState() != SD_TRANSFER_OK) {
        }
        if (SD_state != MSD_OK) {
            BSP_LCD_DisplayStringAt(20, 130, (uint8_t *)"SD ERASE : FAILED.", LEFT_MODE);
        } else {
            BSP_LCD_DisplayStringAt(20, 130, (uint8_t *)"SD ERASE : OK.", LEFT_MODE);
        }
    }

    BSP_LCD_DisplayStringAt(20, 250, (uint8_t *)"SD can be inserted or removed now", LEFT_MODE);

    while (1) {
        if (BSP_SD_IsDetected() != SD_PRESENT) {
            if (prev_status != SD_NOT_PRESENT) {
                BSP_SD_Init();
                prev_status = SD_NOT_PRESENT;
                BSP_LCD_SetTextColor(LCD_COLOR_RED);
                BSP_LCD_DisplayStringAt(20, BSP_LCD_GetYSize() - 30, (uint8_t *)"SD Not Connected", LEFT_MODE);
            }
        } else if (prev_status != SD_PRESENT) {
            BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
            BSP_LCD_DisplayStringAt(20, BSP_LCD_GetYSize() - 30, (uint8_t *)"SD Connected    ", LEFT_MODE);
            prev_status = SD_PRESENT;
        }

    }
}
