#include "mbed.h"
#include "stm32746g_discovery_sdram.h"

#define BUFFER_SIZE         ((uint32_t)0x0100)
#define WRITE_READ_ADDR     ((uint32_t)0x0800)

void FillBuffer(uint32_t *pBuffer, uint32_t BufferLength, uint32_t Offset);
uint8_t CompareBuffer(uint32_t *pBuffer1, uint32_t *pBuffer2, uint16_t BufferLength);

int main()
{
    uint32_t WriteBuffer[BUFFER_SIZE];
    uint32_t ReadBuffer[BUFFER_SIZE];
    FMC_SDRAM_CommandTypeDef SDRAMCommandStructure;

    printf("\n\nSDRAM demo started\n");

    BSP_SDRAM_Init();

    // Fill the write buffer
    FillBuffer(WriteBuffer, BUFFER_SIZE, 0xA244250F);

    // Write buffer
    BSP_SDRAM_WriteData(SDRAM_DEVICE_ADDR + WRITE_READ_ADDR, WriteBuffer, BUFFER_SIZE);
    printf("Write data DONE\n");

    // Issue self-refresh command to SDRAM device
    SDRAMCommandStructure.CommandMode            = FMC_SDRAM_CMD_SELFREFRESH_MODE;
    SDRAMCommandStructure.CommandTarget          = FMC_SDRAM_CMD_TARGET_BANK2;
    SDRAMCommandStructure.AutoRefreshNumber      = 1;
    SDRAMCommandStructure.ModeRegisterDefinition = 0;
    if (BSP_SDRAM_Sendcmd(&SDRAMCommandStructure) != HAL_OK) {
        error("BSP_SDRAM_Sendcmd FAILED\n");
    }

    // SDRAM memory read back access
    SDRAMCommandStructure.CommandMode = FMC_SDRAM_CMD_NORMAL_MODE;
    if (BSP_SDRAM_Sendcmd(&SDRAMCommandStructure) != HAL_OK) {
        error("BSP_SDRAM_Sendcmd FAILED\n");
    }

    // Read back data from the SDRAM memory
    BSP_SDRAM_ReadData(SDRAM_DEVICE_ADDR + WRITE_READ_ADDR, ReadBuffer, BUFFER_SIZE);
    printf("Read data DONE\n");

    // Checking data integrity
    if (CompareBuffer(WriteBuffer, ReadBuffer, BUFFER_SIZE) != 0) {
        printf("Write/Read buffers are different\n");
    } else {
        printf("Write/Read buffers are identical\n");
    }
}

/**
  * @brief  Fills buffer with user predefined data.
  * @param  pBuffer: pointer on the buffer to fill
  * @param  BufferLength: size of the buffer to fill
  * @param  Value: first value to fill on the buffer
  * @retval None
  */
void FillBuffer(uint32_t *pBuffer, uint32_t BufferLength, uint32_t Value)
{
    uint32_t tmpIndex = 0;

    /* Put in global buffer different values */
    for (tmpIndex = 0; tmpIndex < BufferLength; tmpIndex++) {
        pBuffer[tmpIndex] = tmpIndex + Value;
    }
}

/**
  * @brief  Compares two buffers.
  * @param  pBuffer1, pBuffer2: buffers to be compared.
  * @param  BufferLength: buffer's length
  * @retval 0: pBuffer2 identical to pBuffer1
  *         1: pBuffer2 differs from pBuffer1
  */
uint8_t CompareBuffer(uint32_t *pBuffer1, uint32_t *pBuffer2, uint16_t BufferLength)
{
    while (BufferLength--) {
        if (*pBuffer1 != *pBuffer2) {
            return 1;
        }

        pBuffer1++;
        pBuffer2++;
    }

    return 0;
}
