#include "mbed.h"
#include "stm32746g_discovery_eeprom.h"


#define BUFFER_SIZE         ((uint32_t)32)
#define WRITE_READ_ADDR     ((uint32_t)0x0000)

int main()
{
    //                                      12345678901234567890123456789012
    uint8_t WriteBuffer[BUFFER_SIZE + 1] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ012345";
    uint8_t ReadBuffer[BUFFER_SIZE + 1];
    uint16_t bytes_rd;

    printf("\n\nEEPROM demo started\n");
    printf("NB: you have to connect the RF EEPROM ANT7-M24LR-A to CN1 connector of STM32746G-Discovery board\n");

    // Check initialization
    if (BSP_EEPROM_Init() != EEPROM_OK) {
        error("Initialization FAILED\n");
    } else {
        printf("Initialization PASSED\n");
    }

    // Write buffer
    if (BSP_EEPROM_WriteBuffer(WriteBuffer, WRITE_READ_ADDR, BUFFER_SIZE) != EEPROM_OK) {
        error("Write buffer FAILED\n");
    } else {
        printf("Write buffer PASSED\n");
    }

    // Read buffer
    bytes_rd = BUFFER_SIZE;
    if (BSP_EEPROM_ReadBuffer(ReadBuffer, WRITE_READ_ADDR, &bytes_rd) != EEPROM_OK) {
        error("Read buffer FAILED\n");
    } else {
        ReadBuffer[BUFFER_SIZE] = '\0';
        printf("Read buffer PASSED\n");
        printf("Buffer read = [%s]\n", ReadBuffer);
        printf("Bytes read = %d\n", bytes_rd);
    }
}
