#include "mbed.h"

DigitalOut red_led(LED1);
DigitalOut blue_led(LED2);
DigitalOut orange_led(LED3);
DigitalOut green_led(LED4);

InterruptIn user_button(USER_BUTTON);

void button_pressed()
{
  // LEDs ON
  green_led = 1;
  blue_led = 1;
  orange_led = 1;
}

void button_released()
{
  // LEDs OFF
  green_led = 0;
  blue_led = 0;
  orange_led = 0;  
}

int main() {
    
    user_button.rise(&button_pressed);
    user_button.fall(&button_released);
    
    while(1) {
        red_led = !red_led; // LED toggle
        wait(0.2);
    }

}
