#include "mbed.h"
#include "HiBrightLED.h"

/*
 Example showing how to use the High Brightness LED present
   on the DISCO-F334C8 board.
*/

DigitalOut red_led(LED1);

InterruptIn user_button(USER_BUTTON);

HiBrightLED hib_led;

uint32_t blink;
  
void button_pressed() {
  static uint32_t state = 1;
  blink = 0;
  switch (state) {
    case 0:
      hib_led = 0.0; // OFF
      break;
    case 1:
      hib_led = 0.05; // ON intermediate 1
      break;
    case 2:
      hib_led = 0.2; // ON intermediate 2
      break;
    case 3:
      hib_led = 1.0; // ON MAX
      break;
    case 4:
      hib_led = 0.0; // ON / OFF
      blink = 1;
    default:
      break;
  }
  state++;
  if (state > 4) state = 0;
}

int main()
{
  user_button.fall(&button_pressed);
  
  while(1)
  {
     red_led = !red_led;
     if (blink) {
       hib_led = !hib_led;
     }
     wait(0.3);
  }
}
