/**
  ******************************************************************************
  * @file    MotionFX_Manager.h
  * @author  Central Lab
  * @version V1.1.0
  * @date    20-January-2015
  * @brief   This file includes sensor fusion interface functions
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Licensed under MCD-ST Liberty SW License Agreement V2, (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        http://www.st.com/software_license_agreement_liberty_v2
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */
  
#ifndef _MOTIONFX_MANAGER_H_
#define _MOTIONFX_MANAGER_H_

#ifdef __cplusplus
 extern "C" {
#endif

//#define USE_SENSOR_FUSION_LIB    /** uncomment only if STM32_OSX_MotionFX_Library is linked and licensed **/

#include <cstdio>
#include <stdint.h> 
#include <stdio.h>   
     
#ifdef USE_SENSOR_FUSION_LIB     
#include "osx_motion_fx.h"
#else

#define NUM_AXES    3
#define QNUM_AXES   4
     
typedef struct
{
  float mag[NUM_AXES];  /* calibrated mag [uT]/50 */
  float acc[NUM_AXES];  /* acc [g] */
  float gyro[NUM_AXES]; /* gyro [dps] */
} osxMFX_input;

typedef struct
{
  float rotation_9X[NUM_AXES];            /* 9 axes yaw, pitch and roll */
  float quaternion_9X[QNUM_AXES];         /* 9 axes quaternion */
  float gravity_9X[NUM_AXES];             /* 9 axes device frame gravity */
  float linear_acceleration_9X[NUM_AXES]; /* 9 axes device frame linear acceleration */
  float heading_9X;                       /* 9 axes heading */
  float rotation_6X[NUM_AXES];            /* 6 axes yaw, pitch and roll */
  float quaternion_6X[QNUM_AXES];         /* 6 axes quaternion */
  float gravity_6X[NUM_AXES];             /* 6 axes device frame gravity */
  float linear_acceleration_6X[NUM_AXES]; /* 6 axes device frame linear acceleration */
  float heading_6X;                       /* 6 axes heading */
} osxMFX_output;

typedef struct
{
  signed short magOffX; /* X axis Offset */
  signed short magOffY; /* Y axis Offset */
  signed short magOffZ; /* Z axis Offset */
  float magGainX;       /* X axis Gain  */
  float magGainY;       /* Y axis Gain  */
  float magGainZ;       /* Z axis Gain  */
  float expMagVect;     /* expected magnetic field */
} osxMFX_calibFactor;    
     
unsigned char osx_MotionFX_compass_isCalibrated(void);
void osx_MotionFX_compass_forceReCalibration(void);
void osx_MotionFX_compass_saveAcc(int acc_x, int acc_y, int acc_z);
void osx_MotionFX_compass_saveMag(int mag_x, int mag_y, int mag_z);
int  osx_MotionFX_compass_run(void);
void osx_MotionFX_setCalibrationData(osxMFX_calibFactor* CalibrationData);
void osx_MotionFX_getCalibrationData(osxMFX_calibFactor* CalibrationData);

#endif
     
     
typedef struct {
    int32_t AXIS_X;
    int32_t AXIS_Y;
    int32_t AXIS_Z;
} AxesRaw_t;
     
/* Exported functions ------------------------------------------------------- */

bool MotionFX_manager_init(bool DS3_OnBoard, osxMFX_calibFactor & magOffset);
void MotionFX_manager_run(AxesRaw_t *ACC_Value, AxesRaw_t *GYR_Value, AxesRaw_t *MAG_Value, osxMFX_calibFactor & magOffset);
void MotionFX_manager_start_6X(void);
void MotionFX_manager_stop_6X(void);
void MotionFX_manager_start_9X(void);
void MotionFX_manager_stop_9X(void);

void MotionFX_manager_setDependencies(uint8_t sf, int32_t sensorMask);
void MotionFX_manager_resetDependencies(uint8_t sf, int32_t sensorMask);
uint32_t MotionFX_manager_getDependencies(uint8_t sf);

osxMFX_output* MotionFX_manager_getDataOUT(void);
osxMFX_input* MotionFX_manager_getDataIN(void);

/* Exported constants --------------------------------------------------------*/

/* Delta time mSec for Deltafusion */
#define DELTATIMESENSORFUSION 0.01

#ifdef __cplusplus
}
#endif

#endif //_MOTIONFX_MANAGER_H_

/******************* (C) COPYRIGHT 2015 STMicroelectronics *****END OF FILE****/
