/**
  ******************************************************************************
  * @file    main.h
  * @author  Central Labs / AST
  * @version V0.9.0
  * @date    23-Dec-2015
  * @brief   Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Enable the following define for printout the calibration value 
 read/written from/to Memory */
 
//#define BLUEMSYS_DEBUG_CALIB

#define CUST_CONS_SERV          // Uncomment to enable console service 

//#define CUST_BATT_SERV        // Uncomment to enable battery service /** FIXME tb implemented **/

#define CUST_SENS_SERV          // Uncomment to enable env/MEMS sensor service 
#define DS3_ONBOARD  false      // deft DS3 module NOT plugged onto MEMS exp board
//#define DS3_ONBOARD  true     // Uncomment if DS3 module is plugged onto MEMS exp board

#ifdef USE_SENSOR_FUSION_LIB    // if sensor fusion lib present enable calibration service and quaternion service
#define CUST_CONFIG_SERV        // enable magnetometer calibration service
#define BLUEMSYS_STORE_CALIB_FLASH  // enable flash storage of calibration data
#define CUST_SW_SERV            // enable quaternion service
#endif

/*************** Debug Defines ******************/
/* For enabling connection and notification subscriptions debug */
//#define BLUEMSYS_DEBUG_CONNECTION

/* For enabling trasmission for notified services (except for quaternions) */
//#define BLUEMSYS_DEBUG_NOTIFY_TRAMISSION

#define MAX_I2C_SPEED               400000  
#define NUCLEO_I2C_SHIELDS_SPEED    MAX_I2C_SPEED   // I2C speed in Hz

#define ENV_TIMER       500000      // 500 mSec 
#define CALIB_TIMER      40000      // 40mS
#define MEMS_TIMER       10000      // 10mS

/*************** Don't Change the following defines *************/
/* Calibration mask for Sensor fusion short precision */
#define MASK_CALIB_SENSORFUSION_SHORT 0x00000100
/* Calibration mask for Sensor fusion float precision */
#define MASK_CALIB_SENSORFUSION_FLOAT 0x00000080
/* W2ST command for asking the calibration status */
#define W2ST_COMMAND_CAL_STATUS 0xFF
/* W2ST command for resetting the calibration */
#define W2ST_COMMAND_CAL_RESET  0x00
/* W2ST command for stopping the calibration process */
#define W2ST_COMMAND_CAL_STOP   0x01
/****************************************************************/

#define BLE_DEV_NAME "BlueMbed"
#define BLE_DEV_MAC 0xFF,0x00,0x25,0xAA,0x02,0x04
#define QUAT_FLOAT_UPDATE_MUL_10MS 2
#define ACC_GYRO_MAG_UPDATE_MUL_10MS 10

#define BLUEMSYS_CHECK_CALIBRATION ((uint32_t)0x12345678)

#define BUTTON_TIME 1.0        // 1.0Sec
#define BLUEMSYS_N_BUTTON_PRESS  3  // n push button in BUTTON_TIME

#ifdef BLUEMSYS_STORE_CALIB_FLASH
#define BLUEMSYS_FLASH_ADD ((uint32_t)0x08060000)
#define BLUEMSYS_FLASH_SECTOR FLASH_SECTOR_7
#else /* BLUEMSYS_STORE_CALIB_FLASH */
#if defined (__IAR_SYSTEMS_ICC__)
__no_init uint32_t CalibrationStructureRAM[8];
#elif defined (__CC_ARM) 
uint32_t *CalibrationStructureRAM=(uint32_t *)0x20017FC0;
#elif defined (__GNUC__)
uint32_t CalibrationStructureRAM[8] __attribute__ ((section (".noinit")));
#else
#error "Toolchain not supported"
#endif
#endif /* BLUEMSYS_STORE_CALIB_FLASH */

#define BLE_TX_SKIP_NUM   30
#define BLE_ADVERTISING_INTERVAL    1000
//#define BLE_ADVERTISING_INTERVAL  160 /* 100ms; in multiples of 0.625ms. */

#define BLE_HANDLE_EN_DIS_OFFSET  2  // Offset from En/Dis UUID 2902 to UUID 2803  (Characteristic UUID)
#define BLE_HANDLE_VALUE_OFFSET   1  // Offset from Value UUID xxx to to UUID 2803 (Characteristic UUID) 


typedef enum ConnectionStatus_t {
    DISCONNECTED    =0,
    CONNECTED       =1
}cns_t;

const unsigned   LENGTH_OF_LONG_UUID = 16;
typedef uint16_t ShortUUIDBytes_t;
typedef uint8_t  LongUUIDBytes_t[LENGTH_OF_LONG_UUID];

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif

#endif // ifndef __MAIN_H__
