/**
  ******************************************************************************
  * @file    stm32l4r9i_discovery_gfxmmu_lut.h
  * @author  MCD Application Team
  * @brief   This file contains GFXMMU look-up-table for DSI round LCD.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2017 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __STM32L4R9I_DISCOVERY_GFXMMU_LUT_H
#define __STM32L4R9I_DISCOVERY_GFXMMU_LUT_H

#ifdef __cplusplus
 extern "C" {
#endif

/* GFXMMU look-up table for ARGB8888 */
const uint32_t gfxmmu_lut_config_argb8888[780] = {
    0x00342d01, // GFXMMU_LUT0L
    0x003ffd30, // GFXMMU_LUT0H
    0x00362b01, // GFXMMU_LUT1L
    0x003ffdd0, // GFXMMU_LUT1H
    0x00382901, // GFXMMU_LUT2L
    0x003ffeb0, // GFXMMU_LUT2H
    0x00392701, // GFXMMU_LUT3L
    0x003fffd0, // GFXMMU_LUT3H
    0x003b2601, // GFXMMU_LUT4L
    0x00000110, // GFXMMU_LUT4H
    0x003c2501, // GFXMMU_LUT5L
    0x00000280, // GFXMMU_LUT5H
    0x003d2401, // GFXMMU_LUT6L
    0x00000410, // GFXMMU_LUT6H
    0x003d2301, // GFXMMU_LUT7L
    0x000005c0, // GFXMMU_LUT7H
    0x003e2201, // GFXMMU_LUT8L
    0x00000780, // GFXMMU_LUT8H
    0x003f2101, // GFXMMU_LUT9L
    0x00000960, // GFXMMU_LUT9H
    0x00402101, // GFXMMU_LUT10L
    0x00000b50, // GFXMMU_LUT10H
    0x00402001, // GFXMMU_LUT11L
    0x00000d60, // GFXMMU_LUT11H
    0x00411f01, // GFXMMU_LUT12L
    0x00000f80, // GFXMMU_LUT12H
    0x00421f01, // GFXMMU_LUT13L
    0x000011b0, // GFXMMU_LUT13H
    0x00431e01, // GFXMMU_LUT14L
    0x00001400, // GFXMMU_LUT14H
    0x00431d01, // GFXMMU_LUT15L
    0x00001670, // GFXMMU_LUT15H
    0x00441d01, // GFXMMU_LUT16L
    0x000018e0, // GFXMMU_LUT16H
    0x00441c01, // GFXMMU_LUT17L
    0x00001b70, // GFXMMU_LUT17H
    0x00451c01, // GFXMMU_LUT18L
    0x00001e00, // GFXMMU_LUT18H
    0x00451b01, // GFXMMU_LUT19L
    0x000020b0, // GFXMMU_LUT19H
    0x00461b01, // GFXMMU_LUT20L
    0x00002360, // GFXMMU_LUT20H
    0x00461a01, // GFXMMU_LUT21L
    0x00002630, // GFXMMU_LUT21H
    0x00471a01, // GFXMMU_LUT22L
    0x00002900, // GFXMMU_LUT22H
    0x00471901, // GFXMMU_LUT23L
    0x00002bf0, // GFXMMU_LUT23H
    0x00481901, // GFXMMU_LUT24L
    0x00002ee0, // GFXMMU_LUT24H
    0x00481801, // GFXMMU_LUT25L
    0x000031f0, // GFXMMU_LUT25H
    0x00491801, // GFXMMU_LUT26L
    0x00003500, // GFXMMU_LUT26H
    0x00491701, // GFXMMU_LUT27L
    0x00003830, // GFXMMU_LUT27H
    0x00491701, // GFXMMU_LUT28L
    0x00003b60, // GFXMMU_LUT28H
    0x004a1701, // GFXMMU_LUT29L
    0x00003e90, // GFXMMU_LUT29H
    0x004a1601, // GFXMMU_LUT30L
    0x000041e0, // GFXMMU_LUT30H
    0x004b1601, // GFXMMU_LUT31L
    0x00004530, // GFXMMU_LUT31H
    0x004b1501, // GFXMMU_LUT32L
    0x000048a0, // GFXMMU_LUT32H
    0x004b1501, // GFXMMU_LUT33L
    0x00004c10, // GFXMMU_LUT33H
    0x004c1501, // GFXMMU_LUT34L
    0x00004f80, // GFXMMU_LUT34H
    0x004c1401, // GFXMMU_LUT35L
    0x00005310, // GFXMMU_LUT35H
    0x004c1401, // GFXMMU_LUT36L
    0x000056a0, // GFXMMU_LUT36H
    0x004d1401, // GFXMMU_LUT37L
    0x00005a30, // GFXMMU_LUT37H
    0x004d1301, // GFXMMU_LUT38L
    0x00005de0, // GFXMMU_LUT38H
    0x004e1301, // GFXMMU_LUT39L
    0x00006190, // GFXMMU_LUT39H
    0x004e1301, // GFXMMU_LUT40L
    0x00006550, // GFXMMU_LUT40H
    0x004e1201, // GFXMMU_LUT41L
    0x00006920, // GFXMMU_LUT41H
    0x004e1201, // GFXMMU_LUT42L
    0x00006cf0, // GFXMMU_LUT42H
    0x004f1201, // GFXMMU_LUT43L
    0x000070c0, // GFXMMU_LUT43H
    0x004f1101, // GFXMMU_LUT44L
    0x000074b0, // GFXMMU_LUT44H
    0x004f1101, // GFXMMU_LUT45L
    0x000078a0, // GFXMMU_LUT45H
    0x00501101, // GFXMMU_LUT46L
    0x00007c90, // GFXMMU_LUT46H
    0x00501101, // GFXMMU_LUT47L
    0x00008090, // GFXMMU_LUT47H
    0x00501001, // GFXMMU_LUT48L
    0x000084a0, // GFXMMU_LUT48H
    0x00511001, // GFXMMU_LUT49L
    0x000088b0, // GFXMMU_LUT49H
    0x00511001, // GFXMMU_LUT50L
    0x00008cd0, // GFXMMU_LUT50H
    0x00510f01, // GFXMMU_LUT51L
    0x00009100, // GFXMMU_LUT51H
    0x00510f01, // GFXMMU_LUT52L
    0x00009530, // GFXMMU_LUT52H
    0x00520f01, // GFXMMU_LUT53L
    0x00009960, // GFXMMU_LUT53H
    0x00520f01, // GFXMMU_LUT54L
    0x00009da0, // GFXMMU_LUT54H
    0x00520e01, // GFXMMU_LUT55L
    0x0000a1f0, // GFXMMU_LUT55H
    0x00520e01, // GFXMMU_LUT56L
    0x0000a640, // GFXMMU_LUT56H
    0x00530e01, // GFXMMU_LUT57L
    0x0000aa90, // GFXMMU_LUT57H
    0x00530e01, // GFXMMU_LUT58L
    0x0000aef0, // GFXMMU_LUT58H
    0x00530d01, // GFXMMU_LUT59L
    0x0000b360, // GFXMMU_LUT59H
    0x00530d01, // GFXMMU_LUT60L
    0x0000b7d0, // GFXMMU_LUT60H
    0x00540d01, // GFXMMU_LUT61L
    0x0000bc40, // GFXMMU_LUT61H
    0x00540d01, // GFXMMU_LUT62L
    0x0000c0c0, // GFXMMU_LUT62H
    0x00540c01, // GFXMMU_LUT63L
    0x0000c550, // GFXMMU_LUT63H
    0x00540c01, // GFXMMU_LUT64L
    0x0000c9e0, // GFXMMU_LUT64H
    0x00550c01, // GFXMMU_LUT65L
    0x0000ce70, // GFXMMU_LUT65H
    0x00550c01, // GFXMMU_LUT66L
    0x0000d310, // GFXMMU_LUT66H
    0x00550c01, // GFXMMU_LUT67L
    0x0000d7b0, // GFXMMU_LUT67H
    0x00550b01, // GFXMMU_LUT68L
    0x0000dc60, // GFXMMU_LUT68H
    0x00550b01, // GFXMMU_LUT69L
    0x0000e110, // GFXMMU_LUT69H
    0x00560b01, // GFXMMU_LUT70L
    0x0000e5c0, // GFXMMU_LUT70H
    0x00560b01, // GFXMMU_LUT71L
    0x0000ea80, // GFXMMU_LUT71H
    0x00560b01, // GFXMMU_LUT72L
    0x0000ef40, // GFXMMU_LUT72H
    0x00560a01, // GFXMMU_LUT73L
    0x0000f410, // GFXMMU_LUT73H
    0x00560a01, // GFXMMU_LUT74L
    0x0000f8e0, // GFXMMU_LUT74H
    0x00570a01, // GFXMMU_LUT75L
    0x0000fdb0, // GFXMMU_LUT75H
    0x00570a01, // GFXMMU_LUT76L
    0x00010290, // GFXMMU_LUT76H
    0x00570901, // GFXMMU_LUT77L
    0x00010780, // GFXMMU_LUT77H
    0x00570901, // GFXMMU_LUT78L
    0x00010c70, // GFXMMU_LUT78H
    0x00570901, // GFXMMU_LUT79L
    0x00011160, // GFXMMU_LUT79H
    0x00580901, // GFXMMU_LUT80L
    0x00011650, // GFXMMU_LUT80H
    0x00580901, // GFXMMU_LUT81L
    0x00011b50, // GFXMMU_LUT81H
    0x00580901, // GFXMMU_LUT82L
    0x00012050, // GFXMMU_LUT82H
    0x00580801, // GFXMMU_LUT83L
    0x00012560, // GFXMMU_LUT83H
    0x00580801, // GFXMMU_LUT84L
    0x00012a70, // GFXMMU_LUT84H
    0x00580801, // GFXMMU_LUT85L
    0x00012f80, // GFXMMU_LUT85H
    0x00590801, // GFXMMU_LUT86L
    0x00013490, // GFXMMU_LUT86H
    0x00590801, // GFXMMU_LUT87L
    0x000139b0, // GFXMMU_LUT87H
    0x00590801, // GFXMMU_LUT88L
    0x00013ed0, // GFXMMU_LUT88H
    0x00590701, // GFXMMU_LUT89L
    0x00014400, // GFXMMU_LUT89H
    0x00590701, // GFXMMU_LUT90L
    0x00014930, // GFXMMU_LUT90H
    0x00590701, // GFXMMU_LUT91L
    0x00014e60, // GFXMMU_LUT91H
    0x005a0701, // GFXMMU_LUT92L
    0x00015390, // GFXMMU_LUT92H
    0x005a0701, // GFXMMU_LUT93L
    0x000158d0, // GFXMMU_LUT93H
    0x005a0701, // GFXMMU_LUT94L
    0x00015e10, // GFXMMU_LUT94H
    0x005a0601, // GFXMMU_LUT95L
    0x00016360, // GFXMMU_LUT95H
    0x005a0601, // GFXMMU_LUT96L
    0x000168b0, // GFXMMU_LUT96H
    0x005a0601, // GFXMMU_LUT97L
    0x00016e00, // GFXMMU_LUT97H
    0x005a0601, // GFXMMU_LUT98L
    0x00017350, // GFXMMU_LUT98H
    0x005b0601, // GFXMMU_LUT99L
    0x000178a0, // GFXMMU_LUT99H
    0x005b0601, // GFXMMU_LUT100L
    0x00017e00, // GFXMMU_LUT100H
    0x005b0601, // GFXMMU_LUT101L
    0x00018360, // GFXMMU_LUT101H
    0x005b0601, // GFXMMU_LUT102L
    0x000188c0, // GFXMMU_LUT102H
    0x005b0501, // GFXMMU_LUT103L
    0x00018e30, // GFXMMU_LUT103H
    0x005b0501, // GFXMMU_LUT104L
    0x000193a0, // GFXMMU_LUT104H
    0x005b0501, // GFXMMU_LUT105L
    0x00019910, // GFXMMU_LUT105H
    0x005c0501, // GFXMMU_LUT106L
    0x00019e80, // GFXMMU_LUT106H
    0x005c0501, // GFXMMU_LUT107L
    0x0001a400, // GFXMMU_LUT107H
    0x005c0501, // GFXMMU_LUT108L
    0x0001a980, // GFXMMU_LUT108H
    0x005c0501, // GFXMMU_LUT109L
    0x0001af00, // GFXMMU_LUT109H
    0x005c0401, // GFXMMU_LUT110L
    0x0001b490, // GFXMMU_LUT110H
    0x005c0401, // GFXMMU_LUT111L
    0x0001ba20, // GFXMMU_LUT111H
    0x005c0401, // GFXMMU_LUT112L
    0x0001bfb0, // GFXMMU_LUT112H
    0x005c0401, // GFXMMU_LUT113L
    0x0001c540, // GFXMMU_LUT113H
    0x005d0401, // GFXMMU_LUT114L
    0x0001cad0, // GFXMMU_LUT114H
    0x005d0401, // GFXMMU_LUT115L
    0x0001d070, // GFXMMU_LUT115H
    0x005d0401, // GFXMMU_LUT116L
    0x0001d610, // GFXMMU_LUT116H
    0x005d0401, // GFXMMU_LUT117L
    0x0001dbb0, // GFXMMU_LUT117H
    0x005d0401, // GFXMMU_LUT118L
    0x0001e150, // GFXMMU_LUT118H
    0x005d0301, // GFXMMU_LUT119L
    0x0001e700, // GFXMMU_LUT119H
    0x005d0301, // GFXMMU_LUT120L
    0x0001ecb0, // GFXMMU_LUT120H
    0x005d0301, // GFXMMU_LUT121L
    0x0001f260, // GFXMMU_LUT121H
    0x005d0301, // GFXMMU_LUT122L
    0x0001f810, // GFXMMU_LUT122H
    0x005d0301, // GFXMMU_LUT123L
    0x0001fdc0, // GFXMMU_LUT123H
    0x005e0301, // GFXMMU_LUT124L
    0x00020370, // GFXMMU_LUT124H
    0x005e0301, // GFXMMU_LUT125L
    0x00020930, // GFXMMU_LUT125H
    0x005e0301, // GFXMMU_LUT126L
    0x00020ef0, // GFXMMU_LUT126H
    0x005e0301, // GFXMMU_LUT127L
    0x000214b0, // GFXMMU_LUT127H
    0x005e0301, // GFXMMU_LUT128L
    0x00021a70, // GFXMMU_LUT128H
    0x005e0301, // GFXMMU_LUT129L
    0x00022030, // GFXMMU_LUT129H
    0x005e0201, // GFXMMU_LUT130L
    0x00022600, // GFXMMU_LUT130H
    0x005e0201, // GFXMMU_LUT131L
    0x00022bd0, // GFXMMU_LUT131H
    0x005e0201, // GFXMMU_LUT132L
    0x000231a0, // GFXMMU_LUT132H
    0x005e0201, // GFXMMU_LUT133L
    0x00023770, // GFXMMU_LUT133H
    0x005e0201, // GFXMMU_LUT134L
    0x00023d40, // GFXMMU_LUT134H
    0x005f0201, // GFXMMU_LUT135L
    0x00024310, // GFXMMU_LUT135H
    0x005f0201, // GFXMMU_LUT136L
    0x000248f0, // GFXMMU_LUT136H
    0x005f0201, // GFXMMU_LUT137L
    0x00024ed0, // GFXMMU_LUT137H
    0x005f0201, // GFXMMU_LUT138L
    0x000254b0, // GFXMMU_LUT138H
    0x005f0201, // GFXMMU_LUT139L
    0x00025a90, // GFXMMU_LUT139H
    0x005f0201, // GFXMMU_LUT140L
    0x00026070, // GFXMMU_LUT140H
    0x005f0201, // GFXMMU_LUT141L
    0x00026650, // GFXMMU_LUT141H
    0x005f0101, // GFXMMU_LUT142L
    0x00026c40, // GFXMMU_LUT142H
    0x005f0101, // GFXMMU_LUT143L
    0x00027230, // GFXMMU_LUT143H
    0x005f0101, // GFXMMU_LUT144L
    0x00027820, // GFXMMU_LUT144H
    0x005f0101, // GFXMMU_LUT145L
    0x00027e10, // GFXMMU_LUT145H
    0x005f0101, // GFXMMU_LUT146L
    0x00028400, // GFXMMU_LUT146H
    0x005f0101, // GFXMMU_LUT147L
    0x000289f0, // GFXMMU_LUT147H
    0x005f0101, // GFXMMU_LUT148L
    0x00028fe0, // GFXMMU_LUT148H
    0x00600101, // GFXMMU_LUT149L
    0x000295d0, // GFXMMU_LUT149H
    0x00600101, // GFXMMU_LUT150L
    0x00029bd0, // GFXMMU_LUT150H
    0x00600101, // GFXMMU_LUT151L
    0x0002a1d0, // GFXMMU_LUT151H
    0x00600101, // GFXMMU_LUT152L
    0x0002a7d0, // GFXMMU_LUT152H
    0x00600101, // GFXMMU_LUT153L
    0x0002add0, // GFXMMU_LUT153H
    0x00600101, // GFXMMU_LUT154L
    0x0002b3d0, // GFXMMU_LUT154H
    0x00600101, // GFXMMU_LUT155L
    0x0002b9d0, // GFXMMU_LUT155H
    0x00600101, // GFXMMU_LUT156L
    0x0002bfd0, // GFXMMU_LUT156H
    0x00600101, // GFXMMU_LUT157L
    0x0002c5d0, // GFXMMU_LUT157H
    0x00600001, // GFXMMU_LUT158L
    0x0002cbe0, // GFXMMU_LUT158H
    0x00600001, // GFXMMU_LUT159L
    0x0002d1f0, // GFXMMU_LUT159H
    0x00600001, // GFXMMU_LUT160L
    0x0002d800, // GFXMMU_LUT160H
    0x00600001, // GFXMMU_LUT161L
    0x0002de10, // GFXMMU_LUT161H
    0x00600001, // GFXMMU_LUT162L
    0x0002e420, // GFXMMU_LUT162H
    0x00600001, // GFXMMU_LUT163L
    0x0002ea30, // GFXMMU_LUT163H
    0x00600001, // GFXMMU_LUT164L
    0x0002f040, // GFXMMU_LUT164H
    0x00600001, // GFXMMU_LUT165L
    0x0002f650, // GFXMMU_LUT165H
    0x00600001, // GFXMMU_LUT166L
    0x0002fc60, // GFXMMU_LUT166H
    0x00600001, // GFXMMU_LUT167L
    0x00030270, // GFXMMU_LUT167H
    0x00600001, // GFXMMU_LUT168L
    0x00030880, // GFXMMU_LUT168H
    0x00600001, // GFXMMU_LUT169L
    0x00030e90, // GFXMMU_LUT169H
    0x00600001, // GFXMMU_LUT170L
    0x000314a0, // GFXMMU_LUT170H
    0x00600001, // GFXMMU_LUT171L
    0x00031ab0, // GFXMMU_LUT171H
    0x00610001, // GFXMMU_LUT172L
    0x000320c0, // GFXMMU_LUT172H
    0x00610001, // GFXMMU_LUT173L
    0x000326e0, // GFXMMU_LUT173H
    0x00610001, // GFXMMU_LUT174L
    0x00032d00, // GFXMMU_LUT174H
    0x00610001, // GFXMMU_LUT175L
    0x00033320, // GFXMMU_LUT175H
    0x00610001, // GFXMMU_LUT176L
    0x00033940, // GFXMMU_LUT176H
    0x00610001, // GFXMMU_LUT177L
    0x00033f60, // GFXMMU_LUT177H
    0x00610001, // GFXMMU_LUT178L
    0x00034580, // GFXMMU_LUT178H
    0x00610001, // GFXMMU_LUT179L
    0x00034ba0, // GFXMMU_LUT179H
    0x00610001, // GFXMMU_LUT180L
    0x000351c0, // GFXMMU_LUT180H
    0x00610001, // GFXMMU_LUT181L
    0x000357e0, // GFXMMU_LUT181H
    0x00610001, // GFXMMU_LUT182L
    0x00035e00, // GFXMMU_LUT182H
    0x00610001, // GFXMMU_LUT183L
    0x00036420, // GFXMMU_LUT183H
    0x00610001, // GFXMMU_LUT184L
    0x00036a40, // GFXMMU_LUT184H
    0x00610001, // GFXMMU_LUT185L
    0x00037060, // GFXMMU_LUT185H
    0x00610001, // GFXMMU_LUT186L
    0x00037680, // GFXMMU_LUT186H
    0x00610001, // GFXMMU_LUT187L
    0x00037ca0, // GFXMMU_LUT187H
    0x00610001, // GFXMMU_LUT188L
    0x000382c0, // GFXMMU_LUT188H
    0x00610001, // GFXMMU_LUT189L
    0x000388e0, // GFXMMU_LUT189H
    0x00610001, // GFXMMU_LUT190L
    0x00038f00, // GFXMMU_LUT190H
    0x00610001, // GFXMMU_LUT191L
    0x00039520, // GFXMMU_LUT191H
    0x00610001, // GFXMMU_LUT192L
    0x00039b40, // GFXMMU_LUT192H
    0x00610001, // GFXMMU_LUT193L
    0x0003a160, // GFXMMU_LUT193H
    0x00610001, // GFXMMU_LUT194L
    0x0003a780, // GFXMMU_LUT194H
    0x00610001, // GFXMMU_LUT195L
    0x0003ada0, // GFXMMU_LUT195H
    0x00610001, // GFXMMU_LUT196L
    0x0003b3c0, // GFXMMU_LUT196H
    0x00610001, // GFXMMU_LUT197L
    0x0003b9e0, // GFXMMU_LUT197H
    0x00610001, // GFXMMU_LUT198L
    0x0003c000, // GFXMMU_LUT198H
    0x00610001, // GFXMMU_LUT199L
    0x0003c620, // GFXMMU_LUT199H
    0x00610001, // GFXMMU_LUT200L
    0x0003cc40, // GFXMMU_LUT200H
    0x00610001, // GFXMMU_LUT201L
    0x0003d260, // GFXMMU_LUT201H
    0x00610001, // GFXMMU_LUT202L
    0x0003d880, // GFXMMU_LUT202H
    0x00610001, // GFXMMU_LUT203L
    0x0003dea0, // GFXMMU_LUT203H
    0x00610001, // GFXMMU_LUT204L
    0x0003e4c0, // GFXMMU_LUT204H
    0x00610001, // GFXMMU_LUT205L
    0x0003eae0, // GFXMMU_LUT205H
    0x00610001, // GFXMMU_LUT206L
    0x0003f100, // GFXMMU_LUT206H
    0x00610001, // GFXMMU_LUT207L
    0x0003f720, // GFXMMU_LUT207H
    0x00610001, // GFXMMU_LUT208L
    0x0003fd40, // GFXMMU_LUT208H
    0x00610001, // GFXMMU_LUT209L
    0x00040360, // GFXMMU_LUT209H
    0x00610001, // GFXMMU_LUT210L
    0x00040980, // GFXMMU_LUT210H
    0x00610001, // GFXMMU_LUT211L
    0x00040fa0, // GFXMMU_LUT211H
    0x00610001, // GFXMMU_LUT212L
    0x000415c0, // GFXMMU_LUT212H
    0x00610001, // GFXMMU_LUT213L
    0x00041be0, // GFXMMU_LUT213H
    0x00610001, // GFXMMU_LUT214L
    0x00042200, // GFXMMU_LUT214H
    0x00610001, // GFXMMU_LUT215L
    0x00042820, // GFXMMU_LUT215H
    0x00610001, // GFXMMU_LUT216L
    0x00042e40, // GFXMMU_LUT216H
    0x00610001, // GFXMMU_LUT217L
    0x00043460, // GFXMMU_LUT217H
    0x00600001, // GFXMMU_LUT218L
    0x00043a80, // GFXMMU_LUT218H
    0x00600001, // GFXMMU_LUT219L
    0x00044090, // GFXMMU_LUT219H
    0x00600001, // GFXMMU_LUT220L
    0x000446a0, // GFXMMU_LUT220H
    0x00600001, // GFXMMU_LUT221L
    0x00044cb0, // GFXMMU_LUT221H
    0x00600001, // GFXMMU_LUT222L
    0x000452c0, // GFXMMU_LUT222H
    0x00600001, // GFXMMU_LUT223L
    0x000458d0, // GFXMMU_LUT223H
    0x00600001, // GFXMMU_LUT224L
    0x00045ee0, // GFXMMU_LUT224H
    0x00600001, // GFXMMU_LUT225L
    0x000464f0, // GFXMMU_LUT225H
    0x00600001, // GFXMMU_LUT226L
    0x00046b00, // GFXMMU_LUT226H
    0x00600001, // GFXMMU_LUT227L
    0x00047110, // GFXMMU_LUT227H
    0x00600001, // GFXMMU_LUT228L
    0x00047720, // GFXMMU_LUT228H
    0x00600001, // GFXMMU_LUT229L
    0x00047d30, // GFXMMU_LUT229H
    0x00600001, // GFXMMU_LUT230L
    0x00048340, // GFXMMU_LUT230H
    0x00600001, // GFXMMU_LUT231L
    0x00048950, // GFXMMU_LUT231H
    0x00600101, // GFXMMU_LUT232L
    0x00048f50, // GFXMMU_LUT232H
    0x00600101, // GFXMMU_LUT233L
    0x00049550, // GFXMMU_LUT233H
    0x00600101, // GFXMMU_LUT234L
    0x00049b50, // GFXMMU_LUT234H
    0x00600101, // GFXMMU_LUT235L
    0x0004a150, // GFXMMU_LUT235H
    0x00600101, // GFXMMU_LUT236L
    0x0004a750, // GFXMMU_LUT236H
    0x00600101, // GFXMMU_LUT237L
    0x0004ad50, // GFXMMU_LUT237H
    0x00600101, // GFXMMU_LUT238L
    0x0004b350, // GFXMMU_LUT238H
    0x00600101, // GFXMMU_LUT239L
    0x0004b950, // GFXMMU_LUT239H
    0x00600101, // GFXMMU_LUT240L
    0x0004bf50, // GFXMMU_LUT240H
    0x005f0101, // GFXMMU_LUT241L
    0x0004c550, // GFXMMU_LUT241H
    0x005f0101, // GFXMMU_LUT242L
    0x0004cb40, // GFXMMU_LUT242H
    0x005f0101, // GFXMMU_LUT243L
    0x0004d130, // GFXMMU_LUT243H
    0x005f0101, // GFXMMU_LUT244L
    0x0004d720, // GFXMMU_LUT244H
    0x005f0101, // GFXMMU_LUT245L
    0x0004dd10, // GFXMMU_LUT245H
    0x005f0101, // GFXMMU_LUT246L
    0x0004e300, // GFXMMU_LUT246H
    0x005f0101, // GFXMMU_LUT247L
    0x0004e8f0, // GFXMMU_LUT247H
    0x005f0201, // GFXMMU_LUT248L
    0x0004eed0, // GFXMMU_LUT248H
    0x005f0201, // GFXMMU_LUT249L
    0x0004f4b0, // GFXMMU_LUT249H
    0x005f0201, // GFXMMU_LUT250L
    0x0004fa90, // GFXMMU_LUT250H
    0x005f0201, // GFXMMU_LUT251L
    0x00050070, // GFXMMU_LUT251H
    0x005f0201, // GFXMMU_LUT252L
    0x00050650, // GFXMMU_LUT252H
    0x005f0201, // GFXMMU_LUT253L
    0x00050c30, // GFXMMU_LUT253H
    0x005f0201, // GFXMMU_LUT254L
    0x00051210, // GFXMMU_LUT254H
    0x005e0201, // GFXMMU_LUT255L
    0x000517f0, // GFXMMU_LUT255H
    0x005e0201, // GFXMMU_LUT256L
    0x00051dc0, // GFXMMU_LUT256H
    0x005e0201, // GFXMMU_LUT257L
    0x00052390, // GFXMMU_LUT257H
    0x005e0201, // GFXMMU_LUT258L
    0x00052960, // GFXMMU_LUT258H
    0x005e0201, // GFXMMU_LUT259L
    0x00052f30, // GFXMMU_LUT259H
    0x005e0301, // GFXMMU_LUT260L
    0x000534f0, // GFXMMU_LUT260H
    0x005e0301, // GFXMMU_LUT261L
    0x00053ab0, // GFXMMU_LUT261H
    0x005e0301, // GFXMMU_LUT262L
    0x00054070, // GFXMMU_LUT262H
    0x005e0301, // GFXMMU_LUT263L
    0x00054630, // GFXMMU_LUT263H
    0x005e0301, // GFXMMU_LUT264L
    0x00054bf0, // GFXMMU_LUT264H
    0x005e0301, // GFXMMU_LUT265L
    0x000551b0, // GFXMMU_LUT265H
    0x005d0301, // GFXMMU_LUT266L
    0x00055770, // GFXMMU_LUT266H
    0x005d0301, // GFXMMU_LUT267L
    0x00055d20, // GFXMMU_LUT267H
    0x005d0301, // GFXMMU_LUT268L
    0x000562d0, // GFXMMU_LUT268H
    0x005d0301, // GFXMMU_LUT269L
    0x00056880, // GFXMMU_LUT269H
    0x005d0301, // GFXMMU_LUT270L
    0x00056e30, // GFXMMU_LUT270H
    0x005d0401, // GFXMMU_LUT271L
    0x000573d0, // GFXMMU_LUT271H
    0x005d0401, // GFXMMU_LUT272L
    0x00057970, // GFXMMU_LUT272H
    0x005d0401, // GFXMMU_LUT273L
    0x00057f10, // GFXMMU_LUT273H
    0x005d0401, // GFXMMU_LUT274L
    0x000584b0, // GFXMMU_LUT274H
    0x005d0401, // GFXMMU_LUT275L
    0x00058a50, // GFXMMU_LUT275H
    0x005c0401, // GFXMMU_LUT276L
    0x00058ff0, // GFXMMU_LUT276H
    0x005c0401, // GFXMMU_LUT277L
    0x00059580, // GFXMMU_LUT277H
    0x005c0401, // GFXMMU_LUT278L
    0x00059b10, // GFXMMU_LUT278H
    0x005c0401, // GFXMMU_LUT279L
    0x0005a0a0, // GFXMMU_LUT279H
    0x005c0501, // GFXMMU_LUT280L
    0x0005a620, // GFXMMU_LUT280H
    0x005c0501, // GFXMMU_LUT281L
    0x0005aba0, // GFXMMU_LUT281H
    0x005c0501, // GFXMMU_LUT282L
    0x0005b120, // GFXMMU_LUT282H
    0x005c0501, // GFXMMU_LUT283L
    0x0005b6a0, // GFXMMU_LUT283H
    0x005b0501, // GFXMMU_LUT284L
    0x0005bc20, // GFXMMU_LUT284H
    0x005b0501, // GFXMMU_LUT285L
    0x0005c190, // GFXMMU_LUT285H
    0x005b0501, // GFXMMU_LUT286L
    0x0005c700, // GFXMMU_LUT286H
    0x005b0601, // GFXMMU_LUT287L
    0x0005cc60, // GFXMMU_LUT287H
    0x005b0601, // GFXMMU_LUT288L
    0x0005d1c0, // GFXMMU_LUT288H
    0x005b0601, // GFXMMU_LUT289L
    0x0005d720, // GFXMMU_LUT289H
    0x005b0601, // GFXMMU_LUT290L
    0x0005dc80, // GFXMMU_LUT290H
    0x005a0601, // GFXMMU_LUT291L
    0x0005e1e0, // GFXMMU_LUT291H
    0x005a0601, // GFXMMU_LUT292L
    0x0005e730, // GFXMMU_LUT292H
    0x005a0601, // GFXMMU_LUT293L
    0x0005ec80, // GFXMMU_LUT293H
    0x005a0601, // GFXMMU_LUT294L
    0x0005f1d0, // GFXMMU_LUT294H
    0x005a0701, // GFXMMU_LUT295L
    0x0005f710, // GFXMMU_LUT295H
    0x005a0701, // GFXMMU_LUT296L
    0x0005fc50, // GFXMMU_LUT296H
    0x005a0701, // GFXMMU_LUT297L
    0x00060190, // GFXMMU_LUT297H
    0x00590701, // GFXMMU_LUT298L
    0x000606d0, // GFXMMU_LUT298H
    0x00590701, // GFXMMU_LUT299L
    0x00060c00, // GFXMMU_LUT299H
    0x00590701, // GFXMMU_LUT300L
    0x00061130, // GFXMMU_LUT300H
    0x00590801, // GFXMMU_LUT301L
    0x00061650, // GFXMMU_LUT301H
    0x00590801, // GFXMMU_LUT302L
    0x00061b70, // GFXMMU_LUT302H
    0x00590801, // GFXMMU_LUT303L
    0x00062090, // GFXMMU_LUT303H
    0x00580801, // GFXMMU_LUT304L
    0x000625b0, // GFXMMU_LUT304H
    0x00580801, // GFXMMU_LUT305L
    0x00062ac0, // GFXMMU_LUT305H
    0x00580801, // GFXMMU_LUT306L
    0x00062fd0, // GFXMMU_LUT306H
    0x00580901, // GFXMMU_LUT307L
    0x000634d0, // GFXMMU_LUT307H
    0x00580901, // GFXMMU_LUT308L
    0x000639d0, // GFXMMU_LUT308H
    0x00580901, // GFXMMU_LUT309L
    0x00063ed0, // GFXMMU_LUT309H
    0x00570901, // GFXMMU_LUT310L
    0x000643d0, // GFXMMU_LUT310H
    0x00570901, // GFXMMU_LUT311L
    0x000648c0, // GFXMMU_LUT311H
    0x00570901, // GFXMMU_LUT312L
    0x00064db0, // GFXMMU_LUT312H
    0x00570a01, // GFXMMU_LUT313L
    0x00065290, // GFXMMU_LUT313H
    0x00570a01, // GFXMMU_LUT314L
    0x00065770, // GFXMMU_LUT314H
    0x00560a01, // GFXMMU_LUT315L
    0x00065c50, // GFXMMU_LUT315H
    0x00560a01, // GFXMMU_LUT316L
    0x00066120, // GFXMMU_LUT316H
    0x00560b01, // GFXMMU_LUT317L
    0x000665e0, // GFXMMU_LUT317H
    0x00560b01, // GFXMMU_LUT318L
    0x00066aa0, // GFXMMU_LUT318H
    0x00560b01, // GFXMMU_LUT319L
    0x00066f60, // GFXMMU_LUT319H
    0x00550b01, // GFXMMU_LUT320L
    0x00067420, // GFXMMU_LUT320H
    0x00550b01, // GFXMMU_LUT321L
    0x000678d0, // GFXMMU_LUT321H
    0x00550c01, // GFXMMU_LUT322L
    0x00067d70, // GFXMMU_LUT322H
    0x00550c01, // GFXMMU_LUT323L
    0x00068210, // GFXMMU_LUT323H
    0x00550c01, // GFXMMU_LUT324L
    0x000686b0, // GFXMMU_LUT324H
    0x00540c01, // GFXMMU_LUT325L
    0x00068b50, // GFXMMU_LUT325H
    0x00540c01, // GFXMMU_LUT326L
    0x00068fe0, // GFXMMU_LUT326H
    0x00540d01, // GFXMMU_LUT327L
    0x00069460, // GFXMMU_LUT327H
    0x00540d01, // GFXMMU_LUT328L
    0x000698e0, // GFXMMU_LUT328H
    0x00530d01, // GFXMMU_LUT329L
    0x00069d60, // GFXMMU_LUT329H
    0x00530d01, // GFXMMU_LUT330L
    0x0006a1d0, // GFXMMU_LUT330H
    0x00530e01, // GFXMMU_LUT331L
    0x0006a630, // GFXMMU_LUT331H
    0x00530e01, // GFXMMU_LUT332L
    0x0006aa90, // GFXMMU_LUT332H
    0x00520e01, // GFXMMU_LUT333L
    0x0006aef0, // GFXMMU_LUT333H
    0x00520e01, // GFXMMU_LUT334L
    0x0006b340, // GFXMMU_LUT334H
    0x00520f01, // GFXMMU_LUT335L
    0x0006b780, // GFXMMU_LUT335H
    0x00520f01, // GFXMMU_LUT336L
    0x0006bbc0, // GFXMMU_LUT336H
    0x00510f01, // GFXMMU_LUT337L
    0x0006c000, // GFXMMU_LUT337H
    0x00510f01, // GFXMMU_LUT338L
    0x0006c430, // GFXMMU_LUT338H
    0x00511001, // GFXMMU_LUT339L
    0x0006c850, // GFXMMU_LUT339H
    0x00511001, // GFXMMU_LUT340L
    0x0006cc70, // GFXMMU_LUT340H
    0x00501001, // GFXMMU_LUT341L
    0x0006d090, // GFXMMU_LUT341H
    0x00501101, // GFXMMU_LUT342L
    0x0006d490, // GFXMMU_LUT342H
    0x00501101, // GFXMMU_LUT343L
    0x0006d890, // GFXMMU_LUT343H
    0x004f1101, // GFXMMU_LUT344L
    0x0006dc90, // GFXMMU_LUT344H
    0x004f1101, // GFXMMU_LUT345L
    0x0006e080, // GFXMMU_LUT345H
    0x004f1201, // GFXMMU_LUT346L
    0x0006e460, // GFXMMU_LUT346H
    0x004e1201, // GFXMMU_LUT347L
    0x0006e840, // GFXMMU_LUT347H
    0x004e1201, // GFXMMU_LUT348L
    0x0006ec10, // GFXMMU_LUT348H
    0x004e1301, // GFXMMU_LUT349L
    0x0006efd0, // GFXMMU_LUT349H
    0x004e1301, // GFXMMU_LUT350L
    0x0006f390, // GFXMMU_LUT350H
    0x004d1301, // GFXMMU_LUT351L
    0x0006f750, // GFXMMU_LUT351H
    0x004d1401, // GFXMMU_LUT352L
    0x0006faf0, // GFXMMU_LUT352H
    0x004c1401, // GFXMMU_LUT353L
    0x0006fe90, // GFXMMU_LUT353H
    0x004c1401, // GFXMMU_LUT354L
    0x00070220, // GFXMMU_LUT354H
    0x004c1501, // GFXMMU_LUT355L
    0x000705a0, // GFXMMU_LUT355H
    0x004b1501, // GFXMMU_LUT356L
    0x00070920, // GFXMMU_LUT356H
    0x004b1501, // GFXMMU_LUT357L
    0x00070c90, // GFXMMU_LUT357H
    0x004b1601, // GFXMMU_LUT358L
    0x00070ff0, // GFXMMU_LUT358H
    0x004a1601, // GFXMMU_LUT359L
    0x00071350, // GFXMMU_LUT359H
    0x004a1701, // GFXMMU_LUT360L
    0x00071690, // GFXMMU_LUT360H
    0x00491701, // GFXMMU_LUT361L
    0x000719d0, // GFXMMU_LUT361H
    0x00491701, // GFXMMU_LUT362L
    0x00071d00, // GFXMMU_LUT362H
    0x00491801, // GFXMMU_LUT363L
    0x00072020, // GFXMMU_LUT363H
    0x00481801, // GFXMMU_LUT364L
    0x00072340, // GFXMMU_LUT364H
    0x00481901, // GFXMMU_LUT365L
    0x00072640, // GFXMMU_LUT365H
    0x00471901, // GFXMMU_LUT366L
    0x00072940, // GFXMMU_LUT366H
    0x00471a01, // GFXMMU_LUT367L
    0x00072c20, // GFXMMU_LUT367H
    0x00461a01, // GFXMMU_LUT368L
    0x00072f00, // GFXMMU_LUT368H
    0x00461b01, // GFXMMU_LUT369L
    0x000731c0, // GFXMMU_LUT369H
    0x00451b01, // GFXMMU_LUT370L
    0x00073480, // GFXMMU_LUT370H
    0x00451c01, // GFXMMU_LUT371L
    0x00073720, // GFXMMU_LUT371H
    0x00441c01, // GFXMMU_LUT372L
    0x000739c0, // GFXMMU_LUT372H
    0x00441d01, // GFXMMU_LUT373L
    0x00073c40, // GFXMMU_LUT373H
    0x00431d01, // GFXMMU_LUT374L
    0x00073ec0, // GFXMMU_LUT374H
    0x00431e01, // GFXMMU_LUT375L
    0x00074120, // GFXMMU_LUT375H
    0x00421f01, // GFXMMU_LUT376L
    0x00074370, // GFXMMU_LUT376H
    0x00411f01, // GFXMMU_LUT377L
    0x000745b0, // GFXMMU_LUT377H
    0x00402001, // GFXMMU_LUT378L
    0x000747d0, // GFXMMU_LUT378H
    0x00402101, // GFXMMU_LUT379L
    0x000749d0, // GFXMMU_LUT379H
    0x003f2101, // GFXMMU_LUT380L
    0x00074bd0, // GFXMMU_LUT380H
    0x003e2201, // GFXMMU_LUT381L
    0x00074db0, // GFXMMU_LUT381H
    0x003d2301, // GFXMMU_LUT382L
    0x00074f70, // GFXMMU_LUT382H
    0x003d2401, // GFXMMU_LUT383L
    0x00075110, // GFXMMU_LUT383H
    0x003c2501, // GFXMMU_LUT384L
    0x000752a0, // GFXMMU_LUT384H
    0x003b2601, // GFXMMU_LUT385L
    0x00075410, // GFXMMU_LUT385H
    0x00392701, // GFXMMU_LUT386L
    0x00075560, // GFXMMU_LUT386H
    0x00382901, // GFXMMU_LUT387L
    0x00075670, // GFXMMU_LUT387H
    0x00362b01, // GFXMMU_LUT388L
    0x00075750, // GFXMMU_LUT388H
    0x00342d01, // GFXMMU_LUT389L
    0x000757f0  // GFXMMU_LUT389H
};

#ifdef __cplusplus
}
#endif

#endif /* __STM32L4R9I_DISCOVERY_GFXMMU_LUT_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
