#include "XNucleo53L3A2.h"

XNucleo53L3A2 *XNucleo53L3A2::_instance = NULL;


XNucleo53L3A2 *XNucleo53L3A2::instance(vl53L3_DevI2C *ext_i2c)
{
    if (_instance == NULL) {
        _instance = new XNucleo53L3A2(ext_i2c);
    } else {
        printf("Failed to create XNucleo53L3A2 instance\n\r\r\n");
    }
    return _instance;
}

XNucleo53L3A2 *XNucleo53L3A2::instance(vl53L3_DevI2C *ext_i2c,
                                       PinName gpio1_centre,
                                       PinName gpio1_left, PinName gpio1_right)
{
    if (_instance == NULL) {
//        printf("instance %d z\n",ext_i2c);
        _instance = new XNucleo53L3A2(ext_i2c, gpio1_centre, gpio1_left, gpio1_right);
    } else {
        printf("Failed to create XNucleo53L3A2 instance\n\r");
    }
    return _instance;
}


int XNucleo53L3A2::init_board()
{
    printf("init_board \n");
    int status, n_dev = 0;

    sensor_centre->VL53L3_Off();
    sensor_left->VL53L3_Off();
    sensor_right->VL53L3_Off();
    

    
    // On startup or on the shutdown pin going high the VL53l1 devices have a i2c address of 0x52.
    // To initialise then we have to bring up one device at a time This involves raising the shutdown pin for that device,
    // initialising then setting the i2c address to a unique value. Once that is done the shutdown pins don't need to be touched.
    
    // set the shutdown pins to be outputs ( they are inputs on power up)
    stmpe1600_exp1->set_gpio_dir(GPIO_15,OUTPUT);
    stmpe1600_exp0->set_gpio_dir(GPIO_14,OUTPUT);
    stmpe1600_exp0->set_gpio_dir(GPIO_15,OUTPUT);
    
    // set the shutdown pins to low, this will reset the VL53l1s
    stmpe1600_exp1->clear_gpio(GPIO_15);
    stmpe1600_exp0->clear_gpio(GPIO_14);
    stmpe1600_exp0->clear_gpio(GPIO_15);

// select the first VL53l3. It will have i2c address of 0x52. Set the i2c address to
//NEW_SENSOR_CENTRE_ADDRESS
    stmpe1600_exp1->set_gpio(GPIO_15);
        printf("InitSensor \n");
    status = sensor_centre->InitSensor(NEW_SENSOR_CENTRE_ADDRESS);
    if (status) {
        delete sensor_centre;
        delete xshutdown_centre;
        sensor_centre = NULL;
        xshutdown_centre = NULL;
        printf("Sensor centre not present\n\r");
    } else {
        printf("Sensor centre present\n\r");
        n_dev++;
    }
    
    // select the second VL53l3. It will have i2c address of 0x52. Set the i2c address to
    //NEW_SENSOR_LEFT_ADDRESS
    
    stmpe1600_exp0->set_gpio(GPIO_14);

    status = sensor_left->InitSensor(NEW_SENSOR_LEFT_ADDRESS);
    if (status) {
        delete sensor_left;
        delete xshutdown_left;
        sensor_left = NULL;
        xshutdown_left = NULL;
        printf("Sensor left not present\n\r");
    } else {
        printf("Sensor left present\n\r");
        n_dev++;
    }
    
     // select the 3rd VL53l3. It will have i2c address of 0x52. Set the i2c address to
    //NEW_SENSOR_RIGHT_ADDRESS 
    stmpe1600_exp0->set_gpio(GPIO_15);
    status = sensor_right->InitSensor(NEW_SENSOR_RIGHT_ADDRESS);
    if (status) {
        delete sensor_right;
        delete xshutdown_right;
        sensor_right = NULL;
        xshutdown_right = NULL;
        printf("Sensor right not present\n\r");
    } else {
        printf("Sensor right present\n\r");
        n_dev++;
    }

return 0;
    if (n_dev == 0) {
        return 1;
    } else {
        return 0;
    }
}

