/*
 * *** NOTE : By default hardlinks U10, U11, U15 & U18, on the underside of
 *            the X-NUCELO-53L1A1 expansion board are not made/OFF.
 *            These links must be made to allow interrupts from the Satellite boards
 *            to be received.
 *            U11 and U18 must be made/ON to allow interrupts to be received from the
 *            INT_L & INT_R positions; or
 *            U10 and U15 must be made/ON to allow interrupts to be received from the
 *            Alternate INT_L & INT_R positions.
 *            The X_NUCLEO_53L1A2 library defaults to use the INT_L/INT_R positions.
 *            INT_L is available on expansion board Arduino Connector CN5, pin 1 as D8.
 *            Alternate INT_L is on CN5 Connector pin 2 as D9.
 *            INT_R is available on expansion board Arduino Connector CN9, pin 3 as D2.
 *            Alternate INT_R is on CN9 Connector pin 5 as D4.
 *            The pinouts are shown here : https://developer.mbed.org/components/X-NUCLEO-53L1A2/
 */

#include "XNucleo53L1A2.h"

XNucleo53L1A2 *XNucleo53L1A2::_instance = NULL;


XNucleo53L1A2 *XNucleo53L1A2::instance(ToF_DevI2C *ext_i2c)
{
    if (_instance == NULL) {
        _instance = new XNucleo53L1A2(ext_i2c);
    } else {
        printf("Failed to create XNucleo53L1A2 instance\n\r\r\n");
    }
    return _instance;
}

XNucleo53L1A2 *XNucleo53L1A2::instance(ToF_DevI2C *ext_i2c,
                                       PinName gpio1_centre,
                                       PinName gpio1_left, PinName gpio1_right)
{
    if (_instance == NULL) {
//        printf("instance %d z\n",ext_i2c);
        _instance = new XNucleo53L1A2(ext_i2c, gpio1_centre, gpio1_left, gpio1_right);
    } else {
        printf("Failed to create XNucleo53L0A1 instance\n\r");
    }
    return _instance;
}


int XNucleo53L1A2::init_board()
{
    int status, n_dev = 0;

    sensor_centre->VL53L1CB_Off();
    sensor_left->VL53L1CB_Off();
    sensor_right->VL53L1CB_Off();
    int i = 0;
    
    // On startup or on the shutdown pin going high the VL53l1 devices have a i2c address of 0x52.
    // To initialise then we have to bring up one device at a time This involves raising the shutdown pin for that device,
    // initialising then setting the i2c address to a unique value. Once that is done the shutdown pins don't need to be touched.
    
    // set the shutdown pins to be outputs ( they are inputs on power up)
    stmpe1600_exp1->set_gpio_dir(GPIO_15,OUTPUT);
    stmpe1600_exp0->set_gpio_dir(GPIO_14,OUTPUT);
    stmpe1600_exp0->set_gpio_dir(GPIO_15,OUTPUT);
    
    // set the shutdown pins to low, this will reset the VL53l1s
    stmpe1600_exp1->clear_gpio(GPIO_15);
    stmpe1600_exp0->clear_gpio(GPIO_14);
    stmpe1600_exp0->clear_gpio(GPIO_15);

// select the first VL53l1. It will have i2c address of 0x52. Set the i2c address to
//NEW_SENSOR_CENTRE_ADDRESS
    stmpe1600_exp1->set_gpio(GPIO_15);
    status = sensor_centre->InitSensor(NEW_SENSOR_CENTRE_ADDRESS);
    if (status) {
        delete sensor_centre;
        delete xshutdown_centre;
        sensor_centre = NULL;
        xshutdown_centre = NULL;
        printf("Sensor centre not present\n\r");
    } else {
        printf("Sensor centre present\n\r");
        n_dev++;
    }
#if (MBED_VERSION  > 60300) 
    thread_sleep_for(2);
#else
    wait_ms(2);  // NEEDS A DELAY BETWEEN SENSORS
#endif

    // select the second VL53l1. It will have i2c address of 0x52. Set the i2c address to
    //NEW_SENSOR_LEFT_ADDRESS
    
    stmpe1600_exp0->set_gpio(GPIO_14);

    status = sensor_left->InitSensor(NEW_SENSOR_LEFT_ADDRESS);
    if (status) {
        delete sensor_left;
        delete xshutdown_left;
        sensor_left = NULL;
        xshutdown_left = NULL;
        printf("Sensor left not present\n\r");
    } else {
        printf("Sensor left present\n\r");
        n_dev++;
    }

#if (MBED_VERSION  > 60300) 
    thread_sleep_for(50);
#else
    wait_ms(50);  // NEEDS A DELAY BETWEEN SENSORS
#endif 
     // select the 3rd VL53l1. It will have i2c address of 0x52. Set the i2c address to
    //NEW_SENSOR_RIGHT_ADDRESS 
    stmpe1600_exp0->set_gpio(GPIO_15);
    status = sensor_right->InitSensor(NEW_SENSOR_RIGHT_ADDRESS);
    if (status) {
        delete sensor_right;
        delete xshutdown_right;
        sensor_right = NULL;
        xshutdown_right = NULL;
        printf("Sensor right not present\n\r");
    } else {
        printf("Sensor right present\n\r");
        n_dev++;
    }
#if (MBED_VERSION  > 60300) 
    thread_sleep_for(50);
#else
    wait_ms(50);  // NEEDS A DELAY BETWEEN SENSORS
#endif 
    if (n_dev == 0) {
        return 1;
    } else {
        return 0;
    }
}
