#include "XNucleo53L1A1.h"

XNucleo53L1A1 *XNucleo53L1A1::_instance = NULL;


XNucleo53L1A1 *XNucleo53L1A1::instance(vl53L1X_DevI2C *ext_i2c)
{
    if (_instance == NULL) {
        _instance = new XNucleo53L1A1(ext_i2c);
    } else {
        printf("Failed to create XNucleo53L1A1 instance\n\r\r\n");
    }
    return _instance;
}

XNucleo53L1A1 *XNucleo53L1A1::instance(vl53L1X_DevI2C *ext_i2c,
                                       PinName gpio1_centre,
                                       PinName gpio1_left, PinName gpio1_right)
{
    if (_instance == NULL) {
        _instance = new XNucleo53L1A1(ext_i2c, gpio1_centre, gpio1_left, gpio1_right);
    } else {
        printf("Failed to create XNucleo53L0A1 instance\n\r");
    }
    return _instance;
}


int XNucleo53L1A1::init_board()
{
    int status, n_dev = 0;

    sensor_centre->VL53L1_Off();
    sensor_left->VL53L1_Off();
    sensor_right->VL53L1_Off();
    status = sensor_centre->InitSensor(NEW_SENSOR_CENTRE_ADDRESS);
    if (status) {
        delete sensor_centre;
        delete xshutdown_centre;
        sensor_centre = NULL;
        xshutdown_centre = NULL;
        printf("Sensor centre not present\n\r");
    } else {
        printf("Sensor centre present\n\r");
        n_dev++;
    }

    status = sensor_left->InitSensor(NEW_SENSOR_LEFT_ADDRESS);
    if (status) {
        delete sensor_left;
        delete xshutdown_left;
        sensor_left = NULL;
        xshutdown_left = NULL;
        printf("Sensor left not present\n\r");
    } else {
        printf("Sensor left present\n\r");
        n_dev++;
    }

    status = sensor_right->InitSensor(NEW_SENSOR_RIGHT_ADDRESS);
    if (status) {
        delete sensor_right;
        delete xshutdown_right;
        sensor_right = NULL;
        xshutdown_right = NULL;
        printf("Sensor right not present\n\r");
    } else {
        printf("Sensor right present\n\r");
        n_dev++;
    }

    if (n_dev == 0) {
        return 1;
    } else {
        return 0;
    }
}
