/* Define to prevent from recursive inclusion --------------------------------*/


#ifndef __SPI_INTERFACE_H
#define __SPI_INTERFACE_H

#include "pinmap.h"

#ifdef __cplusplus
extern "C" {
#endif
 
     int v53l1x_i2c_write_if(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr, uint16_t NumByteToWrite);
     int v53l1x_i2c_read_if(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr, uint16_t NumByteToWrite);  
     int GetTickCount( uint32_t *ptick_count_ms);      

     int v53l1x_i2c_write_direct(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t NumByteToWrite);	 
	 
	void delete_interrupt_measure_detection_irq();
    void create_interrupt_measure_detection_irq(PinName pin);
	void enable_interrupt_measure_detection_irq();
	void disable_interrupt_measure_detection_irq();
	void attach_interrupt_measure_detection_irq(void (*fptr)(void));
	void set_gpio_pin(PinName pin, int state);

#ifdef __cplusplus
}
#endif


#endif /* __SPI_INTERFACE_H */

