#include "ToF_I2C.h"
#include "pinmap.h"
#include "spi_interface.h"


static   InterruptIn *_gpio1Int;
	  

/* This file is an interface between the c files and the mbed cpp files. */
/* .c files cannot directly access mbed. */

 int v53l1x_i2c_write_if(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                  uint16_t NumByteToWrite) 
{
    
      static ToF_DevI2C *dev_I2C = new ToF_DevI2C(D14, D15);
      
      dev_I2C->frequency(400000);
      
 //   printf("----ToF_i2c_write  %d %d %d %d\n", DeviceAddr, RegisterAddr,NumByteToWrite ,pBuffer[0]); 
      int status = dev_I2C->ToF_i2c_write(pBuffer, DeviceAddr, RegisterAddr, NumByteToWrite);     
//             printf("----ToF_i2c_write %d %d %d %d %d\n",status, DeviceAddr, RegisterAddr,NumByteToWrite ,pBuffer[0]);        
 
       
      return status;       
}

 int v53l1x_i2c_write_direct(uint8_t* pBuffer, uint8_t DeviceAddr,
                  uint16_t NumByteToWrite) 
{
    
    static ToF_DevI2C *dev_I2C = new ToF_DevI2C(D14, D15);
      
    dev_I2C->frequency(400000);
      
     // printf("v53l1x_i2c_write_if %d\n",NumByteToWrite);
    int status = dev_I2C->ToF_i2c_write_direct(pBuffer, DeviceAddr, NumByteToWrite);     
//             printf("----ToF_i2c_write_direct %d %d %d %d %d\n",status, DeviceAddr,NumByteToWrite ,pBuffer[0]);        

     return status;       
}




 int v53l1x_i2c_read_if(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                  uint16_t NumByteToRead) 
{
            
    
      static ToF_DevI2C *dev_I2C = new ToF_DevI2C(D14, D15);
      if (dev_I2C == NULL)
      {
                      printf("v53l1x_i2c_read_if  no pointer%d\n",NumByteToRead);
      }
      dev_I2C->frequency(400000);
    //        printf("v53l1x_i2c_read_if %d\n",NumByteToRead);
      int status = dev_I2C->ToF_i2c_read(pBuffer, DeviceAddr, RegisterAddr, NumByteToRead);   
 //           printf("v53l1x_i2c_read_if %d %d %d %d %d\n",status, DeviceAddr, RegisterAddr,NumByteToRead ,pBuffer[0]);    
  //    delete dev_I2C;    
                       
      return status;       
}


int GetTickCount(
    uint32_t *ptick_count_ms)
{

    /* Returns current tick count in [ms] */

    int status  = 0;

    //*ptick_count_ms = timeGetTime();
    *ptick_count_ms = us_ticker_read() / 1000;

    return status;
}


// routines to create interrupts to handle ranging detection
void create_interrupt_measure_detection_irq(PinName pin)
{
	 _gpio1Int = new InterruptIn(pin);

}

void delete_interrupt_measure_detection_irq()
{
	if ( _gpio1Int != NULL)
	{
		_gpio1Int->disable_irq();
	    delete _gpio1Int;
	}

}

void enable_interrupt_measure_detection_irq()
{
	 if ( _gpio1Int != NULL)
		 _gpio1Int->enable_irq();

}

void disable_interrupt_measure_detection_irq()
{
	 if ( _gpio1Int != NULL)
		 _gpio1Int->disable_irq();
}

void attach_interrupt_measure_detection_irq(void (*fptr)(void))
{
	 if ( _gpio1Int != NULL)
		 _gpio1Int->rise(fptr);
}


void set_gpio_pin(PinName pin, int state)
{
	    DigitalOut sensorshut(pin);
		sensorshut = state;
}