/*
 *  This VL53L1X sensor test application performs range measurements
 *  connecting directly to  the onboard embedded centre sensor, in singleshot, polling mode.
 *  Measured ranges are ouput on the Serial Port, running at 9600 baud.
 *
*
 * This is designed to work with MBed V2 , MBed V5 and MBed V6.
 *
 *
 *  The Reset button can be used to restart the program.
 */
 
 //No_shield_polling_multi_sensor.h.h
 
#include <stdio.h>

#include "mbed.h"
#include "NoShield53L1A1.h"
#include "ToF_I2C.h"
#include <time.h>


// define the i2c comms pins
#define I2C_SDA   D14 
#define I2C_SCL   D15 

#define MeasurementTiming 70


#define NUM_SENSORS 3

static NoShield53L1 *board=NULL; 
Serial pc(SERIAL_TX, SERIAL_RX); 



VL53L1_Dev_t                   devCentre;
VL53L1_Dev_t                   devLeft;
VL53L1_Dev_t                   devRight;
VL53L1_DEV                     Dev = &devCentre;


 
/*=================================== Main ==================================
=============================================================================*/
int main()
{   
    int status;
    VL53L1X * Sensor;
    uint8_t ToFSensor = 1; // 0=Left, 1=Center(default), 2=Right

    pc.baud(115200);  // baud rate is important as printf statements take a lot of time
    printf("No_shield_polling_multi_sensor\r\n");


// create i2c interface
    ToF_DevI2C *dev_I2C = new ToF_DevI2C(I2C_SDA, I2C_SCL);

    
    /* no expansion board so don't use stmpe1600, define the interrupt pins */
    board = NoShield53L1::instance(dev_I2C, A2, D8, D2);
    printf("board created!\r\n");

    /* define the shutdown pins */
    status = board->init_board(D9,D4,D3);
    if (status) {
        printf("Failed to init board!\r\n");
        return 0;
    }
       
        
    printf("board initiated! - %d\r\n", status);
                                                
    for (ToFSensor=0;ToFSensor< NUM_SENSORS ;ToFSensor++){  // configure each sensor in turn
        switch(ToFSensor){
            case 0:
                if (board->sensor_centre== NULL ) continue;
                Dev=&devCentre;
                Sensor=board->sensor_centre;
                Dev->i2c_slave_address = NEW_SENSOR_CENTRE_ADDRESS;
                printf("configuring centre channel \n");
                break;
            case 1:
                if (board->sensor_left== NULL ) continue;
                Dev=&devLeft; 
                Sensor=board->sensor_left;
                Dev->i2c_slave_address = NEW_SENSOR_LEFT_ADDRESS;
                printf("configuring left channel \n");
                break;
            case 2:
                if (board->sensor_right== NULL ) continue;
                Dev=&devRight;  
                Sensor=board->sensor_right;
                Dev->i2c_slave_address = NEW_SENSOR_RIGHT_ADDRESS;
                printf("configuring right channel \n");
                break;      
        }
        
        Dev->comms_speed_khz = 400;
        Dev->comms_type = 1;

/* Device Initialization and setting */

        status = Sensor->vl53L1_DataInit();
    
        status = Sensor->vl53L1_SetDistanceMode(VL53L1_DISTANCEMODE_LONG);
    
        status = Sensor->vl53L1_SetMeasurementTimingBudgetMicroSeconds( MeasurementTiming * 1000);
                     
        status = Sensor->vl53L1_SmudgeCorrectionEnable(VL53L1_SMUDGE_CORRECTION_SINGLE);
        status = Sensor->vl53L1_SetXTalkCompensationEnable(1);
        status = Sensor->vl53L1_StopMeasurement();  
        status = Sensor->vl53L1_ClearInterruptAndStartMeasurement();

    } // end of for loop

     wait_ms(100);
     //configured. no loop forever reading    
     while(1) {     
        for (ToFSensor=0;ToFSensor< NUM_SENSORS ;ToFSensor++){
            switch(ToFSensor){
                case 0:
                    if (board->sensor_centre== NULL ) continue;
                    Dev=&devCentre;
                    Sensor=board->sensor_centre;
                    Dev->i2c_slave_address = NEW_SENSOR_CENTRE_ADDRESS;
                    break;
                case 1:
                    if (board->sensor_left== NULL ) continue;
                    Dev=&devLeft; 
                    Sensor=board->sensor_left;
                    Dev->i2c_slave_address = NEW_SENSOR_LEFT_ADDRESS;
                    break;
                case 2:
                    if (board->sensor_right== NULL ) continue;
                    Dev=&devRight;
                    Sensor=board->sensor_right;
                    Dev->i2c_slave_address = NEW_SENSOR_RIGHT_ADDRESS;
                    break;   
                default:   
                    printf("default \n");
                    break;
            }  // switch
        

            status = Sensor->vl53L1_StartMeasurement();  
            status = Sensor->vl53L1_WaitMeasurementDataReady();
            
            VL53L1_MultiRangingData_t MultiRangingData;
            VL53L1_MultiRangingData_t *pMultiRangingData = &MultiRangingData;   
//            VL53L1_MultiRangingData_t *pMultiRangingData;
// the first measurement always returns a fail. So we do two and use the second measurement
            if(!status)
            {
                status = Sensor->vl53L1_GetMultiRangingData( pMultiRangingData);

                int no_of_object_found=pMultiRangingData->NumberOfObjectsFound;

                if (( no_of_object_found < 10 ) && ( no_of_object_found != 0 ))
                {
                    for(int j=0;j<no_of_object_found;j++){
                        if ((pMultiRangingData->RangeData[j].RangeStatus == VL53L1_RANGESTATUS_RANGE_VALID) || 
                            (pMultiRangingData->RangeData[j].RangeStatus == VL53L1_RANGESTATUS_RANGE_VALID_NO_WRAP_CHECK_FAIL))
                        {
                            printf("centre\t status=%d, \t D=%5dmm, \t Signal=%2.2f Mcps, \t Ambient=%2.2f Mcps \n",
                            pMultiRangingData->RangeData[j].RangeStatus,
                            pMultiRangingData->RangeData[j].RangeMilliMeter,
                            pMultiRangingData->RangeData[j].SignalRateRtnMegaCps/65536.0,
                            pMultiRangingData->RangeData[j].AmbientRateRtnMegaCps/65536.0);
                        }
                    }
                }
            } // if status
            else
            {
                printf("VL53L1_WaitMeasurementDataReady failed %d \n",status);
            }

            status = Sensor->vl53L1_ClearInterruptAndStartMeasurement();                                     
            status = Sensor->vl53L1_WaitMeasurementDataReady();
            if(!status)
            {
                status = Sensor->vl53L1_GetMultiRangingData( pMultiRangingData);
                int no_of_object_found=pMultiRangingData->NumberOfObjectsFound;

                if (( no_of_object_found < 10 ) && ( no_of_object_found != 0 ))
                {

                    for(int j=0;j<no_of_object_found;j++){
                        if ((pMultiRangingData->RangeData[j].RangeStatus == VL53L1_RANGESTATUS_RANGE_VALID) || 
                            (pMultiRangingData->RangeData[j].RangeStatus == VL53L1_RANGESTATUS_RANGE_VALID_NO_WRAP_CHECK_FAIL))
                        {
                            printf("centre\t status=%d, \t D=%5dmm, \t Signal=%2.2f Mcps, \t Ambient=%2.2f Mcps \n",
                            pMultiRangingData->RangeData[j].RangeStatus,
                            pMultiRangingData->RangeData[j].RangeMilliMeter,
                            pMultiRangingData->RangeData[j].SignalRateRtnMegaCps/65536.0,
                            pMultiRangingData->RangeData[j].AmbientRateRtnMegaCps/65536.0);
                        }
                    }  // end of for
                }  /// if no_of_object_found

                status = Sensor->vl53L1_ClearInterruptAndStartMeasurement();
            

            status = Sensor->vl53L1_StopMeasurement();  
        } //(!status)
        
    }  //for each sensor
    

} /// while(1)

}
