/*
 *  This application performs range measurements
 *  connecting directly to  the onboard embedded centre sensor, in multizone, polling mode.
 *  Measured ranges are ouput on the Serial Port, running at 115200 baud.
 *
 *
 * This is designed to work with MBed V2 ,MBed V5 and MBed V6.
 *
 *
 *  The Reset button can be used to restart the program.
 */
 
#include <stdio.h>

#include "mbed.h"
#include "NoShield53L1A1.h"
#include "ToF_I2C.h"
#include <time.h>


// define the i2c comms pins
#define I2C_SDA   D14 
#define I2C_SCL   D15 



static NoShield53L1 *board=NULL;
Serial pc(SERIAL_TX, SERIAL_RX); 

void process_interrupt( VL53L1X * sensor,VL53L1_DEV dev );
void print_results( int devSpiNumber, VL53L1_MultiRangingData_t *pMultiRangingData );

VL53L1_Dev_t                   devCentre;
VL53L1_Dev_t                   devLeft;
VL53L1_Dev_t                   devRight;
VL53L1_DEV                     Dev = &devCentre;

 
/*=================================== Main ==================================
=============================================================================*/
int main()
{   
    int status;
    VL53L1X * Sensor;
    uint16_t wordData;


    pc.baud(115200);  // baud rate is important as printf statements take a lot of time
    printf("Polling single multizone\r\n");

// create i2c interface
    ToF_DevI2C *dev_I2C = new ToF_DevI2C(I2C_SDA, I2C_SCL);
    
    /* creates the 53L1A1 expansion board singleton obj */
   board = NoShield53L1::instance(dev_I2C, A2, D8, D2);
    
    printf("board created!\r\n");
    
        /* define the shutdown pins */
    status = board->init_board(D9,D4,D3);
    if (status) {
        printf("Failed to init board!\r\n");
        return 0;
    }
       
        
    printf("board initiated! - %d\r\n", status);
  // create the sensor controller classes                                              



    Dev=&devCentre;
    Sensor=board->sensor_centre;
    Dev->i2c_slave_address = NEW_SENSOR_CENTRE_ADDRESS;
    printf("configuring centre channel \n");

    
// configure the sensors
    Dev->comms_speed_khz = 400;

    Dev->comms_type = 1;

    Sensor->VL53L1_RdWord(Dev, 0x01, &wordData);
    printf("VL53L1X: %02X   %d\n\r", wordData,Dev->i2c_slave_address);
/* Device Initialization and setting */  
    status = Sensor->vl53L1_DataInit();
    status = Sensor->vl53L1_StaticInit();
    status = Sensor->vl53L1_SetPresetMode( VL53L1_PRESETMODE_MULTIZONES_SCANNING);
      status = Sensor->vl53L1_SetDistanceMode( VL53L1_DISTANCEMODE_LONG);
//     status = Sensor->vl53L1_SetMeasurementTimingBudgetMicroSeconds( 100 * 1000);
//      status = Sensor->vl53L1_SetInterMeasurementPeriodMilliSeconds( 100);
   
    
    VL53L1_RoiConfig_t roiConfig;
    roiConfig.NumberOfRoi =3;
    roiConfig.UserRois[0].TopLeftX = 0;
    roiConfig.UserRois[0].TopLeftY = 9; 
    roiConfig.UserRois[0].BotRightX = 4;
    roiConfig.UserRois[0].BotRightY = 5; 
    roiConfig.UserRois[1].TopLeftX = 5;
    roiConfig.UserRois[1].TopLeftY = 9; 
    roiConfig.UserRois[1].BotRightX = 9;
    roiConfig.UserRois[1].BotRightY = 4; 
    roiConfig.UserRois[2].TopLeftX = 11;
    roiConfig.UserRois[2].TopLeftY = 9; 
    roiConfig.UserRois[2].BotRightX = 15;
    roiConfig.UserRois[2].BotRightY = 5; 
    status = Sensor->vl53L1_SetROI( &roiConfig);
    printf("VL53L1_SetROI %d \n",status);

    devCentre.i2c_slave_address = NEW_SENSOR_CENTRE_ADDRESS;
    status = board->sensor_centre->vl53L1_StartMeasurement();  

       // looping polling for results
    while (1)
    {
        VL53L1_MultiRangingData_t MultiRangingData;
        VL53L1_MultiRangingData_t *pMultiRangingData = &MultiRangingData;    
        
        // wait for result
        status = board->sensor_centre->vl53L1_WaitMeasurementDataReady();  
        // get the result
        status = board->sensor_centre->vl53L1_GetMultiRangingData( pMultiRangingData);
        // if valid, print it
        if(status==0) {
            print_results(devCentre.i2c_slave_address, pMultiRangingData );
             status = board->sensor_centre->vl53L1_ClearInterruptAndStartMeasurement();

        } //if(status==0) 
        else
        {
            printf("VL53L1_GetMultiRangingData centre %d \n",status);
        }
                
        wait_ms( 1 * 10);                   
    }
}
    
    
    
 // prints the range result seen above   
void print_results( int devSpiNumber, VL53L1_MultiRangingData_t *pMultiRangingData )
{
            int no_of_object_found=pMultiRangingData->NumberOfObjectsFound;
            
            int RoiNumber=pMultiRangingData->RoiNumber;
//            int RoiStatus=pMultiRangingData->RoiStatus;

            if (( no_of_object_found < 10 ) &&  ( no_of_object_found != 0)) 
            {
                
  //              printf("MZI Count=%5d, ", pMultiRangingData->StreamCount);
   //             printf("RoiNumber%1d, ", RoiNumber);
   //               printf("RoiStatus=%1d, \n", RoiStatus);
                for(int j=0;j<no_of_object_found;j++){
                    if ((pMultiRangingData->RangeData[j].RangeStatus == VL53L1_RANGESTATUS_RANGE_VALID) || 
                        (pMultiRangingData->RangeData[j].RangeStatus == VL53L1_RANGESTATUS_RANGE_VALID_NO_WRAP_CHECK_FAIL))
                    {
                        printf("*****************\t spiAddr=%d \t RoiNumber=%d   \t status=%d, \t D=%5dmm, \t Signal=%2.2f Mcps, \t Ambient=%2.2f Mcps \n",
                        devSpiNumber,
                        RoiNumber,
                        pMultiRangingData->RangeData[j].RangeStatus,
                        pMultiRangingData->RangeData[j].RangeMilliMeter,
                        pMultiRangingData->RangeData[j].SignalRateRtnMegaCps/65536.0,
                        pMultiRangingData->RangeData[j].AmbientRateRtnMegaCps/65536.0);
                    }
                    else
                    {
//                               printf("RangeStatus %d %d\n",j, pMultiRangingData->RangeData[j].RangeStatus);
                    }
                }
            } // if (( no_of_object_found < 10 ) &&  ( no_of_object_found != 0)) 
            else
            {
//                       printf("no_of_object_found %d \n",no_of_object_found);
            }

}    
     
  