#include "ToF_I2C.h"
#include "spi_interface.h"


/* This file is an interface between the c platform file and the mbed cpp files. */

 int v53l1cb_i2c_write_if(void *dev_I2C, uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                  uint16_t NumByteToWrite) 
{
    int status = 0;
    ToF_DevI2C *I2C= (ToF_DevI2C*)dev_I2C;
    //I2C->frequency(400000);
    status = I2C->ToF_i2c_write(pBuffer, DeviceAddr, RegisterAddr, NumByteToWrite);
    return status;
}



 int v53l1cb_i2c_read_if(void *dev_I2C, uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                  uint16_t NumByteToRead) 
{
    int status  = 0;
    ToF_DevI2C *I2C= (ToF_DevI2C*)dev_I2C;
    // I2C->frequency(400000);
    status = I2C->ToF_i2c_read(pBuffer, DeviceAddr, RegisterAddr, NumByteToRead);
    return status;
}


int GetTickCount(
    uint32_t *ptick_count_ms)
{
    /* Returns current tick count in [ms] */
    int status  = 0;
    //*ptick_count_ms = timeGetTime();
    *ptick_count_ms = us_ticker_read() / 1000;
    return status;
}
