/**
 ******************************************************************************
 * @file    vl53l1x_class.cpp
 * @author  JS
 * @version V0.0.1
 * @date    15-January-2019
 * @brief   Implementation file for the VL53L1 sensor component driver class
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2018 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/

/* Includes */
#include <stdlib.h>
#include "VL53L1CB.h"
/************************************************/
#include "vl53l1_platform_user_config.h"
#include "vl53l1_def.h"
#include "vl53l1_wait.h"
#include "vl53l1_api.h"
#include "vl53l1_api_debug.h"
#include "vl53l1_api_strings.h"
#include "vl53l1_preset_setup.h"
#include "vl53l1_api_calibration.h"
#include "vl53l1_nvm_structs.h"
#include "vl53l1_nvm.h"
#include "vl53l1_core.h"
#include "vl53l1_register_funcs.h"
/***********************************************************/
#include "vl53l1_api_core.h"

#include "vl53l1_configuration.h"


#ifndef MIN
#define MIN(v1, v2) ((v1) < (v2) ? (v1) : (v2))
#endif
#ifndef MAX
#define MAX(v1, v2) ((v1) < (v2) ? (v2) : (v1))
#endif


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetSWVersion(VL53L1_Version_t *pVersion)
{
    VL53L1CB_ERROR Status = 0;

    pVersion->major = VL53L1CB_IMPLEMENTATION_VER_MAJOR;
    pVersion->minor = VL53L1CB_IMPLEMENTATION_VER_MINOR;
    pVersion->build = VL53L1CB_IMPLEMENTATION_VER_SUB;
    pVersion->revision = VL53L1CB_IMPLEMENTATION_VER_REVISION;
    return Status;
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetI2CAddress(uint8_t new_address)
{
    VL53L1CB_ERROR status = 0;
    if ( Device->i2c_slave_address != new_address)
    {
    	status = (VL53L1CB_ERROR)VL53L1_SetDeviceAddress(Device,new_address);
        printf("VL53L1_SetI2CAddress %d to %d status = %d\n", Device->i2c_slave_address,new_address,status);
        Device->i2c_slave_address = new_address;
    }
    return status;
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_SensorInit()
{
    VL53L1CB_ERROR status = 0;

    /* Device Initialization and setting */
    status = VL53L1CB_DataInit();
    if (status != 0) {
        return status;
    }
    status = VL53L1CB_StaticInit();
    if (status != 0) {
        return status;
    }

    return status;
}


    /* Write and read functions from I2C */


VL53L1CB_ERROR VL53L1CB::VL53L1CB_WaitDeviceBooted()
{

    return VL53L1_WaitDeviceBooted(Device);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetVersion(VL53L1_Version_t *pVersion)
{

    return VL53L1_GetVersion(pVersion);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetProductRevision(
    uint8_t *pProductRevisionMajor, uint8_t *pProductRevisionMinor)
{
    return VL53L1_GetProductRevision(Device,pProductRevisionMajor,pProductRevisionMinor);
}

//******************************************************************

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetDeviceInfo(
    VL53L1_DeviceInfo_t *pVL53L1_DeviceInfo)
{
    return VL53L1_GetDeviceInfo(Device,pVL53L1_DeviceInfo);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetUID( uint64_t *pUid)
{
    return VL53L1_GetUID(Device,pUid);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetRangeStatusString(uint8_t RangeStatus,
    char *pRangeStatusString)
{
    return VL53L1_GetRangeStatusString(RangeStatus,
        pRangeStatusString);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetPalErrorString(VL53L1CB_ERROR PalErrorCode,
    char *pPalErrorString)
{
    return VL53L1_GetPalErrorString(PalErrorCode,pPalErrorString);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetPalStateString(VL53L1_State PalStateCode,
    char *pPalStateString)
{
    return VL53L1_GetPalStateString(PalStateCode, pPalStateString);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetPalState(VL53L1_State *pPalState)
{
    return VL53L1_GetPalState(Device, pPalState);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_DataInit()
{
    return VL53L1_DataInit( Device);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_StaticInit()
{
    return VL53L1_StaticInit( Device);
}


 VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetPresetMode(VL53L1_PresetModes PresetMode)
{
    return VL53L1_SetPresetMode(Device,PresetMode);
}


 VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetPresetMode( VL53L1_PresetModes *pPresetMode)
{
    return VL53L1_GetPresetMode(Device,pPresetMode);
}


 VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetDistanceMode(VL53L1_DistanceModes DistanceMode)
{
    return VL53L1_SetDistanceMode(Device,DistanceMode);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetDistanceMode(VL53L1_DistanceModes *pDistanceMode)
{
    return VL53L1_GetDistanceMode(Device,pDistanceMode);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetOutputMode(VL53L1_OutputModes OutputMode)
{
    return VL53L1_SetOutputMode(Device,OutputMode);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetOutputMode(VL53L1_OutputModes *pOutputMode)
{
    return VL53L1_GetOutputMode(Device,pOutputMode);
}



VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetMeasurementTimingBudgetMicroSeconds(
                                   uint32_t MeasurementTimingBudgetMicroSeconds)
{
    return VL53L1_SetMeasurementTimingBudgetMicroSeconds(Device,
                                           MeasurementTimingBudgetMicroSeconds);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetMeasurementTimingBudgetMicroSeconds(
                                 uint32_t *pMeasurementTimingBudgetMicroSeconds)
{
    return VL53L1_GetMeasurementTimingBudgetMicroSeconds(Device,
                                        pMeasurementTimingBudgetMicroSeconds);
}



VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetInterMeasurementPeriodMilliSeconds(
    uint32_t InterMeasurementPeriodMilliSeconds)
{   
    return VL53L1_SetInterMeasurementPeriodMilliSeconds(Device,InterMeasurementPeriodMilliSeconds);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetInterMeasurementPeriodMilliSeconds(
    uint32_t *pInterMeasurementPeriodMilliSeconds)
{
    return VL53L1_GetInterMeasurementPeriodMilliSeconds(Device,pInterMeasurementPeriodMilliSeconds);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetDmaxReflectance(FixPoint1616_t DmaxReflectance)
{

    return VL53L1_SetDmaxReflectance(Device,DmaxReflectance);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetDmaxReflectance(
                                           FixPoint1616_t *pDmaxReflectance)
{
    return VL53L1_GetDmaxReflectance(Device,pDmaxReflectance);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetDmaxMode(VL53L1_DeviceDmaxModes DmaxMode)
{
    return VL53L1_SetDmaxMode(Device,DmaxMode);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetDmaxMode(
    VL53L1_DeviceDmaxModes *pDmaxMode)
{
    return VL53L1_GetDmaxMode(Device,pDmaxMode);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetNumberOfLimitCheck(uint16_t *pNumberOfLimitCheck)
{
    return VL53L1_GetNumberOfLimitCheck(pNumberOfLimitCheck);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetLimitCheckInfo(uint16_t LimitCheckId,
    char *pLimitCheckString)
{
    return VL53L1_GetLimitCheckInfo(LimitCheckId,
        pLimitCheckString);

}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetLimitCheckStatus(uint16_t LimitCheckId,
    uint8_t *pLimitCheckStatus)
{
    return VL53L1_GetLimitCheckStatus(Device,LimitCheckId,pLimitCheckStatus);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetLimitCheckEnable(uint16_t LimitCheckId,
    uint8_t LimitCheckEnable)
{

    return VL53L1_SetLimitCheckEnable(Device,LimitCheckId,LimitCheckEnable);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetLimitCheckEnable(uint16_t LimitCheckId,
    uint8_t *pLimitCheckEnable)
{
    return VL53L1_GetLimitCheckEnable(Device,LimitCheckId,pLimitCheckEnable);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetLimitCheckValue( uint16_t LimitCheckId,
    FixPoint1616_t LimitCheckValue)
{
    return VL53L1_SetLimitCheckValue(Device,LimitCheckId,LimitCheckValue);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetLimitCheckValue( uint16_t LimitCheckId,
    FixPoint1616_t *pLimitCheckValue)
{
    return VL53L1_GetLimitCheckValue(Device,LimitCheckId,pLimitCheckValue);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetLimitCheckCurrent( uint16_t LimitCheckId,
    FixPoint1616_t *pLimitCheckCurrent)
{
    return VL53L1_GetLimitCheckCurrent(Device,LimitCheckId,pLimitCheckCurrent);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetMaxNumberOfROI( uint8_t *pMaxNumberOfROI)
{
    return VL53L1_GetMaxNumberOfROI(Device,pMaxNumberOfROI);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetROI( VL53L1_RoiConfig_t *pRoiConfig)
{

    return VL53L1_SetROI(Device,pRoiConfig);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetROI(VL53L1_RoiConfig_t *pRoiConfig)
{
    return VL53L1_GetROI(Device,pRoiConfig);
}




VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetNumberOfSequenceSteps(uint8_t *pNumberOfSequenceSteps)
{
    VL53L1CB_ERROR Status = VL53L1_ERROR_NONE;

 //   SUPPRESS_UNUSED_WARNING(Dev);

 //   LOG_FUNCTION_START("");

    *pNumberOfSequenceSteps = VL53L1_SEQUENCESTEP_NUMBER_OF_ITEMS;

//    LOG_FUNCTION_END(Status);
    return Status;
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetSequenceStepsInfo(VL53L1_SequenceStepId SequenceStepId,
    char *pSequenceStepsString)
{
    return VL53L1_GetSequenceStepsInfo(SequenceStepId,pSequenceStepsString);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetSequenceStepEnable(VL53L1_SequenceStepId SequenceStepId,
                                                    uint8_t SequenceStepEnabled)
{

    return VL53L1_SetSequenceStepEnable(Device,SequenceStepId,SequenceStepEnabled);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetSequenceStepEnable(VL53L1_SequenceStepId SequenceStepId, 
                                                    uint8_t *pSequenceStepEnabled)
{
    return VL53L1_GetSequenceStepEnable(Device,SequenceStepId,pSequenceStepEnabled);
}



VL53L1CB_ERROR VL53L1CB::VL53L1CB_StartMeasurement()
{
    return VL53L1_StartMeasurement(Device);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_StopMeasurement()
{
    return VL53L1_StopMeasurement(Device);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_ClearInterruptAndStartMeasurement()
{

    return VL53L1_ClearInterruptAndStartMeasurement(Device);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetMeasurementDataReady(uint8_t *pMeasurementDataReady)
{
    return VL53L1_GetMeasurementDataReady(Device, pMeasurementDataReady);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_WaitMeasurementDataReady()
{
    return VL53L1_WaitMeasurementDataReady(Device);
}


//******************************************************************



VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetCalibrationData(
        VL53L1_CalibrationData_t  *pCalibrationData)
{
    
    VL53L1CB_ERROR Status = VL53L1_ERROR_NONE;
    Status = VL53L1_GetCalibrationData(Device,pCalibrationData);

    return Status;
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetRangingMeasurementData(
    VL53L1_RangingMeasurementData_t *pRangingMeasurementData)
{
//              printf("   VL53L1_GetRangingMeasurementData 000  \n");  
    VL53L1CB_ERROR Status = VL53L1_ERROR_NONE;
    Status = VL53L1_GetRangingMeasurementData(Device,pRangingMeasurementData);

    return Status;
}





VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetMultiRangingData(
        VL53L1_MultiRangingData_t *pMultiRangingData)
{
    return VL53L1_GetMultiRangingData(Device,pMultiRangingData);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetAdditionalData(
        VL53L1_AdditionalData_t *pAdditionalData)
{
    return VL53L1_GetAdditionalData(Device, pAdditionalData);
}



VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetTuningParameter(
        uint16_t TuningParameterId, int32_t TuningParameterValue)
{
    return VL53L1_SetTuningParameter(Device,TuningParameterId,TuningParameterValue);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetTuningParameter(
        uint16_t TuningParameterId, int32_t *pTuningParameterValue)
{

    return VL53L1_GetTuningParameter(Device,TuningParameterId,pTuningParameterValue);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetXTalkCompensationEnable(
    uint8_t XTalkCompensationEnable)
{

    return  VL53L1_SetXTalkCompensationEnable(Device,XTalkCompensationEnable);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetXTalkCompensationEnable(
    uint8_t *pXTalkCompensationEnable)
{
    VL53L1CB_ERROR Status = VL53L1_ERROR_NONE;

  //  LOG_FUNCTION_START("");

    VL53L1_GetXTalkCompensationEnable(
        Device,
        pXTalkCompensationEnable);

  //  LOG_FUNCTION_END(Status);
    return Status;
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_PerformXTalkCalibration(
        uint8_t CalibrationOption)
{

    return VL53L1_PerformXTalkCalibration(Device,CalibrationOption);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetOffsetCalibrationMode(
        VL53L1_OffsetCalibrationModes OffsetCalibrationMode)
{
    return VL53L1_SetOffsetCalibrationMode(Device,OffsetCalibrationMode);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetOffsetCorrectionMode(
        VL53L1_OffsetCorrectionModes OffsetCorrectionMode)
{
    return  VL53L1_SetOffsetCorrectionMode(Device,OffsetCorrectionMode);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_PerformOffsetCalibration(
    int32_t CalDistanceMilliMeter, FixPoint1616_t CalReflectancePercent)
{
    return VL53L1_PerformOffsetCalibration(Device,CalDistanceMilliMeter,CalReflectancePercent);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_PerformOffsetSimpleCalibration(
    int32_t CalDistanceMilliMeter)
{
    return VL53L1_PerformOffsetSimpleCalibration(Device,CalDistanceMilliMeter);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_PerformOffsetZeroDistanceCalibration()
{
    return VL53L1_PerformOffsetZeroDistanceCalibration(Device);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_PerformOffsetPerVcselCalibration(int32_t CalDistanceMilliMeter)
{
    return VL53L1_PerformOffsetPerVcselCalibration(Device,CalDistanceMilliMeter);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetCalibrationData(
        VL53L1_CalibrationData_t *pCalibrationData)
{
    return VL53L1_SetCalibrationData(Device,pCalibrationData);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetZoneCalibrationData(
        VL53L1_ZoneCalibrationData_t *pZoneCalibrationData)
{
    return VL53L1_SetZoneCalibrationData(Device, pZoneCalibrationData);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetZoneCalibrationData(
        VL53L1_ZoneCalibrationData_t  *pZoneCalibrationData)
{
    return VL53L1_GetZoneCalibrationData(Device, pZoneCalibrationData);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SmudgeCorrectionEnable(
        VL53L1_SmudgeCorrectionModes Mode)
        
{
    return VL53L1_SmudgeCorrectionEnable(Device, Mode);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetOpticalCenter(
        FixPoint1616_t *pOpticalCenterX,
        FixPoint1616_t *pOpticalCenterY)
{
    return VL53L1_GetOpticalCenter(Device,pOpticalCenterX,pOpticalCenterY);
}

VL53L1CB_ERROR VL53L1CB::VL53L1CB_SetThresholdConfig(VL53L1_DetectionConfig_t *pConfig)
{
    return VL53L1_SetThresholdConfig(Device,pConfig);
}


VL53L1CB_ERROR VL53L1CB::VL53L1CB_GetThresholdConfig(VL53L1_DetectionConfig_t *pConfig)
{
    return VL53L1_GetThresholdConfig(Device,pConfig);
}



int VL53L1CB::handle_irq(uint16_t *distance)
{
    int status;
    status = get_measurement(distance);
    enable_interrupt_measure_detection_irq();
    return status;
}

int VL53L1CB::get_measurement(uint16_t *distance)
{
    int status = 0;
    VL53L1_RangingMeasurementData_t RangingMeasurementData;

    status = VL53L1CB_GetRangingMeasurementData(&RangingMeasurementData);
    *distance = RangingMeasurementData.RangeMilliMeter;
    status = VL53L1CB_ClearInterruptAndStartMeasurement();

    return status;
}

int VL53L1CB::start_measurement(void (*fptr)(void))
{
    int status = 0;

    if (_gpio1Int == NULL) {
        printf("GPIO1 Error\r\n");
        return 1;
    }

    VL53L1CB_StopMeasurement(); // it is safer to do this while sensor is stopped

    attach_interrupt_measure_detection_irq(fptr);
    enable_interrupt_measure_detection_irq();

    status = VL53L1CB_StartMeasurement();

    return status;
}

int VL53L1CB::stop_measurement()
{
    int status = 0;

    if (status == 0) {
        status = VL53L1CB_StopMeasurement();
    }

    return status;
}
