#include "ToF_I2C.h"
#include "spi_interface.h"

/* This file is an interface between the c files and the mbed cpp files. */

 int v53l1x_i2c_write_if(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                  uint16_t NumByteToWrite) 
{
    
      static ToF_DevI2C *dev_I2C = new ToF_DevI2C(D14, D15);
      
      dev_I2C->frequency(400000);
      
     // printf("v53l1x_i2c_write_if %d\n",NumByteToWrite);
      int status = dev_I2C->ToF_i2c_write(pBuffer, DeviceAddr, RegisterAddr, NumByteToWrite);     
     
      if(status)
      {
          delete dev_I2C;   
          return -1;
      }     
       
      return status;       
}



 int v53l1x_i2c_read_if(uint8_t* pBuffer, uint8_t DeviceAddr, uint16_t RegisterAddr,
                  uint16_t NumByteToRead) 
{
            
    
      static ToF_DevI2C *dev_I2C = new ToF_DevI2C(D14, D15);
      if (dev_I2C == NULL)
      {
                      printf("v53l1x_i2c_read_if  no pointer%d\n",NumByteToRead);
      }
      dev_I2C->frequency(400000);
    //        printf("v53l1x_i2c_read_if %d\n",NumByteToRead);
      int status = dev_I2C->ToF_i2c_read(pBuffer, DeviceAddr, RegisterAddr, NumByteToRead);   
    //        printf("v53l1x_i2c_read_if %d %d %d %d %d\n",status, DeviceAddr, RegisterAddr,NumByteToRead ,pBuffer[0]);    
     // delete dev_I2C;    
                       
      return status;       
}


int GetTickCount(
    uint32_t *ptick_count_ms)
{

    /* Returns current tick count in [ms] */

    int status  = 0;

    //*ptick_count_ms = timeGetTime();
    *ptick_count_ms = us_ticker_read() / 1000;

    return status;
}
